/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.resolve;

import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.resolve.UUIDResolveStrategy;
import com.janboerman.invsee.spigot.internal.CompletedEmpty;
import com.janboerman.invsee.utils.CaseInsensitiveMap;
import com.janboerman.invsee.utils.UUIDHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class UUIDBungeeCordStrategy
implements UUIDResolveStrategy,
PluginMessageListener {
    private static final String BUNGEECORD_CHANNEL = "BungeeCord";
    private static final String UUIDOther_SUBCHANNEL = "UUIDOther";
    private final Plugin plugin;
    private final Scheduler scheduler;
    private final Map<String, CompletableFuture<Optional<UUID>>> futureMap = Collections.synchronizedMap(new CaseInsensitiveMap());

    public UUIDBungeeCordStrategy(Plugin plugin, Scheduler scheduler) {
        this.plugin = Objects.requireNonNull(plugin);
        this.scheduler = Objects.requireNonNull(scheduler);
        Server server = plugin.getServer();
        Messenger messenger = server.getMessenger();
        messenger.registerIncomingPluginChannel(plugin, BUNGEECORD_CHANNEL, (PluginMessageListener)this);
        messenger.registerOutgoingPluginChannel(plugin, BUNGEECORD_CHANNEL);
    }

    @Override
    public CompletableFuture<Optional<UUID>> resolveUniqueId(String userName) {
        Server server = this.plugin.getServer();
        Player player = null;
        Iterator iterator = server.getOnlinePlayers().iterator();
        if (iterator.hasNext()) {
            Player p;
            player = p = (Player)iterator.next();
        }
        if (player == null) {
            return CompletedEmpty.the();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(UUIDOther_SUBCHANNEL);
            dataOutputStream.writeUTF(userName);
            dataOutputStream.close();
            byte[] pluginMessage = byteArrayOutputStream.toByteArray();
            player.sendPluginMessage(this.plugin, BUNGEECORD_CHANNEL, pluginMessage);
            CompletableFuture _future = new CompletableFuture();
            this.scheduler.executeLaterAsync(() -> _future.cancel(true), 100L);
            CompletionStage future = _future.exceptionally(throwable -> {
                if (!(throwable instanceof CancellationException) && !(throwable instanceof TimeoutException)) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not request " + userName + "'s UUID from BungeeCord", (Throwable)throwable);
                }
                this.futureMap.remove(userName);
                return Optional.empty();
            });
            this.futureMap.put(userName, (CompletableFuture<Optional<UUID>>)future);
            return future;
        }
        catch (IOException e) {
            return CompletedEmpty.the();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (BUNGEECORD_CHANNEL.equals(channel)) {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(message));
            try {
                String subChannel = dataInputStream.readUTF();
                if (UUIDOther_SUBCHANNEL.equals(subChannel)) {
                    String userName = dataInputStream.readUTF();
                    String uuid = dataInputStream.readUTF();
                    CompletableFuture<Optional<UUID>> future = this.futureMap.remove(userName);
                    if (future != null) {
                        future.complete(Optional.of(UUIDHelper.dashed(uuid)));
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

