/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.resolve;

import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.resolve.NameResolveStrategy;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.TechsCode.UltraPermissions.UltraPermissions;
import me.TechsCode.UltraPermissions.UltraPermissionsAPI;
import me.TechsCode.UltraPermissions.storage.collection.UserList;
import me.TechsCode.UltraPermissions.storage.objects.User;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.PermissionsManager;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitPlugin;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.UserManager;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.dataholder.OverloadedWorldHolder;
import org.anjocaido.groupmanager.dataholder.worlds.WorldsHolder;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class NamePermissionPluginStrategy
implements NameResolveStrategy {
    private final Plugin plugin;
    private final Server server;
    private final Scheduler scheduler;

    public NamePermissionPluginStrategy(Plugin plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.server = plugin.getServer();
        this.scheduler = scheduler;
    }

    private static Optional<String> firstPresentOptional(Optional<String> one, Optional<String> two) {
        if (one.isPresent()) {
            return one;
        }
        return two;
    }

    @Override
    public CompletableFuture<Optional<String>> resolveUserName(UUID uniqueId) {
        return ((CompletableFuture)((CompletableFuture)this.resolveUsingLuckPerms(uniqueId).thenCombine(this.resolveUsingGroupManager(uniqueId), NamePermissionPluginStrategy::firstPresentOptional)).thenCombine(this.resolveUsingBungeePerms(uniqueId), NamePermissionPluginStrategy::firstPresentOptional)).thenCombine(this.resolveUsingUltraPermissions(uniqueId), NamePermissionPluginStrategy::firstPresentOptional);
    }

    private CompletableFuture<Optional<String>> resolveUsingLuckPerms(UUID uniqueId) {
        CompletableFuture<Optional<String>> resultFuture = new CompletableFuture<Optional<String>>();
        this.scheduler.executeSyncGlobal(() -> {
            if (this.server.getPluginManager().isPluginEnabled("LuckPerms")) {
                LuckPerms api = LuckPermsProvider.get();
                UserManager userManager = api.getUserManager();
                net.luckperms.api.model.user.User user = userManager.getUser(uniqueId);
                if (user != null) {
                    resultFuture.complete(Optional.ofNullable(user.getUsername()));
                } else {
                    CompletableFuture luckPermsFuture = userManager.lookupUsername(uniqueId);
                    luckPermsFuture.whenComplete((userName, error) -> {
                        if (error != null) {
                            resultFuture.complete(Optional.ofNullable(userName));
                        } else {
                            resultFuture.complete(Optional.empty());
                        }
                    });
                }
            } else {
                resultFuture.complete(Optional.empty());
            }
        });
        return resultFuture;
    }

    private CompletableFuture<Optional<String>> resolveUsingGroupManager(UUID uniqueId) {
        CompletableFuture<Optional<String>> resultFuture = new CompletableFuture<Optional<String>>();
        this.scheduler.executeSyncGlobal(() -> {
            if (this.server.getPluginManager().isPluginEnabled("GroupManager")) {
                if (this.server.getPluginManager().isPluginEnabled("GroupManager")) {
                    GroupManager groupManager = (GroupManager)this.server.getPluginManager().getPlugin("GroupManager");
                    WorldsHolder worldsHolder = groupManager.getWorldsHolder();
                    OverloadedWorldHolder overloadedWorldHolder = worldsHolder.getDefaultWorld();
                    org.anjocaido.groupmanager.data.User user = overloadedWorldHolder.getUser(uniqueId.toString());
                    resultFuture.complete(Optional.ofNullable(user.getLastName()));
                } else {
                    resultFuture.complete(Optional.empty());
                }
            }
        });
        return resultFuture;
    }

    private CompletableFuture<Optional<String>> resolveUsingBungeePerms(UUID uniqueId) {
        CompletableFuture<Optional<String>> resultFuture = new CompletableFuture<Optional<String>>();
        this.scheduler.executeSyncGlobal(() -> {
            if (this.server.getPluginManager().isPluginEnabled("BungeePerms")) {
                BukkitPlugin bukkitPlugin = (BukkitPlugin)this.server.getPluginManager().getPlugin("BungeePerms");
                BungeePerms bungeePerms = bukkitPlugin.getBungeeperms();
                PermissionsManager permissionsManager = bungeePerms.getPermissionsManager();
                this.scheduler.executeAsync(() -> {
                    try {
                        net.alpenblock.bungeeperms.User user = permissionsManager.getUser(uniqueId, true);
                        if (user == null) {
                            resultFuture.complete(Optional.empty());
                        } else {
                            resultFuture.complete(Optional.ofNullable(user.getName()));
                        }
                    }
                    catch (Throwable t) {
                        resultFuture.complete(Optional.empty());
                    }
                });
            } else {
                resultFuture.complete(Optional.empty());
            }
        });
        return resultFuture;
    }

    private CompletableFuture<Optional<String>> resolveUsingUltraPermissions(UUID uniqueId) {
        CompletableFuture<Optional<String>> resultFuture = new CompletableFuture<Optional<String>>();
        this.scheduler.executeSyncGlobal(() -> {
            if (this.server.getPluginManager().isPluginEnabled("UltraPermissions")) {
                UltraPermissionsAPI api = UltraPermissions.getAPI();
                this.scheduler.executeAsync(() -> {
                    try {
                        UserList userList = api.getUsers();
                        Optional optUser = userList.uuid(uniqueId);
                        resultFuture.complete(optUser.map(User::getName));
                    }
                    catch (Throwable t) {
                        resultFuture.complete(Optional.empty());
                    }
                });
            } else {
                resultFuture.complete(Optional.empty());
            }
        });
        return resultFuture;
    }
}

