/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.logging;

import com.janboerman.invsee.spigot.api.logging.Difference;
import com.janboerman.invsee.spigot.api.logging.ItemType;
import com.janboerman.invsee.spigot.api.logging.LogFileHandlers;
import com.janboerman.invsee.spigot.api.logging.LogOptions;
import com.janboerman.invsee.spigot.api.logging.LogOutput;
import com.janboerman.invsee.spigot.api.logging.LogTarget;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

class LogOutputImpl
implements LogOutput {
    private static final String LOG_FOLDER_NAME = "InvSee++ logs";
    private static final int SPECTATOR_UUID_IDX = 0;
    private static final int SPECTATOR_NAME_IDX = 1;
    private static final int TAKEN_IDX = 2;
    private static final int GIVEN_IDX = 3;
    private static final int TARGET_IDX = 4;
    private final UUID spectatorId;
    private final String spectatorName;
    private final Logger logger;
    private final Target targetPlayer;
    private final Map<LogTarget, String> logFormats;

    LogOutputImpl(Plugin plugin, UUID spectatorId, String spectatorName, Target targetPlayer, Set<LogTarget> logTargets, Map<LogTarget, String> formats) {
        this.spectatorId = spectatorId;
        this.spectatorName = spectatorName;
        this.targetPlayer = targetPlayer;
        this.logger = Logger.getLogger("InvSee++." + spectatorId);
        this.logger.setLevel(Level.ALL);
        this.logFormats = formats;
        File logFileFolder = new File(plugin.getDataFolder(), LOG_FOLDER_NAME);
        if (!logTargets.isEmpty()) {
            logFileFolder.mkdirs();
        }
        for (LogTarget target : logTargets) {
            switch (target) {
                case SERVER_LOG_FILE: {
                    this.logger.setParent(plugin.getLogger());
                    break;
                }
                case PLUGIN_LOG_FILE: {
                    FileHandler fileHandler;
                    try {
                        fileHandler = LogFileHandlers.getGlobalHandler(logFileFolder);
                        fileHandler.setLevel(Level.ALL);
                        fileHandler.setFormatter(new DifferenceFormatter(this.logFormats.get((Object)LogTarget.PLUGIN_LOG_FILE)));
                        this.logger.addHandler(fileHandler);
                    }
                    catch (IOException e) {
                        plugin.getLogger().log(Level.SEVERE, "Could not create new file handler", e);
                    }
                    break;
                }
                case SPECTATOR_LOG_FILE: {
                    FileHandler fileHandler;
                    try {
                        fileHandler = LogFileHandlers.getSpectatorHandler(logFileFolder, spectatorId);
                        fileHandler.setLevel(Level.ALL);
                        fileHandler.setFormatter(new DifferenceFormatter(this.logFormats.get((Object)LogTarget.SPECTATOR_LOG_FILE)));
                        this.logger.addHandler(fileHandler);
                    }
                    catch (IOException e) {
                        plugin.getLogger().log(Level.SEVERE, "Could not create new file handler", e);
                    }
                    break;
                }
                case CONSOLE: {
                    if (logTargets.contains((Object)LogTarget.SERVER_LOG_FILE)) break;
                    ConsoleHandler consoleHandler = new ConsoleHandler();
                    consoleHandler.setLevel(Level.ALL);
                    consoleHandler.setFormatter(new DifferenceFormatter(this.logFormats.get((Object)LogTarget.CONSOLE)));
                    this.logger.addHandler(consoleHandler);
                }
            }
        }
        if (!logTargets.contains((Object)LogTarget.SERVER_LOG_FILE)) {
            this.logger.setUseParentHandlers(false);
        }
    }

    static LogOutputImpl of(Plugin plugin, UUID spectatorId, String spectatorName, Target target, LogOptions options) {
        return new LogOutputImpl(plugin, spectatorId, spectatorName, target, options.getTargets(), options.getFormats());
    }

    @Override
    public void log(Difference difference) {
        String format = this.logFormats.get((Object)LogTarget.SERVER_LOG_FILE);
        Date now = new Date();
        Taken taken = Taken.from(difference);
        Given given = Given.from(difference);
        String message = LogOutputImpl.format(format, Level.INFO, now, this.spectatorId, this.spectatorName, taken, given, this.targetPlayer);
        this.logger.log(Level.INFO, message, new Object[]{this.spectatorId, this.spectatorName, taken, given, this.targetPlayer});
    }

    @Override
    public void close() {
        LogFileHandlers.closeSpectatorHandler(this.spectatorId);
    }

    private static String format(String format, Level logLevel, Date date, UUID spectatorId, String spectatorName, Taken taken, Given given, Target target) {
        return LogOutputImpl.processTarget(LogOutputImpl.processGiven(LogOutputImpl.processTaken(LogOutputImpl.processSpectatorName(LogOutputImpl.processSpectatorId(LogOutputImpl.processTime(LogOutputImpl.processDate(LogOutputImpl.processLogLevel(format, logLevel), date), date), spectatorId), spectatorName), taken), given), target);
    }

    private static String processLogLevel(String format, Level logLevel) {
        return format.replace("<level>", String.format("%s", logLevel.getLocalizedName()));
    }

    private static String processDate(String format, Date date) {
        return format.replace("<date>", String.format("%tF", date));
    }

    private static String processTime(String format, Date date) {
        return format.replace("<time>", String.format("%tT", date));
    }

    private static String processSpectatorId(String format, UUID spectatorId) {
        return format.replace("<spectator_uuid>", String.format("%s", spectatorId));
    }

    private static String processSpectatorName(String format, String spectatorName) {
        return format.replace("<spectator_name>", String.format("%s", spectatorName));
    }

    private static String processTaken(String format, Taken taken) {
        return format.replace("<taken>", String.format("%s", taken));
    }

    private static String processGiven(String format, Given given) {
        return format.replace("<given>", String.format("%s", given));
    }

    private static String processTarget(String format, Target target) {
        return format.replace("<target>", String.format("%s", target));
    }

    static class Taken
    extends Diff {
        private Taken(List<Pair<ItemType, Integer>> items) {
            super(items);
        }

        static Taken from(Difference difference) {
            Map<ItemType, Integer> diff = difference.getDifference();
            ArrayList<Pair<ItemType, Integer>> items = new ArrayList<Pair<ItemType, Integer>>(diff.size());
            for (Map.Entry<ItemType, Integer> entry : diff.entrySet()) {
                Integer added = entry.getValue();
                if (added == null || added >= 0) continue;
                items.add(new Pair<ItemType, Integer>(entry.getKey(), -1 * added));
            }
            return new Taken(items);
        }
    }

    static class Given
    extends Diff {
        private Given(List<Pair<ItemType, Integer>> items) {
            super(items);
        }

        static Given from(Difference difference) {
            Map<ItemType, Integer> diff = difference.getDifference();
            ArrayList<Pair<ItemType, Integer>> items = new ArrayList<Pair<ItemType, Integer>>(diff.size());
            for (Map.Entry<ItemType, Integer> entry : diff.entrySet()) {
                Integer added = entry.getValue();
                if (added == null || added <= 0) continue;
                items.add(new Pair<ItemType, Integer>(entry.getKey(), added));
            }
            return new Given(items);
        }
    }

    private static class DifferenceFormatter
    extends SimpleFormatter {
        private final String format;

        private DifferenceFormatter(String format) {
            this.format = format;
        }

        @Override
        public String format(LogRecord record) {
            Object[] parameters = record.getParameters();
            Date time = new Date(record.getMillis());
            Level level = record.getLevel();
            UUID spectatorId = (UUID)parameters[0];
            String spectatorName = (String)parameters[1];
            Taken taken = (Taken)parameters[2];
            Given given = (Given)parameters[3];
            Target targetPlayer = (Target)parameters[4];
            return LogOutputImpl.format(this.format, level, time, spectatorId, spectatorName, taken, given, targetPlayer);
        }
    }

    private static class Diff {
        private final List<Pair<ItemType, Integer>> items;

        protected Diff(List<Pair<ItemType, Integer>> items) {
            this.items = Objects.requireNonNull(items);
        }

        public String toString() {
            return this.items.stream().map(pair -> {
                ItemType type = (ItemType)pair.getFirst();
                Material material = type.getMaterial();
                ItemMeta meta = type.getItemMeta();
                int amount = (Integer)pair.getSecond();
                if (meta == null || meta.equals((Object)new ItemStack(material).getItemMeta())) {
                    return material.name() + " x " + amount;
                }
                return material.name() + " & " + meta + " x " + amount;
            }).collect(Collectors.joining(", ", "[", "]"));
        }
    }
}

