/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.logging;

import com.janboerman.invsee.spigot.api.logging.LogGranularity;
import com.janboerman.invsee.spigot.api.logging.LogTarget;
import com.janboerman.invsee.utils.Compat;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LogOptions
implements Cloneable {
    public static final String FORMAT_SERVER_LOG_FILE = "\nSpectator UUID: <spectator_uuid>\nSpectator Name: <spectator_name>\nTaken         : <taken>\nGiven         : <given>\nTarget        : <target>";
    public static final String FORMAT_PLUGIN_LOG_FILE = "\n[<date> <time>] [<level>]:\nSpectator UUID: <spectator_uuid>\nSpectator Name: <spectator_name>\nTaken         : <taken>\nGiven         : <given>\nTarget        : <target>";
    public static final String FORMAT_SPECTATOR_LOG_FILE = "\n[<date> <time>] [<level>]:\nTaken         : <taken>\nGiven         : <given>\nTarget        : <target>";
    public static final String FORMAT_CONSOLE = "\n[<date> <time>] [<level>]:\nSpectator UUID: <spectator_uuid>\nSpectator Name: <spectator_name>\nTaken         : <taken>\nGiven         : <given>\nTarget        : <target>";
    private LogGranularity granularity;
    private EnumSet<LogTarget> logTargets;
    private EnumMap<LogTarget, String> formats;

    private LogOptions(LogGranularity granularity, Set<LogTarget> logTargets, Map<LogTarget, String> formats) {
        this.granularity = granularity;
        EnumSet<LogTarget> enumSet = logTargets == null ? null : (this.logTargets = logTargets.isEmpty() ? EnumSet.noneOf(LogTarget.class) : EnumSet.copyOf(logTargets));
        this.formats = formats == null ? null : (formats.isEmpty() ? new EnumMap(LogTarget.class) : new EnumMap<LogTarget, String>(formats));
    }

    public LogOptions() {
    }

    @Deprecated
    public static LogOptions of(LogGranularity granularity, Set<LogTarget> logTargets) {
        return new LogOptions(granularity, logTargets, null);
    }

    public static LogOptions of(LogGranularity granularity, Set<LogTarget> logTargets, EnumMap<LogTarget, String> formats) {
        return new LogOptions(granularity, logTargets, formats);
    }

    public static boolean isEmpty(LogOptions options) {
        if (options == null) {
            return true;
        }
        LogGranularity granularity = options.granularity;
        EnumSet<LogTarget> targets = options.logTargets;
        return granularity == null || granularity == LogGranularity.LOG_NEVER || targets == null || targets.isEmpty();
    }

    public static LogOptions empty() {
        return new LogOptions(LogGranularity.LOG_NEVER, EnumSet.noneOf(LogTarget.class), new EnumMap<LogTarget, String>(LogTarget.class));
    }

    public LogOptions clone() {
        return new LogOptions(this.getGranularity(), this.getTargets(), this.getFormats());
    }

    public LogOptions withGranularity(LogGranularity granularity) {
        this.granularity = granularity;
        return this;
    }

    public LogOptions withLogTargets(Collection<LogTarget> logTargets) {
        this.logTargets = logTargets == null ? null : EnumSet.copyOf(logTargets);
        return this;
    }

    public LogOptions withFormats(Map<LogTarget, String> logFormats) {
        this.formats = logFormats == null ? null : new EnumMap<LogTarget, String>(logFormats);
        return this;
    }

    public LogGranularity getGranularity() {
        if (this.granularity == null) {
            return LogGranularity.LOG_ON_CLOSE;
        }
        return this.granularity;
    }

    public Set<LogTarget> getTargets() {
        if (this.logTargets == null) {
            return EnumSet.allOf(LogTarget.class);
        }
        return Collections.unmodifiableSet(this.logTargets);
    }

    public Map<LogTarget, String> getFormats() {
        if (this.formats == null) {
            return Compat.mapOfEntries(Compat.mapEntry(LogTarget.SERVER_LOG_FILE, FORMAT_SERVER_LOG_FILE), Compat.mapEntry(LogTarget.PLUGIN_LOG_FILE, "\n[<date> <time>] [<level>]:\nSpectator UUID: <spectator_uuid>\nSpectator Name: <spectator_name>\nTaken         : <taken>\nGiven         : <given>\nTarget        : <target>"), Compat.mapEntry(LogTarget.SPECTATOR_LOG_FILE, FORMAT_SPECTATOR_LOG_FILE), Compat.mapEntry(LogTarget.CONSOLE, "\n[<date> <time>] [<level>]:\nSpectator UUID: <spectator_uuid>\nSpectator Name: <spectator_name>\nTaken         : <taken>\nGiven         : <given>\nTarget        : <target>"));
        }
        return Collections.unmodifiableMap(this.formats);
    }

    public String getFormat(LogTarget logTarget) {
        if (logTarget == null) {
            return "\n[<date> <time>] [<level>]:\nSpectator UUID: <spectator_uuid>\nSpectator Name: <spectator_name>\nTaken         : <taken>\nGiven         : <given>\nTarget        : <target>";
        }
        if (this.formats == null || !this.formats.containsKey((Object)logTarget)) {
            switch (logTarget) {
                case SERVER_LOG_FILE: {
                    return FORMAT_SERVER_LOG_FILE;
                }
                case PLUGIN_LOG_FILE: {
                    return "\n[<date> <time>] [<level>]:\nSpectator UUID: <spectator_uuid>\nSpectator Name: <spectator_name>\nTaken         : <taken>\nGiven         : <given>\nTarget        : <target>";
                }
                case SPECTATOR_LOG_FILE: {
                    return FORMAT_SPECTATOR_LOG_FILE;
                }
                case CONSOLE: {
                    return "\n[<date> <time>] [<level>]:\nSpectator UUID: <spectator_uuid>\nSpectator Name: <spectator_name>\nTaken         : <taken>\nGiven         : <given>\nTarget        : <target>";
                }
            }
            throw new RuntimeException("Unrecognised LogTarget: " + (Object)((Object)logTarget));
        }
        return this.formats.get((Object)logTarget);
    }

    public static EnumMap<LogTarget, String> defaultLogFormats() {
        EnumMap<LogTarget, String> map = new EnumMap<LogTarget, String>(LogTarget.class);
        map.put(LogTarget.SERVER_LOG_FILE, FORMAT_SERVER_LOG_FILE);
        map.put(LogTarget.PLUGIN_LOG_FILE, "\n[<date> <time>] [<level>]:\nSpectator UUID: <spectator_uuid>\nSpectator Name: <spectator_name>\nTaken         : <taken>\nGiven         : <given>\nTarget        : <target>");
        map.put(LogTarget.SPECTATOR_LOG_FILE, FORMAT_SPECTATOR_LOG_FILE);
        map.put(LogTarget.CONSOLE, "\n[<date> <time>] [<level>]:\nSpectator UUID: <spectator_uuid>\nSpectator Name: <spectator_name>\nTaken         : <taken>\nGiven         : <given>\nTarget        : <target>");
        return map;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogOptions)) {
            return false;
        }
        LogOptions that = (LogOptions)o;
        return this.getGranularity() == that.getGranularity() && Objects.equals(this.getTargets(), that.getTargets());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getGranularity(), this.getTargets()});
    }

    public String toString() {
        return "LogOptions{granularity=" + (Object)((Object)this.getGranularity()) + ",logTargets=" + this.getTargets() + "}";
    }
}

