/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.logging;

import com.janboerman.invsee.spigot.api.logging.ItemType;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.inventory.ItemStack;

public class Difference {
    private Map<ItemType, Integer> diffs = new LinkedHashMap<ItemType, Integer>();

    public Map<ItemType, Integer> getDifference() {
        return Collections.unmodifiableMap(this.diffs);
    }

    public boolean isEmpty() {
        return this.diffs == null || this.diffs.isEmpty() || this.diffs.values().stream().allMatch(Objects::isNull);
    }

    public void merge(Difference other) {
        for (Map.Entry<ItemType, Integer> entry : other.diffs.entrySet()) {
            this.accumulate(entry.getKey(), entry.getValue());
        }
    }

    public void accumulate(ItemStack stack) {
        if (stack == null) {
            return;
        }
        this.accumulate(ItemType.of(stack), stack.getAmount());
    }

    public void accumulate(ItemType itemType, int amount) {
        if (itemType == null || amount == 0) {
            return;
        }
        this.diffs.merge(itemType, amount, (x, y) -> {
            int sum = x + y;
            return sum == 0 ? null : Integer.valueOf(sum);
        });
    }

    public static Difference calculate(List<ItemStack> before, List<ItemStack> after) {
        if (before.size() != after.size()) {
            throw new IllegalArgumentException("'before' and 'after' lists must have the same sizes");
        }
        Difference res = new Difference();
        Iterator<ItemStack> one = before.iterator();
        Iterator<ItemStack> two = after.iterator();
        while (one.hasNext()) {
            ItemStack newStack;
            assert (two.hasNext());
            ItemStack oldStack = one.next();
            if (Objects.equals(oldStack, newStack = two.next())) continue;
            res.accumulate(ItemType.of(newStack), newStack.getAmount());
            res.accumulate(ItemType.of(oldStack), -oldStack.getAmount());
        }
        return res;
    }
}

