/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventory;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.Exempt;
import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import com.janboerman.invsee.spigot.api.MainSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.SpectatorInventory;
import com.janboerman.invsee.spigot.api.SpectatorInventoryView;
import com.janboerman.invsee.spigot.api.Title;
import com.janboerman.invsee.spigot.api.logging.LogOptions;
import com.janboerman.invsee.spigot.api.logging.LogOutput;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderPalette;
import com.janboerman.invsee.spigot.api.response.ImplementationFault;
import com.janboerman.invsee.spigot.api.response.InventoryNotCreated;
import com.janboerman.invsee.spigot.api.response.InventoryOpenEventCancelled;
import com.janboerman.invsee.spigot.api.response.NotCreatedReason;
import com.janboerman.invsee.spigot.api.response.NotOpenedReason;
import com.janboerman.invsee.spigot.api.response.OfflineSupportDisabled;
import com.janboerman.invsee.spigot.api.response.OpenResponse;
import com.janboerman.invsee.spigot.api.response.SaveResponse;
import com.janboerman.invsee.spigot.api.response.SpectateResponse;
import com.janboerman.invsee.spigot.api.response.TargetDoesNotExist;
import com.janboerman.invsee.spigot.api.response.TargetHasExemptPermission;
import com.janboerman.invsee.spigot.api.response.UnknownTarget;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.internal.InvseePlatform;
import com.janboerman.invsee.spigot.internal.NamesAndUUIDs;
import com.janboerman.invsee.spigot.internal.OpenSpectatorsCache;
import com.janboerman.invsee.spigot.internal.inventory.Personal;
import com.janboerman.invsee.spigot.internal.inventory.ShallowCopy;
import com.janboerman.invsee.utils.CaseInsensitiveMap;
import com.janboerman.invsee.utils.Compat;
import com.janboerman.invsee.utils.Either;
import com.janboerman.invsee.utils.Rethrow;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class InvseeAPI {
    protected final Plugin plugin;
    protected final InvseePlatform platform;
    protected final NamesAndUUIDs lookup;
    protected final OpenSpectatorsCache openSpectatorsCache;
    protected final Exempt exempt;
    private Title mainInventoryTitle = target -> target.toString() + "'s inventory";
    private Title enderInventoryTitle = target -> target.toString() + "'s enderchest";
    private boolean offlinePlayerSupport = true;
    private boolean unknownPlayerSupport = true;
    protected Mirror<PlayerInventorySlot> inventoryMirror = Mirror.defaultPlayerInventory();
    protected Mirror<EnderChestSlot> enderchestMirror = Mirror.defaultEnderChest();
    private LogOptions logOptions = new LogOptions();
    private PlaceholderPalette placeholderPalette = PlaceholderPalette.empty();
    private final Map<String, CompletableFuture<SpectateResponse<MainSpectatorInventory>>> pendingInventoriesByName = Collections.synchronizedMap(new CaseInsensitiveMap());
    private final Map<UUID, CompletableFuture<SpectateResponse<MainSpectatorInventory>>> pendingInventoriesByUuid = new ConcurrentHashMap<UUID, CompletableFuture<SpectateResponse<MainSpectatorInventory>>>();
    private final Map<String, CompletableFuture<SpectateResponse<EnderSpectatorInventory>>> pendingEnderChestsByName = Collections.synchronizedMap(new CaseInsensitiveMap());
    private final Map<UUID, CompletableFuture<SpectateResponse<EnderSpectatorInventory>>> pendingEnderChestsByUuid = new ConcurrentHashMap<UUID, CompletableFuture<SpectateResponse<EnderSpectatorInventory>>>();
    private BiPredicate<MainSpectatorInventory, Player> transferInvToLivePlayer = (spectatorInv, player) -> true;
    private BiPredicate<EnderSpectatorInventory, Player> transferEnderToLivePlayer = (spectatorInv, player) -> true;
    private final Scheduler scheduler;
    @Deprecated
    public final Executor serverThreadExecutor;
    @Deprecated
    public final Executor asyncExecutor;
    protected final PlayerListener playerListener = new PlayerListener();
    protected final InventoryListener inventoryListener = new InventoryListener();

    public InvseeAPI(Plugin plugin, InvseePlatform platform, NamesAndUUIDs lookup, Scheduler scheduler, OpenSpectatorsCache openSpectatorsCache) {
        this.plugin = Objects.requireNonNull(plugin);
        this.lookup = Objects.requireNonNull(lookup);
        this.platform = Objects.requireNonNull(platform == null ? this.getPlatform() : platform);
        this.scheduler = Objects.requireNonNull(scheduler);
        this.openSpectatorsCache = Objects.requireNonNull(openSpectatorsCache);
        this.exempt = new Exempt(plugin.getServer());
        this.registerListeners();
        this.serverThreadExecutor = scheduler::executeSyncGlobal;
        this.asyncExecutor = scheduler::executeAsync;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Deprecated
    protected InvseePlatform getPlatform() {
        return this.platform;
    }

    public void shutDown() {
        for (CompletableFuture<SpectateResponse<MainSpectatorInventory>> completableFuture : this.pendingInventoriesByUuid.values()) {
            try {
                completableFuture.join();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        for (CompletableFuture<SpectateResponse<SpectatorInventory<PlayerInventorySlot>>> completableFuture : this.pendingEnderChestsByUuid.values()) {
            try {
                completableFuture.join();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        LogOutput.closeGlobal();
    }

    public Map<String, UUID> getUuidCache() {
        return this.lookup.getUuidCache();
    }

    public Map<UUID, String> getUserNameCache() {
        return this.lookup.getUserNameCache();
    }

    @Deprecated
    public final NamesAndUUIDs namesAndUuidsLookup() {
        return this.lookup;
    }

    public void registerListeners() {
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)this.playerListener, this.plugin);
        pluginManager.registerEvents((Listener)this.inventoryListener, this.plugin);
    }

    public void unregisterListeners() {
        HandlerList.unregisterAll((Listener)this.playerListener);
        HandlerList.unregisterAll((Listener)this.inventoryListener);
    }

    public final void setOfflinePlayerSupport(boolean offlinePlayerSupport) {
        this.offlinePlayerSupport = offlinePlayerSupport;
    }

    public final void setUnknownPlayerSupport(boolean unknownPlayerSupport) {
        this.unknownPlayerSupport = unknownPlayerSupport;
    }

    public final boolean offlinePlayerSupport() {
        return this.offlinePlayerSupport;
    }

    public final boolean unknownPlayerSupport() {
        return this.unknownPlayerSupport;
    }

    public final void setMainInventoryTitle(Title title) {
        Objects.requireNonNull(title);
        this.mainInventoryTitle = title;
    }

    public final void setEnderInventoryTitle(Title title) {
        Objects.requireNonNull(title);
        this.enderInventoryTitle = title;
    }

    public final void setMainInventoryMirror(Mirror<PlayerInventorySlot> mirror) {
        Objects.requireNonNull(mirror);
        this.inventoryMirror = mirror;
    }

    public final void setEnderInventoryMirror(Mirror<EnderChestSlot> mirror) {
        Objects.requireNonNull(mirror);
        this.enderchestMirror = mirror;
    }

    public final void setLogOptions(LogOptions options) {
        Objects.requireNonNull(options);
        this.logOptions = options.clone();
    }

    public final void setPlaceholderPalette(PlaceholderPalette palette) {
        Objects.requireNonNull(palette);
        this.placeholderPalette = palette;
    }

    public CreationOptions<PlayerInventorySlot> mainInventoryCreationOptions(Player spectator) {
        boolean bypassExempt = spectator.hasPermission("invseeplusplus.bypass-exempt.invsee");
        return new CreationOptions<PlayerInventorySlot>(this.plugin, this.mainInventoryTitle, this.offlinePlayerSupport, this.inventoryMirror, this.unknownPlayerSupport, bypassExempt, this.logOptions.clone(), this.placeholderPalette);
    }

    public CreationOptions<EnderChestSlot> enderInventoryCreationOptions(Player spectator) {
        boolean bypassExempt = spectator.hasPermission("invseeplusplus.bypass-exempt.endersee");
        return new CreationOptions<EnderChestSlot>(this.plugin, this.enderInventoryTitle, this.offlinePlayerSupport, this.enderchestMirror, this.unknownPlayerSupport, bypassExempt, this.logOptions.clone(), this.placeholderPalette);
    }

    public CreationOptions<PlayerInventorySlot> mainInventoryCreationOptions() {
        return new CreationOptions<PlayerInventorySlot>(this.plugin, this.mainInventoryTitle, this.offlinePlayerSupport, this.inventoryMirror, this.unknownPlayerSupport, false, this.logOptions.clone(), this.placeholderPalette);
    }

    public CreationOptions<EnderChestSlot> enderInventoryCreationOptions() {
        return new CreationOptions<EnderChestSlot>(this.plugin, this.enderInventoryTitle, this.offlinePlayerSupport, this.enderchestMirror, this.unknownPlayerSupport, false, this.logOptions.clone(), this.placeholderPalette);
    }

    public final void setMainInventoryTransferPredicate(BiPredicate<MainSpectatorInventory, Player> bip) {
        Objects.requireNonNull(bip);
        this.transferInvToLivePlayer = bip;
    }

    public final void setEnderChestTransferPredicate(BiPredicate<EnderSpectatorInventory, Player> bip) {
        Objects.requireNonNull(bip);
        this.transferEnderToLivePlayer = bip;
    }

    @Deprecated
    public Optional<MainSpectatorInventory> getOpenMainSpectatorInventory(UUID player) {
        return Optional.ofNullable(this.openSpectatorsCache.getMainSpectatorInventory(player));
    }

    @Deprecated
    public Optional<EnderSpectatorInventory> getOpenEnderSpectatorInventory(UUID player) {
        return Optional.ofNullable(this.openSpectatorsCache.getEnderSpectatorInventory(player));
    }

    public final CompletableFuture<Optional<UUID>> fetchUniqueId(String userName) {
        return this.lookup.resolveUUID(userName).thenApplyAsync(Function.identity(), this.scheduler::executeSyncGlobal);
    }

    public final CompletableFuture<Optional<String>> fetchUserName(UUID uniqueId) {
        return this.lookup.resolveUserName(uniqueId).thenApplyAsync(Function.identity(), this.scheduler::executeSyncGlobal);
    }

    @Deprecated
    protected void cache(MainSpectatorInventory spectatorInventory) {
        this.openSpectatorsCache.cache(spectatorInventory, false);
    }

    @Deprecated
    protected void cache(MainSpectatorInventory spectatorInventory, boolean force) {
        this.openSpectatorsCache.cache(spectatorInventory, force);
    }

    @Deprecated
    protected void cache(EnderSpectatorInventory spectatorInventory) {
        this.openSpectatorsCache.cache(spectatorInventory);
    }

    @Deprecated
    protected void cache(EnderSpectatorInventory spectatorInventory, boolean force) {
        this.openSpectatorsCache.cache(spectatorInventory, force);
    }

    public CompletableFuture<SaveResponse> saveInventory(MainSpectatorInventory inventory) {
        return this.platform.saveInventory(inventory);
    }

    public final OpenResponse<MainSpectatorInventoryView> spectateInventory(Player spectator, HumanEntity target, CreationOptions<PlayerInventorySlot> options) {
        SpectateResponse<MainSpectatorInventory> response = this.mainSpectatorInventory(target, options);
        if (response.isSuccess()) {
            return this.platform.openMainSpectatorInventory(spectator, response.getInventory(), options);
        }
        return OpenResponse.closed(NotOpenedReason.notCreated(response.getReason()));
    }

    public final SpectateResponse<MainSpectatorInventory> mainSpectatorInventory(HumanEntity target) {
        return this.mainSpectatorInventory(target, this.mainInventoryCreationOptions());
    }

    public final SpectateResponse<MainSpectatorInventory> mainSpectatorInventory(HumanEntity target, CreationOptions<PlayerInventorySlot> options) {
        Target theTarget = Target.byPlayer(target);
        if (!options.canBypassExemptedPlayers() && this.exempt.isExemptedFromHavingMainInventorySpectated(theTarget)) {
            return SpectateResponse.fail(NotCreatedReason.targetHasExemptPermission(theTarget));
        }
        MainSpectatorInventory inv = this.platform.spectateInventory(target, options);
        this.openSpectatorsCache.cache(inv);
        return SpectateResponse.succeed(inv);
    }

    public final CompletableFuture<OpenResponse<MainSpectatorInventoryView>> spectateInventory(Player spectator, String targetName, CreationOptions<PlayerInventorySlot> options) {
        return this.spectateInventory(spectator, this.mainSpectatorInventory(targetName, options), options);
    }

    public final CompletableFuture<SpectateResponse<MainSpectatorInventory>> mainSpectatorInventory(String targetName) {
        return this.mainSpectatorInventory(targetName, this.mainInventoryCreationOptions());
    }

    public final CompletableFuture<SpectateResponse<MainSpectatorInventory>> mainSpectatorInventory(String targetName, CreationOptions<PlayerInventorySlot> options) {
        Objects.requireNonNull(targetName, "targetName cannot be null!");
        Objects.requireNonNull(options, "options cannot be null!");
        Player targetPlayer = this.plugin.getServer().getPlayerExact(targetName);
        if (targetPlayer != null) {
            Target target = Target.byPlayer((HumanEntity)targetPlayer);
            if (!options.canBypassExemptedPlayers() && this.exempt.isExemptedFromHavingMainInventorySpectated(target)) {
                return CompletableFuture.completedFuture(SpectateResponse.fail(NotCreatedReason.targetHasExemptPermission(target)));
            }
            MainSpectatorInventory spectatorInventory = this.platform.spectateInventory((HumanEntity)targetPlayer, options);
            UUID uuid = targetPlayer.getUniqueId();
            this.lookup.cacheNameAndUniqueId(uuid, targetName);
            this.openSpectatorsCache.cache(spectatorInventory);
            return CompletableFuture.completedFuture(SpectateResponse.succeed(spectatorInventory));
        }
        if (!options.isOfflinePlayerSupported()) {
            return CompletableFuture.completedFuture(SpectateResponse.fail(NotCreatedReason.offlineSupportDisabled()));
        }
        Target target = Target.byUsername(targetName);
        CompletableFuture<Boolean> isExemptedFuture = options.canBypassExemptedPlayers() ? CompletableFuture.completedFuture(false) : (this.plugin.getServer().getPluginManager().isPluginEnabled("LuckPerms") ? CompletableFuture.completedFuture(false) : CompletableFuture.supplyAsync(() -> this.exempt.isExemptedFromHavingMainInventorySpectated(target), this.scheduler::executeAsync));
        CompletableFuture<Optional<UUID>> uuidFuture = this.fetchUniqueId(targetName);
        CompletionStage combinedFuture = isExemptedFuture.thenCompose(isExempted -> {
            if (isExempted.booleanValue()) {
                return CompletableFuture.completedFuture(Either.left(NotCreatedReason.targetHasExemptPermission(target)));
            }
            return uuidFuture.thenApply(optionalUuid -> {
                if (optionalUuid.isPresent()) {
                    return Either.right((UUID)optionalUuid.get());
                }
                return Either.left(NotCreatedReason.targetDoesNotExists(target));
            });
        });
        CompletionStage future = ((CompletableFuture)combinedFuture).thenCompose(eitherReasonOrUuid -> {
            if (eitherReasonOrUuid.isRight()) {
                UUID uuid = (UUID)eitherReasonOrUuid.getRight();
                return this.mainSpectatorInventory(uuid, targetName, options);
            }
            NotCreatedReason reason = (NotCreatedReason)eitherReasonOrUuid.getLeft();
            return CompletableFuture.completedFuture(SpectateResponse.fail(reason));
        });
        this.pendingInventoriesByName.put(targetName, (CompletableFuture<SpectateResponse<MainSpectatorInventory>>)future);
        ((CompletableFuture)future).whenComplete((result, error) -> this.pendingInventoriesByName.remove(targetName));
        return future;
    }

    public final CompletableFuture<OpenResponse<MainSpectatorInventoryView>> spectateInventory(Player spectator, UUID targetId, String targetName, CreationOptions<PlayerInventorySlot> options) {
        return this.spectateInventory(spectator, this.mainSpectatorInventory(targetId, targetName, options), options);
    }

    public final CompletableFuture<SpectateResponse<MainSpectatorInventory>> mainSpectatorInventory(UUID playerId, String playerName) {
        return this.mainSpectatorInventory(playerId, playerName, this.mainInventoryCreationOptions());
    }

    public final CompletableFuture<SpectateResponse<MainSpectatorInventory>> mainSpectatorInventory(UUID playerId, String playerName, CreationOptions<PlayerInventorySlot> options) {
        Objects.requireNonNull(playerId, "player UUID cannot be null!");
        Objects.requireNonNull(playerName, "player name cannot be null!");
        Objects.requireNonNull(options, "creation options cannot be null!");
        Target gameProfileTarget = Target.byGameProfile(playerId, playerName);
        String title = options.getTitle().titleFor(gameProfileTarget);
        Mirror<PlayerInventorySlot> mirror = options.getMirror();
        boolean offlineSupport = options.isOfflinePlayerSupported();
        Player targetPlayer = this.plugin.getServer().getPlayer(playerId);
        if (targetPlayer != null) {
            Target target = Target.byPlayer((HumanEntity)targetPlayer);
            if (!options.canBypassExemptedPlayers() && this.exempt.isExemptedFromHavingMainInventorySpectated(target)) {
                return CompletableFuture.completedFuture(SpectateResponse.fail(NotCreatedReason.targetHasExemptPermission(target)));
            }
            MainSpectatorInventory spectatorInventory = this.spectateInventory((HumanEntity)targetPlayer, title, mirror);
            this.lookup.cacheNameAndUniqueId(playerId, playerName);
            this.openSpectatorsCache.cache(spectatorInventory);
            return CompletableFuture.completedFuture(SpectateResponse.succeed(spectatorInventory));
        }
        if (!offlineSupport) {
            return CompletableFuture.completedFuture(SpectateResponse.fail(NotCreatedReason.offlineSupportDisabled()));
        }
        Target target = gameProfileTarget;
        CompletableFuture<Boolean> isExemptedFuture = options.canBypassExemptedPlayers() ? CompletableFuture.completedFuture(false) : CompletableFuture.supplyAsync(() -> this.exempt.isExemptedFromHavingMainInventorySpectated(target), this.scheduler::executeAsync);
        CompletionStage reasonFuture = isExemptedFuture.thenApply(isExempted -> {
            if (isExempted.booleanValue()) {
                return Optional.of(NotCreatedReason.targetHasExemptPermission(target));
            }
            return Optional.empty();
        });
        CompletionStage combinedFuture = ((CompletableFuture)reasonFuture).thenCompose(maybeReason -> {
            if (maybeReason.isPresent()) {
                return CompletableFuture.completedFuture(SpectateResponse.fail((NotCreatedReason)maybeReason.get()));
            }
            MainSpectatorInventory alreadyOpen = this.openSpectatorsCache.getMainSpectatorInventory(playerId);
            if (alreadyOpen != null) {
                return CompletableFuture.completedFuture(SpectateResponse.succeed(alreadyOpen));
            }
            return this.platform.createOfflineInventory(playerId, playerName, options);
        });
        CompletionStage future = ((CompletableFuture)((CompletableFuture)combinedFuture).thenApply(eitherReasonOrInventory -> {
            eitherReasonOrInventory.ifSuccess(this.openSpectatorsCache::cache);
            return eitherReasonOrInventory;
        })).handleAsync((success, error) -> {
            if (error == null) {
                return success;
            }
            return (SpectateResponse)Rethrow.unchecked(error);
        }, runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null));
        this.pendingInventoriesByUuid.put(playerId, (CompletableFuture<SpectateResponse<MainSpectatorInventory>>)future);
        ((CompletableFuture)future).whenComplete((result, error) -> this.pendingInventoriesByUuid.remove(playerId));
        return future;
    }

    public CompletableFuture<SaveResponse> saveEnderChest(EnderSpectatorInventory enderChest) {
        return this.platform.saveEnderChest(enderChest);
    }

    public final OpenResponse<EnderSpectatorInventoryView> spectateEnderChest(Player spectator, HumanEntity target, CreationOptions<EnderChestSlot> options) {
        SpectateResponse<EnderSpectatorInventory> response = this.enderSpectatorInventory(target, options);
        if (response.isSuccess()) {
            return this.platform.openEnderSpectatorInventory(spectator, response.getInventory(), options);
        }
        return OpenResponse.closed(NotOpenedReason.notCreated(response.getReason()));
    }

    public final SpectateResponse<EnderSpectatorInventory> enderSpectatorInventory(HumanEntity target) {
        return this.enderSpectatorInventory(target, this.enderInventoryCreationOptions());
    }

    public final SpectateResponse<EnderSpectatorInventory> enderSpectatorInventory(HumanEntity target, CreationOptions<EnderChestSlot> options) {
        Target theTarget = Target.byPlayer(target);
        if (!options.canBypassExemptedPlayers() && this.exempt.isExemptedFromHavingEnderchestSpectated(theTarget)) {
            return SpectateResponse.fail(NotCreatedReason.targetHasExemptPermission(theTarget));
        }
        EnderSpectatorInventory inv = this.platform.spectateEnderChest(target, options);
        this.openSpectatorsCache.cache(inv);
        return SpectateResponse.succeed(inv);
    }

    public final CompletableFuture<OpenResponse<EnderSpectatorInventoryView>> spectateEnderChest(Player spectator, String targetName, CreationOptions<EnderChestSlot> options) {
        return this.spectateEnderChest(spectator, this.enderSpectatorInventory(targetName, options), options);
    }

    public final CompletableFuture<SpectateResponse<EnderSpectatorInventory>> enderSpectatorInventory(String targetName) {
        return this.enderSpectatorInventory(targetName, this.enderInventoryCreationOptions());
    }

    public final CompletableFuture<SpectateResponse<EnderSpectatorInventory>> enderSpectatorInventory(String targetName, CreationOptions<EnderChestSlot> options) {
        Objects.requireNonNull(targetName, "targetName cannot be null!");
        Objects.requireNonNull(options, "options cannot be null!");
        Player targetPlayer = this.plugin.getServer().getPlayerExact(targetName);
        if (targetPlayer != null) {
            Target target = Target.byPlayer((HumanEntity)targetPlayer);
            if (!options.canBypassExemptedPlayers() && this.exempt.isExemptedFromHavingEnderchestSpectated(target)) {
                return CompletableFuture.completedFuture(SpectateResponse.fail(NotCreatedReason.targetHasExemptPermission(target)));
            }
            EnderSpectatorInventory spectatorInventory = this.platform.spectateEnderChest((HumanEntity)targetPlayer, options);
            UUID uuid = targetPlayer.getUniqueId();
            this.lookup.cacheNameAndUniqueId(uuid, targetName);
            this.openSpectatorsCache.cache(spectatorInventory);
            return CompletableFuture.completedFuture(SpectateResponse.succeed(spectatorInventory));
        }
        if (!options.isOfflinePlayerSupported()) {
            return CompletableFuture.completedFuture(SpectateResponse.fail(NotCreatedReason.offlineSupportDisabled()));
        }
        Target target = Target.byUsername(targetName);
        CompletableFuture<Boolean> isExemptedFuture = options.canBypassExemptedPlayers() ? CompletableFuture.completedFuture(false) : (this.plugin.getServer().getPluginManager().isPluginEnabled("LuckPerms") ? CompletableFuture.completedFuture(false) : CompletableFuture.supplyAsync(() -> this.exempt.isExemptedFromHavingEnderchestSpectated(target), this.scheduler::executeAsync));
        CompletableFuture<Optional<UUID>> uuidFuture = this.fetchUniqueId(targetName);
        CompletionStage combinedFuture = isExemptedFuture.thenCompose(isExempted -> {
            if (isExempted.booleanValue()) {
                return CompletableFuture.completedFuture(Either.left(NotCreatedReason.targetHasExemptPermission(target)));
            }
            return uuidFuture.thenApply(optionalUuid -> {
                if (optionalUuid.isPresent()) {
                    return Either.right((UUID)optionalUuid.get());
                }
                return Either.left(NotCreatedReason.targetDoesNotExists(target));
            });
        });
        CompletionStage future = ((CompletableFuture)combinedFuture).thenCompose(eitherReasonOrUuid -> {
            if (eitherReasonOrUuid.isRight()) {
                UUID uuid = (UUID)eitherReasonOrUuid.getRight();
                return this.enderSpectatorInventory(uuid, targetName, options);
            }
            NotCreatedReason reason = (NotCreatedReason)eitherReasonOrUuid.getLeft();
            return CompletableFuture.completedFuture(SpectateResponse.fail(reason));
        });
        this.pendingEnderChestsByName.put(targetName, (CompletableFuture<SpectateResponse<EnderSpectatorInventory>>)future);
        ((CompletableFuture)future).whenComplete((result, error) -> this.pendingEnderChestsByName.remove(targetName));
        return future;
    }

    public final CompletableFuture<OpenResponse<EnderSpectatorInventoryView>> spectateEnderChest(Player spectator, UUID targetId, String targetName, CreationOptions<EnderChestSlot> options) {
        return this.spectateEnderChest(spectator, this.enderSpectatorInventory(targetId, targetName, options), options);
    }

    public final CompletableFuture<SpectateResponse<EnderSpectatorInventory>> enderSpectatorInventory(UUID playerId, String playerName) {
        return this.enderSpectatorInventory(playerId, playerName, this.enderInventoryCreationOptions());
    }

    public final CompletableFuture<SpectateResponse<EnderSpectatorInventory>> enderSpectatorInventory(UUID playerId, String playerName, CreationOptions<EnderChestSlot> options) {
        Objects.requireNonNull(playerId, "player UUID cannot be null!");
        Objects.requireNonNull(playerName, "player name cannot be null!");
        Objects.requireNonNull(options, "options cannot be null!");
        Player targetPlayer = this.plugin.getServer().getPlayer(playerId);
        if (targetPlayer != null) {
            Target target = Target.byPlayer((HumanEntity)targetPlayer);
            if (!options.canBypassExemptedPlayers() && this.exempt.isExemptedFromHavingEnderchestSpectated(target)) {
                return CompletableFuture.completedFuture(SpectateResponse.fail(NotCreatedReason.targetHasExemptPermission(target)));
            }
            EnderSpectatorInventory spectatorInventory = this.platform.spectateEnderChest((HumanEntity)targetPlayer, options);
            this.lookup.cacheNameAndUniqueId(playerId, playerName);
            this.openSpectatorsCache.cache(spectatorInventory);
            return CompletableFuture.completedFuture(SpectateResponse.succeed(spectatorInventory));
        }
        if (!options.isOfflinePlayerSupported()) {
            return CompletableFuture.completedFuture(SpectateResponse.fail(NotCreatedReason.offlineSupportDisabled()));
        }
        Target target = Target.byGameProfile(playerId, playerName);
        CompletableFuture<Boolean> isExemptedFuture = options.canBypassExemptedPlayers() ? CompletableFuture.completedFuture(false) : CompletableFuture.supplyAsync(() -> this.exempt.isExemptedFromHavingEnderchestSpectated(target), this.scheduler::executeAsync);
        CompletionStage reasonFuture = isExemptedFuture.thenApply(isExempted -> {
            if (isExempted.booleanValue()) {
                return Optional.of(NotCreatedReason.targetHasExemptPermission(target));
            }
            return Optional.empty();
        });
        CompletionStage combinedFuture = ((CompletableFuture)reasonFuture).thenCompose(maybeReason -> {
            if (maybeReason.isPresent()) {
                return CompletableFuture.completedFuture(SpectateResponse.fail((NotCreatedReason)maybeReason.get()));
            }
            EnderSpectatorInventory alreadyOpen = this.openSpectatorsCache.getEnderSpectatorInventory(playerId);
            if (alreadyOpen != null) {
                return CompletableFuture.completedFuture(SpectateResponse.succeed(alreadyOpen));
            }
            return this.platform.createOfflineEnderChest(playerId, playerName, options);
        });
        CompletionStage future = ((CompletableFuture)((CompletableFuture)combinedFuture).thenApply(eitherReasonOrInventory -> {
            eitherReasonOrInventory.ifSuccess(this.openSpectatorsCache::cache);
            return eitherReasonOrInventory;
        })).handleAsync((success, error) -> {
            if (error == null) {
                return success;
            }
            return (SpectateResponse)Rethrow.unchecked(error);
        }, runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null));
        this.pendingEnderChestsByUuid.put(playerId, (CompletableFuture<SpectateResponse<EnderSpectatorInventory>>)future);
        ((CompletableFuture)future).whenComplete((result, error) -> this.pendingEnderChestsByUuid.remove(playerId));
        return future;
    }

    private final CompletableFuture<OpenResponse<MainSpectatorInventoryView>> spectateInventory(Player spectator, CompletableFuture<SpectateResponse<MainSpectatorInventory>> future, CreationOptions<PlayerInventorySlot> options) {
        CompletableFuture<OpenResponse<MainSpectatorInventoryView>> result = new CompletableFuture<OpenResponse<MainSpectatorInventoryView>>();
        future.whenComplete((response, throwable) -> {
            if (throwable == null) {
                if (response.isSuccess()) {
                    try {
                        OpenResponse<MainSpectatorInventoryView> openResponse = this.platform.openMainSpectatorInventory(spectator, (MainSpectatorInventory)response.getInventory(), options);
                        result.complete(openResponse);
                    }
                    catch (Throwable ex) {
                        result.completeExceptionally(ex);
                    }
                } else {
                    result.complete(OpenResponse.closed(NotOpenedReason.notCreated(response.getReason())));
                }
            } else {
                result.completeExceptionally((Throwable)throwable);
            }
        });
        return result;
    }

    private final CompletableFuture<OpenResponse<EnderSpectatorInventoryView>> spectateEnderChest(Player spectator, CompletableFuture<SpectateResponse<EnderSpectatorInventory>> future, CreationOptions<EnderChestSlot> options) {
        CompletableFuture<OpenResponse<EnderSpectatorInventoryView>> result = new CompletableFuture<OpenResponse<EnderSpectatorInventoryView>>();
        future.whenComplete((response, throwable) -> {
            if (throwable == null) {
                if (response.isSuccess()) {
                    try {
                        OpenResponse<EnderSpectatorInventoryView> openResponse = this.platform.openEnderSpectatorInventory(spectator, (EnderSpectatorInventory)response.getInventory(), options);
                        result.complete(openResponse);
                    }
                    catch (Throwable ex) {
                        result.completeExceptionally(ex);
                    }
                } else {
                    result.complete(OpenResponse.closed(NotOpenedReason.notCreated(response.getReason())));
                }
            } else {
                result.completeExceptionally((Throwable)throwable);
            }
        });
        return result;
    }

    @Deprecated
    public final void setMainInventoryTitleFactory(Function<Target, String> titleFactory) {
        this.setMainInventoryTitle(Title.of(titleFactory));
    }

    @Deprecated
    public final void setEnderInventoryTitleFactory(Function<Target, String> titleFactory) {
        this.setEnderInventoryTitle(Title.of(titleFactory));
    }

    @Deprecated
    public final CompletableFuture<Void> spectateInventory(Player spectator, String targetName, String title, boolean offlineSupport, Mirror<PlayerInventorySlot> mirror) {
        return ((CompletableFuture)this.spectateInventory(spectator, targetName, this.mainInventoryCreationOptions(spectator).withTitle(title).withOfflinePlayerSupport(offlineSupport).withMirror(mirror)).whenComplete((either, throwable) -> InvseeAPI.handleMainInventoryExceptionsAndNotCreatedReasons(this.plugin, spectator, either, throwable, targetName))).thenApply(__ -> null);
    }

    @Deprecated
    public final CompletableFuture<Void> spectateInventory(Player spectator, UUID targetId, String targetName, String title, boolean offlineSupport, Mirror<PlayerInventorySlot> mirror) {
        return ((CompletableFuture)this.spectateInventory(spectator, targetId, targetName, this.mainInventoryCreationOptions(spectator).withTitle(title).withOfflinePlayerSupport(offlineSupport).withMirror(mirror)).whenComplete((either, throwable) -> InvseeAPI.handleMainInventoryExceptionsAndNotCreatedReasons(this.plugin, spectator, either, throwable, targetId.toString()))).thenApply(__ -> null);
    }

    private static <SIV extends SpectatorInventoryView<?>> void handleMainInventoryExceptionsAndNotCreatedReasons(Plugin plugin, Player spectator, OpenResponse<SIV> openResponse, Throwable throwable, String targetNameOrUuid) {
        if (throwable == null) {
            if (!openResponse.isOpen()) {
                NotOpenedReason notOpenedReason = openResponse.getReason();
                if (notOpenedReason instanceof InventoryOpenEventCancelled) {
                    spectator.sendMessage(ChatColor.RED + "Another plugin prevented you from spectating " + targetNameOrUuid + "'s inventory");
                } else if (notOpenedReason instanceof InventoryNotCreated) {
                    NotCreatedReason notCreatedReason = ((InventoryNotCreated)notOpenedReason).getNotCreatedReason();
                    if (notCreatedReason instanceof TargetDoesNotExist) {
                        spectator.sendMessage(ChatColor.RED + "Player " + targetNameOrUuid + " does not exist.");
                    } else if (notCreatedReason instanceof UnknownTarget) {
                        spectator.sendMessage(ChatColor.RED + "Player " + targetNameOrUuid + " has not logged onto the server yet.");
                    } else if (notCreatedReason instanceof TargetHasExemptPermission) {
                        spectator.sendMessage(ChatColor.RED + "Player " + targetNameOrUuid + " is exempted from being spectated.");
                    } else if (notCreatedReason instanceof ImplementationFault) {
                        spectator.sendMessage(ChatColor.RED + "An internal fault occurred when trying to load " + targetNameOrUuid + "'s inventory.");
                    } else if (notCreatedReason instanceof OfflineSupportDisabled) {
                        spectator.sendMessage(ChatColor.RED + "Spectating offline players' inventories is disabled.");
                    } else {
                        spectator.sendMessage(ChatColor.RED + "Could not create " + targetNameOrUuid + "'s inventory for an unknown reason.");
                    }
                } else {
                    spectator.sendMessage(ChatColor.RED + "Could not open " + targetNameOrUuid + "'s inventory for an unknown reason.");
                }
            }
        } else {
            spectator.sendMessage(ChatColor.RED + "An error occurred while trying to open " + targetNameOrUuid + "'s inventory.");
            plugin.getLogger().log(Level.SEVERE, "Error while trying to create main-inventory spectator inventory", throwable);
        }
    }

    @Deprecated
    public final CompletableFuture<Void> spectateEnderChest(Player spectator, String targetName, String title, boolean offlineSupport, Mirror<EnderChestSlot> mirror) {
        return ((CompletableFuture)this.spectateEnderChest(spectator, targetName, this.enderInventoryCreationOptions(spectator).withTitle(title).withOfflinePlayerSupport(offlineSupport).withMirror(mirror)).whenComplete((either, throwable) -> InvseeAPI.handleEnderInventoryExceptionsAndNotCreatedReasons(this.plugin, spectator, either, throwable, targetName))).thenApply(__ -> null);
    }

    @Deprecated
    public final CompletableFuture<Void> spectateEnderChest(Player spectator, UUID targetId, String targetName, String title, boolean offlineSupport, Mirror<EnderChestSlot> mirror) {
        return ((CompletableFuture)this.spectateEnderChest(spectator, targetId, targetName, this.enderInventoryCreationOptions(spectator).withTitle(title).withOfflinePlayerSupport(offlineSupport).withMirror(mirror)).whenComplete((either, throwable) -> InvseeAPI.handleEnderInventoryExceptionsAndNotCreatedReasons(this.plugin, spectator, either, throwable, targetId.toString()))).thenApply(__ -> null);
    }

    private static <SIV extends SpectatorInventoryView<?>> void handleEnderInventoryExceptionsAndNotCreatedReasons(Plugin plugin, Player spectator, OpenResponse<SIV> openResponse, Throwable throwable, String targetNameOrUuid) {
        if (throwable == null) {
            if (!openResponse.isOpen()) {
                NotOpenedReason notOpenedReason = openResponse.getReason();
                if (notOpenedReason instanceof InventoryOpenEventCancelled) {
                    spectator.sendMessage(ChatColor.RED + "Another plugin prevented you from spectating " + targetNameOrUuid + "'s ender chest.");
                } else if (notOpenedReason instanceof InventoryNotCreated) {
                    NotCreatedReason reason = ((InventoryNotCreated)notOpenedReason).getNotCreatedReason();
                    if (reason instanceof TargetDoesNotExist) {
                        spectator.sendMessage(ChatColor.RED + "Player " + targetNameOrUuid + " does not exist.");
                    } else if (reason instanceof UnknownTarget) {
                        spectator.sendMessage(ChatColor.RED + "Player " + targetNameOrUuid + " has not logged onto the server yet.");
                    } else if (reason instanceof TargetHasExemptPermission) {
                        spectator.sendMessage(ChatColor.RED + "Player " + targetNameOrUuid + " is exempted from being spectated.");
                    } else if (reason instanceof ImplementationFault) {
                        spectator.sendMessage(ChatColor.RED + "An internal fault occurred when trying to load " + targetNameOrUuid + "'s enderchest.");
                    } else if (reason instanceof OfflineSupportDisabled) {
                        spectator.sendMessage(ChatColor.RED + "Spectating offline players' enderchests is disabled.");
                    } else {
                        spectator.sendMessage(ChatColor.RED + "Could not create " + targetNameOrUuid + "'s enderchest for an unknown reason.");
                    }
                } else {
                    spectator.sendMessage(ChatColor.RED + "Could not open " + targetNameOrUuid + "'s enderchest for an unknown reason.");
                }
            }
        } else {
            spectator.sendMessage(ChatColor.RED + "An error occurred while trying to open " + targetNameOrUuid + "'s enderchest.");
            plugin.getLogger().log(Level.SEVERE, "Error while trying to create ender-chest spectator inventory", throwable);
        }
    }

    @Deprecated
    public final SpectateResponse<MainSpectatorInventory> mainSpectatorInventory(HumanEntity target, String title) {
        return this.mainSpectatorInventory(target, this.mainInventoryCreationOptions().withTitle(title));
    }

    @Deprecated
    public final SpectateResponse<MainSpectatorInventory> mainSpectatorInventory(HumanEntity target, String title, Mirror<PlayerInventorySlot> mirror) {
        return this.mainSpectatorInventory(target, this.mainInventoryCreationOptions().withTitle(title).withMirror(mirror));
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<MainSpectatorInventory>> mainSpectatorInventory(String targetName, String title) {
        return this.mainSpectatorInventory(targetName, title, this.offlinePlayerSupport);
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<MainSpectatorInventory>> mainSpectatorInventory(String targetName, String title, boolean offlineSupport) {
        return this.mainSpectatorInventory(targetName, title, offlineSupport, this.inventoryMirror);
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<MainSpectatorInventory>> mainSpectatorInventory(String targetName, String title, boolean offlineSupport, Mirror<PlayerInventorySlot> mirror) {
        return this.mainSpectatorInventory(targetName, this.mainInventoryCreationOptions().withTitle(title).withOfflinePlayerSupport(offlineSupport).withMirror(mirror));
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<MainSpectatorInventory>> mainSpectatorInventory(UUID playerId, String playerName, String title) {
        return this.mainSpectatorInventory(playerId, playerName, title, this.offlinePlayerSupport);
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<MainSpectatorInventory>> mainSpectatorInventory(UUID playerId, String playerName, String title, boolean offlineSupport) {
        return this.mainSpectatorInventory(playerId, playerName, title, offlineSupport, this.inventoryMirror);
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<MainSpectatorInventory>> mainSpectatorInventory(UUID playerId, String playerName, String title, boolean offlineSupport, Mirror<PlayerInventorySlot> mirror) {
        return this.mainSpectatorInventory(playerId, playerName, CreationOptions.of(this.plugin, Title.of(title), offlineSupport, mirror, this.unknownPlayerSupport, false, LogOptions.empty()));
    }

    @Deprecated
    public final SpectateResponse<EnderSpectatorInventory> enderSpectatorInventory(HumanEntity target, String title) {
        return this.enderSpectatorInventory(target, this.enderInventoryCreationOptions().withTitle(title));
    }

    @Deprecated
    public final SpectateResponse<EnderSpectatorInventory> enderSpectatorInventory(HumanEntity target, String title, Mirror<EnderChestSlot> mirror) {
        return this.enderSpectatorInventory(target, this.enderInventoryCreationOptions().withTitle(title).withMirror(mirror));
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<EnderSpectatorInventory>> enderSpectatorInventory(String targetName, String title) {
        return this.enderSpectatorInventory(targetName, title, this.offlinePlayerSupport);
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<EnderSpectatorInventory>> enderSpectatorInventory(String targetName, String title, boolean offlineSupport) {
        return this.enderSpectatorInventory(targetName, title, offlineSupport, this.enderchestMirror);
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<EnderSpectatorInventory>> enderSpectatorInventory(String targetName, String title, boolean offlineSupport, Mirror<EnderChestSlot> mirror) {
        return this.enderSpectatorInventory(targetName, this.enderInventoryCreationOptions().withTitle(title).withOfflinePlayerSupport(offlineSupport).withMirror(mirror));
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<EnderSpectatorInventory>> enderSpectatorInventory(UUID playerId, String playerName, String title) {
        return this.enderSpectatorInventory(playerId, playerName, title, this.offlinePlayerSupport);
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<EnderSpectatorInventory>> enderSpectatorInventory(UUID playerId, String playerName, String title, boolean offlineSupport) {
        return this.enderSpectatorInventory(playerId, playerName, title, offlineSupport, this.enderchestMirror);
    }

    @Deprecated
    public final CompletableFuture<SpectateResponse<EnderSpectatorInventory>> enderSpectatorInventory(UUID playerId, String playerName, String title, boolean offlineSupport, Mirror<EnderChestSlot> mirror) {
        return this.enderSpectatorInventory(playerId, playerName, this.enderInventoryCreationOptions().withTitle(title).withOfflinePlayerSupport(offlineSupport).withMirror(mirror));
    }

    @Deprecated
    public final void openMainSpectatorInventory(Player spectator, MainSpectatorInventory spectatorInventory, String title, Mirror<PlayerInventorySlot> mirror) {
        this.platform.openMainSpectatorInventory(spectator, spectatorInventory, this.mainInventoryCreationOptions().withTitle(title).withMirror(mirror));
    }

    @Deprecated
    public final void openEnderSpectatorInventory(Player spectator, EnderSpectatorInventory spectatorInventory, String title, Mirror<EnderChestSlot> mirror) {
        this.platform.openEnderSpectatorInventory(spectator, spectatorInventory, this.enderInventoryCreationOptions().withTitle(title).withMirror(mirror));
    }

    @Deprecated
    public final CompletableFuture<Optional<EnderSpectatorInventory>> createOfflineEnderChest(UUID playerId, String playerName, String title, Mirror<EnderChestSlot> mirror) {
        return this.platform.createOfflineEnderChest(playerId, playerName, this.enderInventoryCreationOptions().withTitle(title).withMirror(mirror)).thenApply(response -> response.isSuccess() ? Optional.of((EnderSpectatorInventory)response.getInventory()) : Optional.empty());
    }

    @Deprecated
    public final CompletableFuture<Optional<EnderSpectatorInventory>> createOfflineEnderChest(UUID playerId, String playerName, String title) {
        return this.platform.createOfflineEnderChest(playerId, playerName, this.enderInventoryCreationOptions().withTitle(title)).thenApply(response -> response.isSuccess() ? Optional.of((EnderSpectatorInventory)response.getInventory()) : Optional.empty());
    }

    @Deprecated
    public final EnderSpectatorInventory spectateEnderChest(HumanEntity player, String title, Mirror<EnderChestSlot> mirror) {
        return this.platform.spectateEnderChest(player, this.enderInventoryCreationOptions().withTitle(title).withMirror(mirror));
    }

    @Deprecated
    public final EnderSpectatorInventory spectateEnderChest(HumanEntity player, String title) {
        return this.platform.spectateEnderChest(player, this.enderInventoryCreationOptions().withTitle(title));
    }

    @Deprecated
    public final CompletableFuture<Optional<MainSpectatorInventory>> createOfflineInventory(UUID playerId, String playerName, String title, Mirror<PlayerInventorySlot> mirror) {
        return this.platform.createOfflineInventory(playerId, playerName, this.mainInventoryCreationOptions().withTitle(title).withMirror(mirror)).thenApply(response -> response.isSuccess() ? Optional.of((MainSpectatorInventory)response.getInventory()) : Optional.empty());
    }

    @Deprecated
    public final CompletableFuture<Optional<MainSpectatorInventory>> createOfflineInventory(UUID playerId, String playerName, String title) {
        return this.platform.createOfflineInventory(playerId, playerName, this.mainInventoryCreationOptions().withTitle(title)).thenApply(response -> response.isSuccess() ? Optional.of((MainSpectatorInventory)response.getInventory()) : Optional.empty());
    }

    @Deprecated
    public final MainSpectatorInventory spectateInventory(HumanEntity player, String title, Mirror<PlayerInventorySlot> mirror) {
        return this.platform.spectateInventory(player, this.mainInventoryCreationOptions().withTitle(title).withMirror(mirror));
    }

    @Deprecated
    public final MainSpectatorInventory spectateInventory(HumanEntity player, String title) {
        return this.platform.spectateInventory(player, this.mainInventoryCreationOptions().withTitle(title));
    }

    private final class PlayerListener
    implements Listener {
        private PlayerListener() {
        }

        @EventHandler(priority=EventPriority.LOW)
        public void onJoin(PlayerJoinEvent event) {
            CompletableFuture enderUuidFuture;
            CompletableFuture enderNameFuture;
            CompletableFuture mainInvUuidFuture;
            Player player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            String userName = player.getName();
            MainSpectatorInventory newInventorySpectator = null;
            EnderSpectatorInventory newEnderSpectator = null;
            CompletableFuture mainInvNameFuture = (CompletableFuture)InvseeAPI.this.pendingInventoriesByName.remove(userName);
            if (mainInvNameFuture != null) {
                newInventorySpectator = InvseeAPI.this.platform.spectateInventory((HumanEntity)player, InvseeAPI.this.mainInventoryCreationOptions());
                mainInvNameFuture.complete(SpectateResponse.succeed(newInventorySpectator));
            }
            if ((mainInvUuidFuture = (CompletableFuture)InvseeAPI.this.pendingInventoriesByUuid.remove(uuid)) != null) {
                mainInvUuidFuture.complete(SpectateResponse.succeed(newInventorySpectator != null ? newInventorySpectator : (newInventorySpectator = InvseeAPI.this.platform.spectateInventory((HumanEntity)player, InvseeAPI.this.mainInventoryCreationOptions()))));
            }
            if ((enderNameFuture = (CompletableFuture)InvseeAPI.this.pendingEnderChestsByName.remove(userName)) != null) {
                newEnderSpectator = InvseeAPI.this.platform.spectateEnderChest((HumanEntity)player, InvseeAPI.this.enderInventoryCreationOptions());
                enderNameFuture.complete(SpectateResponse.succeed(newEnderSpectator));
            }
            if ((enderUuidFuture = (CompletableFuture)InvseeAPI.this.pendingEnderChestsByUuid.remove(uuid)) != null) {
                enderUuidFuture.complete(SpectateResponse.succeed(newEnderSpectator != null ? newEnderSpectator : (newEnderSpectator = InvseeAPI.this.platform.spectateEnderChest((HumanEntity)player, InvseeAPI.this.enderInventoryCreationOptions()))));
            }
            MainSpectatorInventory oldMainSpectator = InvseeAPI.this.openSpectatorsCache.getMainSpectatorInventory(uuid);
            EnderSpectatorInventory oldEnderSpectator = InvseeAPI.this.openSpectatorsCache.getEnderSpectatorInventory(uuid);
            if (oldMainSpectator != null && InvseeAPI.this.transferInvToLivePlayer.test(oldMainSpectator, player)) {
                if (newInventorySpectator == null) {
                    newInventorySpectator = InvseeAPI.this.platform.spectateInventory((HumanEntity)player, InvseeAPI.this.mainInventoryCreationOptions());
                    newInventorySpectator.setContents(oldMainSpectator);
                }
                if (oldMainSpectator instanceof ShallowCopy) {
                    ((ShallowCopy)((Object)oldMainSpectator)).shallowCopyFrom(newInventorySpectator);
                } else {
                    for (HumanEntity viewer : Compat.listCopy(oldMainSpectator.getViewers())) {
                        viewer.closeInventory();
                        viewer.openInventory((Inventory)newInventorySpectator);
                    }
                    InvseeAPI.this.openSpectatorsCache.cache(newInventorySpectator, true);
                }
            }
            if (oldEnderSpectator != null && InvseeAPI.this.transferEnderToLivePlayer.test(oldEnderSpectator, player)) {
                if (newEnderSpectator == null) {
                    newEnderSpectator = InvseeAPI.this.platform.spectateEnderChest((HumanEntity)player, InvseeAPI.this.enderInventoryCreationOptions());
                    newEnderSpectator.setContents(oldEnderSpectator);
                }
                if (oldEnderSpectator instanceof ShallowCopy) {
                    ((ShallowCopy)((Object)oldEnderSpectator)).shallowCopyFrom(newEnderSpectator);
                } else {
                    for (HumanEntity viewer : Compat.listCopy(oldEnderSpectator.getViewers())) {
                        viewer.closeInventory();
                        viewer.openInventory((Inventory)newEnderSpectator);
                    }
                    InvseeAPI.this.openSpectatorsCache.cache(newEnderSpectator, true);
                }
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onQuit(PlayerQuitEvent event) {
            Player player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            InvseeAPI.this.lookup.cacheNameAndUniqueId(uuid, player.getName());
        }
    }

    private final class InventoryListener
    implements Listener {
        private InventoryListener() {
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onSpectatorClose(InventoryCloseEvent event) {
            Inventory inventory = event.getInventory();
            if (inventory instanceof MainSpectatorInventory) {
                MainSpectatorInventory spectatorInventory = (MainSpectatorInventory)inventory;
                if (event.getPlayer().getServer().getPlayer(spectatorInventory.getSpectatedPlayerId()) == null) {
                    InvseeAPI.this.saveInventory(spectatorInventory).whenComplete((voidResult, throwable) -> {
                        if (throwable != null) {
                            InvseeAPI.this.plugin.getLogger().log(Level.SEVERE, "Error while saving offline inventory", (Throwable)throwable);
                            event.getPlayer().sendMessage(ChatColor.RED + "Something went wrong when trying to save the inventory.");
                        }
                    });
                }
            } else if (inventory instanceof EnderSpectatorInventory) {
                EnderSpectatorInventory spectatorInventory = (EnderSpectatorInventory)inventory;
                if (event.getPlayer().getServer().getPlayer(spectatorInventory.getSpectatedPlayerId()) == null) {
                    InvseeAPI.this.saveEnderChest(spectatorInventory).whenComplete((voidResult, throwable) -> {
                        if (throwable != null) {
                            InvseeAPI.this.plugin.getLogger().log(Level.SEVERE, "Error while saving offline enderchest", (Throwable)throwable);
                            event.getPlayer().sendMessage(ChatColor.RED + "Something went wrong when trying to save the enderchest.");
                        }
                    });
                }
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onTargetOpen(InventoryOpenEvent event) {
            HumanEntity target = event.getPlayer();
            MainSpectatorInventory spectatorInventory = InvseeAPI.this.openSpectatorsCache.getMainSpectatorInventory(target.getUniqueId());
            if (spectatorInventory instanceof Personal) {
                ((Personal)((Object)spectatorInventory)).watch(event.getView());
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onTargetClose(InventoryCloseEvent event) {
            HumanEntity target = event.getPlayer();
            MainSpectatorInventory spectatorInventory = InvseeAPI.this.openSpectatorsCache.getMainSpectatorInventory(target.getUniqueId());
            if (spectatorInventory instanceof Personal) {
                ((Personal)((Object)spectatorInventory)).unwatch();
            }
        }
    }
}

