/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot;

import com.janboerman.invsee.spigot.SetupImpl;
import com.janboerman.invsee.spigot.SetupProvider;
import com.janboerman.invsee.spigot.api.OfflinePlayerProvider;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.internal.InvseePlatform;
import com.janboerman.invsee.spigot.internal.NamesAndUUIDs;
import com.janboerman.invsee.spigot.internal.OpenSpectatorsCache;
import com.janboerman.invsee.spigot.internal.version.LegacyVersions;
import com.janboerman.invsee.spigot.internal.version.ServerSoftware;
import com.janboerman.invsee.spigot.internal.version.SupportedServerSoftware;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public interface Setup {
    public InvseePlatform platform();

    default public OfflinePlayerProvider offlinePlayerProvider() {
        return OfflinePlayerProvider.Dummy.INSTANCE;
    }

    public static Setup setup(Plugin plugin, Scheduler scheduler, NamesAndUUIDs lookup, OpenSpectatorsCache cache) {
        Server server = plugin.getServer();
        ServerSoftware serverSoftware = ServerSoftware.detect(server);
        plugin.getLogger().info("Detected server software: " + serverSoftware);
        if (serverSoftware == null) {
            throw new RuntimeException(SupportedServerSoftware.getUnsupportedPlatformMessage(server));
        }
        SetupProvider provider = SetupImpl.SUPPORTED.getImplementationProvider(serverSoftware);
        if (provider == null) {
            String supportedVersionsMessage = SetupImpl.SUPPORTED.getUnsupportedVersionMessage(serverSoftware.getPlatform(), server);
            String legacyVersionsMessage = LegacyVersions.getLegacyVersionMessage(serverSoftware.getVersion());
            if (legacyVersionsMessage != null) {
                plugin.getLogger().severe(legacyVersionsMessage);
            }
            throw new RuntimeException(supportedVersionsMessage);
        }
        return provider.provide(plugin, lookup, scheduler, cache);
    }
}

