/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot;

import com.janboerman.invsee.bstats.bukkit.Metrics;
import com.janboerman.invsee.bstats.charts.SimplePie;
import com.janboerman.invsee.folia.FoliaScheduler;
import com.janboerman.invsee.paper.AsyncTabCompleter;
import com.janboerman.invsee.spigot.DefaultScheduler;
import com.janboerman.invsee.spigot.EnderseeCommandExecutor;
import com.janboerman.invsee.spigot.InvseeCommandExecutor;
import com.janboerman.invsee.spigot.InvseeTabCompleter;
import com.janboerman.invsee.spigot.ReloadCommandExecutor;
import com.janboerman.invsee.spigot.Setup;
import com.janboerman.invsee.spigot.SpectatorInventoryEditListener;
import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.InvseeAPI;
import com.janboerman.invsee.spigot.api.OfflinePlayerProvider;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.Title;
import com.janboerman.invsee.spigot.api.logging.LogGranularity;
import com.janboerman.invsee.spigot.api.logging.LogOptions;
import com.janboerman.invsee.spigot.api.logging.LogTarget;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderPalette;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.internal.ConstantTitle;
import com.janboerman.invsee.spigot.internal.InvseePlatform;
import com.janboerman.invsee.spigot.internal.NamesAndUUIDs;
import com.janboerman.invsee.spigot.internal.OpenSpectatorsCache;
import com.janboerman.invsee.spigot.perworldinventory.PerWorldInventoryHook;
import com.janboerman.invsee.spigot.perworldinventory.PerWorldInventorySeeApi;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class InvseePlusPlus
extends JavaPlugin
implements com.janboerman.invsee.spigot.api.InvseePlusPlus {
    public static final String TABCOMPLETION_PERMISSION = "invseeplusplus.tabcomplete";
    private final boolean asyncTabcompleteEvent;
    private InvseeAPI api;
    private InvseePlatform platform;
    @Deprecated
    private OfflinePlayerProvider offlinePlayerProvider;
    private CreationOptions<PlayerInventorySlot> platformCreationOptionsMainInventory;
    private CreationOptions<EnderChestSlot> platformCreationOptionsEnderInventory;
    private boolean dirtyConfig = false;
    private Metrics bstats;

    public InvseePlusPlus() {
        boolean asyncTabCompleteEvent;
        try {
            Class.forName("com.destroystokyo.paper.event.server.AsyncTabCompleteEvent");
            asyncTabCompleteEvent = true;
        }
        catch (ClassNotFoundException e) {
            asyncTabCompleteEvent = false;
        }
        this.asyncTabcompleteEvent = asyncTabCompleteEvent;
    }

    public void onEnable() {
        PerWorldInventoryHook pwiHook;
        this.saveDefaultConfig();
        Scheduler scheduler = InvseePlusPlus.makeScheduler(this);
        NamesAndUUIDs lookup = new NamesAndUUIDs((Plugin)this, scheduler);
        OpenSpectatorsCache cache = new OpenSpectatorsCache();
        Setup setup = Setup.setup((Plugin)this, scheduler, lookup, cache);
        this.platform = setup.platform();
        OfflinePlayerProvider playerDatabase = setup.offlinePlayerProvider();
        this.platformCreationOptionsMainInventory = this.platform.defaultInventoryCreationOptions((Plugin)this);
        this.platformCreationOptionsEnderInventory = this.platform.defaultEnderChestCreationOptions((Plugin)this);
        this.offlinePlayerProvider = playerDatabase;
        if (this.offlinePlayerSupport() && (pwiHook = new PerWorldInventoryHook((Plugin)this)).trySetup()) {
            if (pwiHook.managesEitherInventory()) {
                this.api = new PerWorldInventorySeeApi((Plugin)this, lookup, scheduler, cache, this.platform, pwiHook);
                this.getLogger().info("Enabled PerWorldInventory integration.");
            }
        } else {
            this.api = new InvseeAPI((Plugin)this, this.platform, lookup, scheduler, cache);
        }
        assert (this.api != null) : "did not set the InvseeAPI instance!";
        FileConfiguration config = this.loadConfig();
        this.tabCompleteOfflinePlayers(config);
        this.api.setOfflinePlayerSupport(this.offlinePlayerSupport(config));
        this.api.setUnknownPlayerSupport(this.unknownPlayerSupport(config));
        this.api.setMainInventoryTitle(this.getTitleForInventory(config));
        this.api.setEnderInventoryTitle(this.getTitleForEnderChest(config));
        this.api.setMainInventoryMirror(this.getInventoryMirror(config));
        this.api.setEnderInventoryMirror(this.getEnderChestMirror(config));
        this.api.setLogOptions(this.getLogOptions(config));
        this.api.setPlaceholderPalette(this.getPlaceholderPalette(this.platform, config));
        this.setupCommands();
        this.setupEvents(scheduler, playerDatabase);
        this.setupBStats();
        if (this.dirtyConfig) {
            try {
                config.save(this.getConfigFile());
                this.dirtyConfig = false;
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Could not update config file!", e);
            }
        }
    }

    private void setupCommands() {
        InvseeTabCompleter tabCompleter = new InvseeTabCompleter(this);
        PluginCommand invseeCommand = this.getCommand("invsee");
        PluginCommand enderseeCommand = this.getCommand("endersee");
        PluginCommand reloadCommand = this.getCommand("invseeplusplusreload");
        invseeCommand.setExecutor((CommandExecutor)new InvseeCommandExecutor(this));
        enderseeCommand.setExecutor((CommandExecutor)new EnderseeCommandExecutor(this));
        reloadCommand.setExecutor((CommandExecutor)new ReloadCommandExecutor(this));
        invseeCommand.setTabCompleter((TabCompleter)tabCompleter);
        enderseeCommand.setTabCompleter((TabCompleter)tabCompleter);
    }

    private void setupEvents(Scheduler scheduler, OfflinePlayerProvider playerDatabase) {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new SpectatorInventoryEditListener(), (Plugin)this);
        if (this.offlinePlayerSupport() && this.tabCompleteOfflinePlayers() && this.asyncTabcompleteEvent) {
            pluginManager.registerEvents((Listener)new AsyncTabCompleter(this, scheduler, playerDatabase), (Plugin)this);
        }
    }

    private void setupBStats() {
        int pluginId = 9309;
        this.bstats = new Metrics(this, pluginId);
        this.bstats.addCustomChart(new SimplePie("Back-end", () -> {
            if (this.api instanceof PerWorldInventorySeeApi) {
                return "PerWorldInventory";
            }
            return "Vanilla";
        }));
    }

    public void onDisable() {
        if (this.api != null) {
            this.api.shutDown();
        }
        if (this.bstats != null) {
            this.bstats.shutdown();
        }
    }

    @Override
    public InvseeAPI getApi() {
        return this.api;
    }

    public Stream<Material> itemMaterials() {
        return this.platform.materials();
    }

    public boolean tabCompleteOfflinePlayers() {
        return this.tabCompleteOfflinePlayers(this.getConfig());
    }

    public boolean tabCompleteOfflinePlayers(FileConfiguration config) {
        Object value = config.get("tabcomplete-offline-players");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        this.dirtyConfig = true;
        config.set("tabcomplete-offline-players", (Object)this.asyncTabcompleteEvent);
        return this.asyncTabcompleteEvent;
    }

    public boolean offlinePlayerSupport() {
        return this.offlinePlayerSupport(this.getConfig());
    }

    public boolean offlinePlayerSupport(FileConfiguration config) {
        Object value = config.get("enable-offline-player-support");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        this.dirtyConfig = true;
        boolean offlinePlayerSupport = this.platformCreationOptionsMainInventory.isOfflinePlayerSupported();
        config.set("enable-offline-player-support", (Object)offlinePlayerSupport);
        return offlinePlayerSupport;
    }

    public boolean unknownPlayerSupport() {
        return this.unknownPlayerSupport(this.getConfig());
    }

    public boolean unknownPlayerSupport(FileConfiguration config) {
        Object value = config.get("enable-unknown-player-support");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        this.dirtyConfig = true;
        boolean unknownPlayerSupport = this.platformCreationOptionsMainInventory.isUnknownPlayerSupported();
        config.set("enable-unknown-player-support", (Object)unknownPlayerSupport);
        return unknownPlayerSupport;
    }

    public Title getTitleForInventory() {
        return this.getTitleForInventory(this.getConfig());
    }

    public Title getTitleForInventory(FileConfiguration config) {
        String configuredTitle = config.getString("titles.inventory");
        if (configuredTitle == null) {
            this.dirtyConfig = true;
            Title value = this.platformCreationOptionsMainInventory.getTitle();
            if (value == Title.defaultMainInventory()) {
                config.set("titles.inventory", (Object)"<player>'s inventory");
            } else if (value instanceof ConstantTitle) {
                config.set("titles.inventory", (Object)((ConstantTitle)value).getTitle());
            }
            return value;
        }
        return target -> configuredTitle.replace("<player>", target.toString());
    }

    public Title getTitleForEnderChest() {
        return this.getTitleForEnderChest(this.getConfig());
    }

    public Title getTitleForEnderChest(FileConfiguration config) {
        String configuredTitle = config.getString("titles.enderchest");
        if (configuredTitle == null) {
            this.dirtyConfig = true;
            Title value = this.platformCreationOptionsEnderInventory.getTitle();
            if (value == Title.defaultEnderInventory()) {
                config.set("titles.enderchest", (Object)"<player>'s enderchest");
            } else if (value instanceof ConstantTitle) {
                config.set("titles.enderchest", (Object)((ConstantTitle)value).getTitle());
            }
            return value;
        }
        return target -> configuredTitle.replace("<player>", target.toString());
    }

    public Mirror<PlayerInventorySlot> getInventoryMirror() {
        return this.getInventoryMirror(this.getConfig());
    }

    public Mirror<PlayerInventorySlot> getInventoryMirror(FileConfiguration config) {
        String template = config.getString("templates.inventory");
        if (template != null) {
            return Mirror.forInventory(template);
        }
        this.dirtyConfig = true;
        Mirror<PlayerInventorySlot> value = this.platformCreationOptionsMainInventory.getMirror();
        config.set("templates.inventory", (Object)Mirror.toInventoryTemplate(value));
        return value;
    }

    public Mirror<EnderChestSlot> getEnderChestMirror() {
        return this.getEnderChestMirror(this.getConfig());
    }

    public Mirror<EnderChestSlot> getEnderChestMirror(FileConfiguration config) {
        String template = config.getString("templates.enderchest");
        if (template != null) {
            return Mirror.forEnderChest(template);
        }
        this.dirtyConfig = true;
        Mirror<EnderChestSlot> value = this.platformCreationOptionsEnderInventory.getMirror();
        config.set("templates.enderchest", (Object)Mirror.toEnderChestTemplate(value));
        return value;
    }

    public LogOptions getLogOptions() {
        return this.getLogOptions(this.getConfig());
    }

    public LogOptions getLogOptions(FileConfiguration config) {
        String formatConsole;
        String formatSpectatorLogFile;
        String formatPluginLogFile;
        ConfigurationSection loggingSection = config.getConfigurationSection("logging");
        if (loggingSection == null) {
            this.dirtyConfig = true;
            LogOptions value = this.platformCreationOptionsMainInventory.getLogOptions();
            loggingSection = config.createSection("logging");
            loggingSection.set("granularity", (Object)value.getGranularity().name());
            loggingSection.set("output", value.getTargets().stream().map(Enum::name).collect(Collectors.toList()));
            loggingSection.set("format-server-log-file", (Object)value.getFormat(LogTarget.SERVER_LOG_FILE));
            loggingSection.set("format-plugin-log-file", (Object)value.getFormat(LogTarget.PLUGIN_LOG_FILE));
            loggingSection.set("format-spectator-log-file", (Object)value.getFormat(LogTarget.SERVER_LOG_FILE));
            loggingSection.set("format-console", (Object)value.getFormat(LogTarget.CONSOLE));
            return value;
        }
        String granularity = loggingSection.getString("granularity", "LOG_ON_CLOSE");
        LogGranularity logGranularity = LogGranularity.valueOf(granularity);
        List output = loggingSection.getStringList("output");
        EnumSet logTargets = output.stream().map(LogTarget::valueOf).collect(Collectors.toCollection(() -> EnumSet.noneOf(LogTarget.class)));
        EnumMap<LogTarget, String> formats = new EnumMap<LogTarget, String>(LogTarget.class);
        String formatServerLogFile = loggingSection.getString("format-server-log-file");
        if (formatServerLogFile != null) {
            formats.put(LogTarget.SERVER_LOG_FILE, formatServerLogFile);
        }
        if ((formatPluginLogFile = loggingSection.getString("format-plugin-log-file")) != null) {
            formats.put(LogTarget.PLUGIN_LOG_FILE, formatPluginLogFile);
        }
        if ((formatSpectatorLogFile = loggingSection.getString("format-spectator-log-file")) != null) {
            formats.put(LogTarget.SPECTATOR_LOG_FILE, formatSpectatorLogFile);
        }
        if ((formatConsole = loggingSection.getString("format-console")) != null) {
            formats.put(LogTarget.CONSOLE, formatConsole);
        }
        return LogOptions.of(logGranularity, logTargets, formats);
    }

    public PlaceholderPalette getPlaceholderPalette() {
        return this.getPlaceholderPalette(this.platform, this.getConfig());
    }

    public PlaceholderPalette getPlaceholderPalette(InvseePlatform platform, FileConfiguration config) {
        PlaceholderPalette palette;
        String paletteName = config.getString("placeholder-palette");
        if (paletteName == null) {
            this.dirtyConfig = true;
            palette = this.platformCreationOptionsMainInventory.getPlaceholderPalette();
            config.set("placeholder-palette", (Object)palette.toString());
        } else {
            palette = platform.getPlaceholderPalette(paletteName);
        }
        return palette;
    }

    private File getConfigFile() {
        return new File(this.getDataFolder(), "config.yml");
    }

    private FileConfiguration loadConfig() {
        return YamlConfiguration.loadConfiguration((File)this.getConfigFile());
    }

    private static Scheduler makeScheduler(InvseePlusPlus plugin) {
        boolean folia;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            folia = true;
        }
        catch (ClassNotFoundException e) {
            folia = false;
        }
        if (folia) {
            return new FoliaScheduler(plugin);
        }
        return new DefaultScheduler(plugin);
    }

    @Deprecated
    public String getTitleForInventory(Target target) {
        return this.getConfig().getString("titles.inventory", "<player>'s inventory").replace("<player>", target.toString());
    }

    @Deprecated
    public String getTitleForEnderChest(Target target) {
        return this.getConfig().getString("titles.enderchest", "<player>'s enderchest").replace("<player>", target.toString());
    }

    @Deprecated
    public String getInventoryTemplate() {
        return this.getConfig().getString("templates.inventory", "i_00 i_01 i_02 i_03 i_04 i_05 i_06 i_07 i_08\ni_09 i_10 i_11 i_12 i_13 i_14 i_15 i_16 i_17\ni_18 i_19 i_20 i_21 i_22 i_23 i_24 i_25 i_26\ni_27 i_28 i_29 i_30 i_31 i_32 i_33 i_34 i_35\na_b  a_l  a_c  a_h  oh   c    _    _    _   \np_00 p_01 p_02 p_03 p_04 p_05 p_06 p_07 p_08");
    }

    @Deprecated
    public String getEnderChestTemplate() {
        return this.getConfig().getString("templates.enderchest", "e_00 e_01 e_02 e_03 e_04 e_05 e_06 e_07 e_08\ne_09 e_10 e_11 e_12 e_13 e_14 e_15 e_16 e_17\ne_18 e_19 e_20 e_21 e_22 e_23 e_24 e_25 e_26\ne_27 e_28 e_29 e_30 e_31 e_32 e_33 e_34 e_35\ne_36 e_37 e_38 e_39 e_40 e_41 e_42 e_43 e_44\ne_45 e_46 e_47 e_48 e_49 e_50 e_51 e_52 e_53");
    }

    @Deprecated
    public OfflinePlayerProvider getOfflinePlayerProvider() {
        return this.offlinePlayerProvider;
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        sender.sendMessage(ChatColor.YELLOW + "Oh no! It looks like InvSee++ didn't start correctly!");
        sender.sendMessage(ChatColor.YELLOW + "Most likely this is a Minecraft/InvSee++ version mismatch.");
        sender.sendMessage(ChatColor.YELLOW + "Check your logs for more information.");
        return true;
    }
}

