/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot;

import com.janboerman.invsee.spigot.InvseePlusPlus;
import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.InvseeAPI;
import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import com.janboerman.invsee.spigot.api.MainSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.response.ImplementationFault;
import com.janboerman.invsee.spigot.api.response.InventoryNotCreated;
import com.janboerman.invsee.spigot.api.response.InventoryOpenEventCancelled;
import com.janboerman.invsee.spigot.api.response.NotCreatedReason;
import com.janboerman.invsee.spigot.api.response.NotOpenedReason;
import com.janboerman.invsee.spigot.api.response.OfflineSupportDisabled;
import com.janboerman.invsee.spigot.api.response.OpenResponse;
import com.janboerman.invsee.spigot.api.response.SpectateResponse;
import com.janboerman.invsee.spigot.api.response.TargetDoesNotExist;
import com.janboerman.invsee.spigot.api.response.TargetHasExemptPermission;
import com.janboerman.invsee.spigot.api.response.UnknownTarget;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.perworldinventory.PerWorldInventorySeeApi;
import com.janboerman.invsee.spigot.perworldinventory.ProfileId;
import com.janboerman.invsee.spigot.perworldinventory.PwiCommandArgs;
import com.janboerman.invsee.utils.Either;
import com.janboerman.invsee.utils.StringHelper;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class InvseeCommandExecutor
implements CommandExecutor {
    private final InvseePlusPlus plugin;

    public InvseeCommandExecutor(InvseePlusPlus plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CompletionStage<OpenResponse<MainSpectatorInventoryView>> fut;
        boolean isUuid;
        if (args.length == 0) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        String playerNameOrUUID = args[0];
        UUID uuid = null;
        try {
            uuid = UUID.fromString(playerNameOrUUID);
            isUuid = true;
        }
        catch (IllegalArgumentException e) {
            isUuid = false;
        }
        boolean finalIsUuid = isUuid;
        InvseeAPI api = this.plugin.getApi();
        Target target = isUuid ? Target.byUniqueId(uuid) : Target.byUsername(playerNameOrUUID);
        CreationOptions<PlayerInventorySlot> creationOptions = CreationOptions.defaultMainInventory((Plugin)this.plugin).withTitle(this.plugin.getTitleForInventory()).withMirror(this.plugin.getInventoryMirror()).withOfflinePlayerSupport(this.plugin.offlinePlayerSupport()).withUnknownPlayerSupport(this.plugin.unknownPlayerSupport()).withBypassExemptedPlayers(player.hasPermission("invseeplusplus.bypass-exempt.invsee")).withLogOptions(this.plugin.getLogOptions()).withPlaceholderPalette(this.plugin.getPlaceholderPalette());
        CompletionStage pwiFuture = null;
        if (args.length > 1 && api instanceof PerWorldInventorySeeApi) {
            PerWorldInventorySeeApi pwiApi;
            String pwiArgument = StringHelper.joinArray(" ", 1, args);
            Either<String, PwiCommandArgs> either = PwiCommandArgs.parse(pwiArgument, (pwiApi = (PerWorldInventorySeeApi)api).getHook());
            if (either.isLeft()) {
                player.sendMessage(ChatColor.RED + either.getLeft());
                return true;
            }
            PwiCommandArgs pwiOptions = either.getRight();
            CompletableFuture<Optional<UUID>> uuidFuture = isUuid ? CompletableFuture.completedFuture(Optional.of(uuid)) : pwiApi.fetchUniqueId(playerNameOrUUID);
            pwiFuture = uuidFuture.thenCompose(optId -> {
                if (optId.isPresent()) {
                    UUID uniqueId = (UUID)optId.get();
                    ProfileId profileId = new ProfileId(pwiApi.getHook(), pwiOptions, uniqueId);
                    CompletableFuture<String> userNameFuture = finalIsUuid ? ((CompletableFuture)api.fetchUserName(uniqueId).thenApply(o -> o.orElse("InvSee++ Player"))).exceptionally(t -> "InvSee++ Player") : CompletableFuture.completedFuture(playerNameOrUUID);
                    return userNameFuture.thenCompose(playerName -> pwiApi.spectateInventory(uniqueId, (String)playerName, creationOptions, profileId));
                }
                return CompletableFuture.completedFuture(SpectateResponse.fail(NotCreatedReason.targetDoesNotExists(target)));
            });
        }
        if (pwiFuture != null) {
            fut = pwiFuture.thenApply(response -> response.isSuccess() ? ((PerWorldInventorySeeApi)api).openMainSpectatorInventory(player, (MainSpectatorInventory)response.getInventory(), creationOptions) : OpenResponse.closed(NotOpenedReason.notCreated(response.getReason())));
        } else if (isUuid) {
            UUID finalUuid = uuid;
            fut = ((CompletableFuture)((CompletableFuture)api.fetchUserName(uuid).thenApply(o -> o.orElse("InvSee++ Player"))).exceptionally(t -> "InvSee++ Player")).thenCompose(userName -> api.spectateInventory(player, finalUuid, (String)userName, creationOptions));
        } else {
            fut = api.spectateInventory(player, playerNameOrUUID, creationOptions);
        }
        fut.whenComplete((response, throwable) -> {
            if (throwable != null) {
                player.sendMessage(ChatColor.RED + "An error occurred while trying to open " + playerNameOrUUID + "'s inventory.");
                this.plugin.getLogger().log(Level.SEVERE, "Error while trying to create main-inventory spectator inventory", (Throwable)throwable);
            } else if (!response.isOpen()) {
                NotOpenedReason notOpenedReason = response.getReason();
                if (notOpenedReason instanceof InventoryOpenEventCancelled) {
                    player.sendMessage(ChatColor.RED + "Another plugin prevented you from spectating " + playerNameOrUUID + "'s inventory");
                } else if (notOpenedReason instanceof InventoryNotCreated) {
                    NotCreatedReason notCreatedReason = ((InventoryNotCreated)notOpenedReason).getNotCreatedReason();
                    if (notCreatedReason instanceof TargetDoesNotExist) {
                        player.sendMessage(ChatColor.RED + "Player " + playerNameOrUUID + " does not exist.");
                    } else if (notCreatedReason instanceof UnknownTarget) {
                        player.sendMessage(ChatColor.RED + "Player " + playerNameOrUUID + " has not logged onto the server yet.");
                    } else if (notCreatedReason instanceof TargetHasExemptPermission) {
                        player.sendMessage(ChatColor.RED + "Player " + playerNameOrUUID + " is exempted from being spectated.");
                    } else if (notCreatedReason instanceof ImplementationFault) {
                        player.sendMessage(ChatColor.RED + "An internal fault occurred when trying to load " + playerNameOrUUID + "'s inventory.");
                    } else if (notCreatedReason instanceof OfflineSupportDisabled) {
                        player.sendMessage(ChatColor.RED + "Spectating offline players' inventories is disabled.");
                    } else {
                        player.sendMessage(ChatColor.RED + "Could not create " + playerNameOrUUID + "'s inventory for an unknown reason.");
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "Could not open " + playerNameOrUUID + "'s inventory for an unknown reason.");
                }
            }
        });
        return true;
    }
}

