/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot;

import com.janboerman.invsee.spigot.InvseePlusPlus;
import com.janboerman.invsee.spigot.api.Scheduler;
import java.util.UUID;
import org.bukkit.entity.HumanEntity;
import org.bukkit.plugin.Plugin;

public class DefaultScheduler
implements Scheduler {
    private final InvseePlusPlus plugin;

    public DefaultScheduler(InvseePlusPlus plugin) {
        this.plugin = plugin;
    }

    @Override
    public void executeSyncPlayer(UUID playerId, Runnable task, Runnable retired) {
        this.executeSync(task);
    }

    public void executeSyncPlayer(HumanEntity player, Runnable task, Runnable retired) {
        this.executeSync(task);
    }

    @Override
    public void executeSyncGlobal(Runnable task) {
        this.executeSync(task);
    }

    @Override
    public void executeSyncGlobalRepeatedly(Runnable task, long ticksInitialDelay, long ticksPeriod) {
        this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, task, ticksInitialDelay, ticksPeriod);
    }

    private void executeSync(Runnable task) {
        if (this.plugin.getServer().isPrimaryThread()) {
            task.run();
        } else {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, task);
        }
    }

    @Override
    public void executeAsync(Runnable task) {
        if (!this.plugin.getServer().isPrimaryThread()) {
            task.run();
        } else {
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, task);
        }
    }

    @Override
    public void executeLaterGlobal(Runnable task, long delayTicks) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, task, delayTicks);
    }

    @Override
    public void executeLaterAsync(Runnable task, long delayTicks) {
        this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, task, delayTicks);
    }
}

