/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.mojangapi;

import com.janboerman.invsee.jsonsimple.JSONObject;
import com.janboerman.invsee.jsonsimple.parser.JSONParser;
import com.janboerman.invsee.jsonsimple.parser.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ResponseUtils {
    static final int HTTP_NO_CONTENT = 204;
    static final int HTTP_BAD_REQUEST = 400;
    static final int HTTP_TOO_MANY_REQUESTS = 429;

    private ResponseUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static JSONObject readJSONObject(HttpURLConnection connection) {
        Charset charset = ResponseUtils.charsetFromHeader(connection.getHeaderField("Content-Type"));
        try (InputStream inputStream = connection.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);){
            Object json = new JSONParser().parse(inputStreamReader);
            if (!(json instanceof JSONObject)) throw new RuntimeException("Expected response to be represented as a JSON Object, instead we got: " + json);
            JSONObject jSONObject = (JSONObject)json;
            return jSONObject;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not read http response body", ioe);
        }
        catch (ParseException pe) {
            throw new RuntimeException("Invalid JSON from api", pe);
        }
    }

    static Charset charsetFromHeader(String contentType) {
        String charsetPart;
        String[] charSetKeyAndValue;
        int indexOfSemi;
        if (contentType != null && (indexOfSemi = contentType.indexOf(59)) != -1 && (charSetKeyAndValue = (charsetPart = contentType.substring(indexOfSemi + 1).trim()).split("=", 2)).length == 2 && "charset".equalsIgnoreCase(charSetKeyAndValue[0])) {
            String charsetName = charSetKeyAndValue[1];
            return Charset.forName(charsetName);
        }
        return StandardCharsets.UTF_8;
    }
}

