/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.mojangapi;

import com.janboerman.invsee.jsonsimple.JSONObject;
import com.janboerman.invsee.mojangapi.ResponseUtils;
import com.janboerman.invsee.utils.Compat;
import com.janboerman.invsee.utils.Rethrow;
import com.janboerman.invsee.utils.UUIDHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MojangAPI {
    private final Executor asyncExecutor;

    public MojangAPI(Executor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    public CompletableFuture<Optional<UUID>> lookupUniqueId(String userName) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + userName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("User-Agent", "InvSee++/MojangAPI");
                int statusCode = connection.getResponseCode();
                if (statusCode == 200) {
                    JSONObject json = ResponseUtils.readJSONObject(connection);
                    String id = (String)json.get("id");
                    UUID uuid = UUIDHelper.dashed(id);
                    return Optional.of(uuid);
                }
                return MojangAPI.handleNotOk(statusCode, connection);
            }
            catch (IOException e) {
                return (Optional)Rethrow.unchecked(e);
            }
        }, this.asyncExecutor);
    }

    public CompletableFuture<Optional<String>> lookupUserName(UUID uniqueId) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + UUIDHelper.unDashed(uniqueId));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("User-Agent", "InvSee++/MojangAPI");
                int statusCode = connection.getResponseCode();
                if (statusCode == 200) {
                    JSONObject profileJson = ResponseUtils.readJSONObject(connection);
                    String userName = (String)profileJson.get("name");
                    return Optional.of(userName);
                }
                return MojangAPI.handleNotOk(statusCode, connection);
            }
            catch (IOException e) {
                return (Optional)Rethrow.unchecked(e);
            }
        }, this.asyncExecutor);
    }

    private static <T> Optional<T> handleNotOk(int statusCode, HttpURLConnection connection) throws IOException {
        assert (statusCode == connection.getResponseCode());
        switch (statusCode) {
            case 204: {
                return MojangAPI.handleNoContent(connection);
            }
            case 400: {
                return MojangAPI.handleBadRequest(connection);
            }
            case 429: {
                return MojangAPI.handleTooManyRequests(connection);
            }
        }
        return MojangAPI.handleUnknownStatusCode(statusCode);
    }

    private static <T> Optional<T> handleNoContent(HttpURLConnection connection) {
        return Optional.empty();
    }

    private static <T> Optional<T> handleBadRequest(HttpURLConnection connection) {
        JSONObject jsonObject = ResponseUtils.readJSONObject(connection);
        String error = (String)jsonObject.get("error");
        String errorMessage = (String)jsonObject.get("errorMessage");
        throw new RuntimeException("We sent a bad request to Mojang. We got a(n) " + error + " with the following message: " + errorMessage);
    }

    private static <T> Optional<T> handleTooManyRequests(HttpURLConnection connection) {
        try {
            InputStream inputStream = connection.getInputStream();
            try {
                byte[] bytes = Compat.readAllBytes(inputStream);
                Charset charset = ResponseUtils.charsetFromHeader(connection.getHeaderField("Content-Type"));
                String errorMessage = new String(bytes, charset);
                throw new RuntimeException("We were rate limited by Mojang. Error message: " + errorMessage);
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception occurred when processing 429 (rate limited) response.", e);
        }
    }

    private static <T> Optional<T> handleUnknownStatusCode(int statusCode) {
        throw new RuntimeException("Unexpected status code from Mojang API: " + statusCode);
    }
}

