/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.glowstone;

import com.janboerman.invsee.glowstone.GlowstoneHacks;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.resolve.UUIDResolveStrategy;
import com.janboerman.invsee.spigot.internal.CompletedEmpty;
import com.janboerman.invsee.spigot.internal.LogRecord;
import com.janboerman.invsee.spigot.internal.PlayerFileHelper;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import net.glowstone.GlowServer;
import net.glowstone.io.nbt.NbtPlayerDataService;
import net.glowstone.util.nbt.CompoundTag;
import org.bukkit.plugin.Plugin;

public class UUIDSearchSaveFilesStrategy
implements UUIDResolveStrategy {
    private final Plugin plugin;
    private final Scheduler scheduler;

    public UUIDSearchSaveFilesStrategy(Plugin plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    @Override
    public CompletableFuture<Optional<UUID>> resolveUniqueId(String userName) {
        GlowServer server = (GlowServer)this.plugin.getServer();
        NbtPlayerDataService playerDataService = (NbtPlayerDataService)server.getPlayerDataService();
        File playerDirectory = GlowstoneHacks.getPlayerDir(playerDataService);
        if (!playerDirectory.exists() || !playerDirectory.isDirectory()) {
            return CompletedEmpty.the();
        }
        return CompletableFuture.supplyAsync(() -> {
            File[] playerFiles = playerDirectory.listFiles((directory, fileName) -> PlayerFileHelper.isPlayerSaveFile(fileName));
            if (playerFiles != null) {
                CopyOnWriteArrayList<LogRecord> errors = new CopyOnWriteArrayList<LogRecord>();
                for (File playerFile : playerFiles) {
                    String fileName2 = playerFile.getName();
                    UUID playerId = UUIDSearchSaveFilesStrategy.uuidFromFileName(fileName2);
                    Executor syncExecutor = playerId == null ? this.scheduler::executeSyncGlobal : runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null);
                    try {
                        CompletionStage<Object> compoundFuture = CompletableFuture.completedFuture(GlowstoneHacks.readCompressed(playerFile));
                        compoundFuture = ((CompletableFuture)compoundFuture).handleAsync((tag, asyncEx) -> {
                            if (asyncEx == null) {
                                return tag;
                            }
                            try {
                                return GlowstoneHacks.readCompressed(playerFile);
                            }
                            catch (IOException syncEx) {
                                syncEx.addSuppressed((Throwable)asyncEx);
                                throw new CompletionException(syncEx);
                            }
                        }, syncExecutor);
                        try {
                            CompoundTag compound = (CompoundTag)((CompletableFuture)compoundFuture).get();
                            if (!UUIDSearchSaveFilesStrategy.tagHasLastKnownName(compound, userName)) continue;
                            String uuid = fileName2.substring(0, 36);
                            try {
                                return Optional.of(UUID.fromString(uuid));
                            }
                            catch (IllegalArgumentException e) {
                                errors.add(new LogRecord(Level.WARNING, "Encountered player save file name that is not a uuid: " + fileName2, e));
                            }
                        }
                        catch (ExecutionException e) {
                            Throwable syncEx = e.getCause();
                            errors.add(new LogRecord(Level.SEVERE, "Encountered player save file containing invalid NBT: " + fileName2, syncEx));
                        }
                        catch (InterruptedException e) {}
                    }
                    catch (IOException e) {
                        this.plugin.getLogger().log(Level.WARNING, "Error reading player's save file: " + playerFile.getAbsolutePath(), e);
                    }
                }
                for (LogRecord error : errors) {
                    this.plugin.getLogger().log(error.level, error.message, error.cause);
                }
            }
            return Optional.empty();
        }, this.scheduler::executeAsync);
    }

    private static UUID uuidFromFileName(String fileName) {
        String uuidChars = fileName.substring(0, 36);
        try {
            return UUID.fromString(uuidChars);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static boolean tagHasLastKnownName(CompoundTag tag, String userName) {
        CompoundTag bukkit;
        if (tag.isCompound("bukkit") && (bukkit = tag.getCompound("bukkit")).isString("lastKnownName")) {
            String lastKnownName = bukkit.getString("lastKnownName");
            return lastKnownName.equals(userName);
        }
        return false;
    }
}

