/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.glowstone;

import com.janboerman.invsee.glowstone.BootsSlot;
import com.janboerman.invsee.glowstone.ChestplateSlot;
import com.janboerman.invsee.glowstone.CursorSlot;
import com.janboerman.invsee.glowstone.GlowstoneHacks;
import com.janboerman.invsee.glowstone.HelmetSlot;
import com.janboerman.invsee.glowstone.InaccessibleSlot;
import com.janboerman.invsee.glowstone.InvseeImpl;
import com.janboerman.invsee.glowstone.LeggingsSlot;
import com.janboerman.invsee.glowstone.MainInventoryView;
import com.janboerman.invsee.glowstone.OffhandSlot;
import com.janboerman.invsee.glowstone.PersonalSlot;
import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderGroup;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderPalette;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.internal.inventory.Personal;
import com.janboerman.invsee.spigot.internal.inventory.ShallowCopy;
import com.janboerman.invsee.utils.Compat;
import com.janboerman.invsee.utils.ConcatList;
import com.janboerman.invsee.utils.UUIDHelper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.glowstone.entity.GlowHumanEntity;
import net.glowstone.entity.GlowPlayer;
import net.glowstone.inventory.GlowAnvilInventory;
import net.glowstone.inventory.GlowCraftingInventory;
import net.glowstone.inventory.GlowEnchantingInventory;
import net.glowstone.inventory.GlowInventory;
import net.glowstone.inventory.GlowInventorySlot;
import net.glowstone.inventory.GlowMerchantInventory;
import net.glowstone.inventory.GlowPlayerInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

class MainInventory
extends GlowInventory
implements MainSpectatorInventory,
ShallowCopy<MainInventory>,
Personal {
    final UUID targetPlayerUuid;
    final String targetPlayerName;
    final CreationOptions<PlayerInventorySlot> creationOptions;
    final List<GlowInventorySlot> containerSlots;
    final List<GlowInventorySlot> armourSlots;
    final GlowInventorySlot offhandSlot;
    final GlowInventorySlot cursorSlot;
    final List<GlowInventorySlot> craftingSlots;
    List<GlowInventorySlot> personalSlots;

    MainInventory(GlowHumanEntity targetPlayer, CreationOptions<PlayerInventorySlot> creationOptions) {
        super(null, InventoryType.CHEST, 54, creationOptions.getTitle().titleFor(Target.byPlayer((HumanEntity)targetPlayer)));
        GlowInventorySlot offHand;
        this.targetPlayerUuid = UUIDHelper.copy(targetPlayer.getUniqueId());
        this.targetPlayerName = targetPlayer.getName();
        this.creationOptions = creationOptions;
        this.setMaxStackSize(this.defaultMaxStack());
        GlowPlayerInventory targetInventory = targetPlayer.getInventory();
        List<GlowInventorySlot> targetSlots = GlowstoneHacks.getSlots((GlowInventory)targetInventory);
        this.containerSlots = targetSlots.subList(0, 36);
        this.armourSlots = Compat.listOf(new GlowInventorySlot[]{new BootsSlot(targetSlots.get(36)), new LeggingsSlot(targetSlots.get(37)), new ChestplateSlot(targetSlots.get(38)), new HelmetSlot(targetSlots.get(40))});
        try {
            EquipmentSlot.valueOf((String)"OFF_HAND");
            offHand = new OffhandSlot(targetSlots.get(40));
        }
        catch (IllegalArgumentException e) {
            offHand = InaccessibleSlot.INSTANCE;
        }
        this.offhandSlot = offHand;
        this.cursorSlot = new CursorSlot(targetPlayer);
        GlowCraftingInventory craftingInventory = targetInventory.getCraftingInventory();
        this.craftingSlots = GlowstoneHacks.getSlots((GlowInventory)craftingInventory).subList(1, craftingInventory.getSize()).stream().map(PersonalSlot::new).collect(Collectors.toList());
        this.personalSlots = this.craftingSlots;
        this.updateContents();
    }

    void updateContents() {
        ConcatList<GlowInventorySlot> list = new ConcatList<GlowInventorySlot>(this.containerSlots, this.armourSlots);
        list = new ConcatList<GlowInventorySlot>(list, Collections.singletonList(this.offhandSlot));
        list = new ConcatList<GlowInventorySlot>(list, Collections.singletonList(this.cursorSlot));
        list = new ConcatList<GlowInventorySlot>(list, Collections.nCopies(3, InaccessibleSlot.INSTANCE));
        list = new ConcatList<GlowInventorySlot>(list, this.personalSlots);
        if (this.personalSlots.size() < 9) {
            list = new ConcatList<GlowInventorySlot>(list, Collections.nCopies(9 - this.personalSlots.size(), InaccessibleSlot.INSTANCE));
        }
        GlowstoneHacks.setSlots(this, list);
    }

    @Override
    public ItemStack[] getStorageContents() {
        return (ItemStack[])this.containerSlots.stream().map(GlowInventorySlot::getItem).toArray(ItemStack[]::new);
    }

    @Override
    public void setStorageContents(ItemStack[] storageContents) {
        Objects.requireNonNull(storageContents, "storageContents cannot be null");
        int storageContentsSize = this.containerSlots.size();
        if (storageContentsSize != storageContents.length) {
            throw new IllegalArgumentException("storage contents must be of length " + storageContentsSize);
        }
        for (int i = 0; i < storageContentsSize; ++i) {
            this.containerSlots.get(i).setItem(storageContents[i]);
        }
        this.updateContents();
    }

    @Override
    public ItemStack[] getArmourContents() {
        return (ItemStack[])this.armourSlots.stream().map(GlowInventorySlot::getItem).toArray(ItemStack[]::new);
    }

    @Override
    public void setArmourContents(ItemStack[] armourContents) {
        Objects.requireNonNull(armourContents, "armourContents cannot be null");
        int armourContentsSize = this.armourSlots.size();
        if (armourContents.length != armourContentsSize) {
            throw new IllegalArgumentException("armour contents must be of length " + armourContentsSize);
        }
        for (int i = 0; i < armourContentsSize; ++i) {
            this.armourSlots.get(i).setItem(armourContents[i]);
        }
        this.updateContents();
    }

    @Override
    public ItemStack[] getOffHandContents() {
        if (this.offhandSlot == InaccessibleSlot.INSTANCE) {
            return new ItemStack[0];
        }
        return new ItemStack[]{this.offhandSlot.getItem()};
    }

    @Override
    public void setOffHandContents(ItemStack[] offHand) {
        if (offHand == null || offHand.length == 0) {
            return;
        }
        this.offhandSlot.setItem(offHand[0]);
        this.updateContents();
    }

    @Override
    public void setCursorContents(ItemStack cursor) {
        this.cursorSlot.setItem(cursor);
        this.updateContents();
    }

    @Override
    public ItemStack getCursorContents() {
        return this.cursorSlot.getItem();
    }

    @Override
    public void setPersonalContents(ItemStack[] craftingContents) {
        Objects.requireNonNull(craftingContents, "craftingContents cannot be null");
        if (craftingContents.length != this.personalSlots.size()) {
            throw new IllegalArgumentException("craftingContents must have size " + this.personalSlots.size());
        }
        for (int i = 0; i < craftingContents.length; ++i) {
            this.personalSlots.get(i).setItem(craftingContents[i]);
        }
        this.updateContents();
    }

    @Override
    public ItemStack[] getPersonalContents() {
        return (ItemStack[])this.personalSlots.stream().map(GlowInventorySlot::getItem).toArray(ItemStack[]::new);
    }

    @Override
    public int getPersonalContentsSize() {
        return this.personalSlots.size();
    }

    public ItemStack[] getContents() {
        int i;
        ItemStack[] result = new ItemStack[this.getSize()];
        System.arraycopy(this.getStorageContents(), 0, result, 0, 36);
        System.arraycopy(this.getArmourContents(), 0, result, 36, 4);
        result[40] = this.offhandSlot.getItem();
        result[41] = this.cursorSlot.getItem();
        for (i = 42; i < 45; ++i) {
            result[i] = InvseeImpl.EMPTY_STACK;
        }
        System.arraycopy(this.getPersonalContents(), 0, result, 45, this.getPersonalContentsSize());
        for (i = 53; i >= 45 + this.getPersonalContentsSize(); --i) {
            result[i] = InvseeImpl.EMPTY_STACK;
        }
        return result;
    }

    public void setContents(ItemStack[] items) {
        int i;
        for (i = 0; i < 36; ++i) {
            this.containerSlots.get(i).setItem(items[i]);
        }
        for (i = 0; i < 4; ++i) {
            this.armourSlots.get(i).setItem(items[36 + i]);
        }
        this.offhandSlot.setItem(items[40]);
        this.cursorSlot.setItem(items[41]);
        for (i = 0; i < 9; ++i) {
            this.personalSlots.get(i).setItem(items[46]);
        }
        this.updateContents();
    }

    public void clear() {
        this.containerSlots.forEach((? super T slot) -> slot.setItem(InvseeImpl.EMPTY_STACK));
        this.armourSlots.forEach((? super T slot) -> slot.setItem(InvseeImpl.EMPTY_STACK));
        this.offhandSlot.setItem(InvseeImpl.EMPTY_STACK);
        this.cursorSlot.setItem(InvseeImpl.EMPTY_STACK);
        this.craftingSlots.forEach((? super T slot) -> slot.setItem(InvseeImpl.EMPTY_STACK));
        this.personalSlots.forEach((? super T slot) -> slot.setItem(InvseeImpl.EMPTY_STACK));
    }

    @Override
    public String getSpectatedPlayerName() {
        return this.targetPlayerName;
    }

    @Override
    public UUID getSpectatedPlayerId() {
        return this.targetPlayerUuid;
    }

    @Override
    public CreationOptions<PlayerInventorySlot> getCreationOptions() {
        return this.creationOptions.clone();
    }

    @Override
    public int defaultMaxStack() {
        return 64;
    }

    @Override
    public void shallowCopyFrom(MainInventory from) {
        GlowstoneHacks.setSlots(this, GlowstoneHacks.getSlots(from));
    }

    public void forEach(Consumer<? super ItemStack> action) {
        for (GlowInventorySlot slot : this.getSlots()) {
            action.accept((ItemStack)slot.getItem());
        }
    }

    @Override
    public void watch(InventoryView targetPlayerView) {
        PlaceholderGroup placeholderGroup = null;
        Inventory top = targetPlayerView.getTopInventory();
        if (top instanceof GlowCraftingInventory) {
            List<GlowInventorySlot> craftingInventorySlots = GlowstoneHacks.getSlots((GlowInventory)((GlowCraftingInventory)top));
            this.personalSlots = craftingInventorySlots.subList(1, craftingInventorySlots.size()).stream().map(PersonalSlot::new).collect(Collectors.toList());
            placeholderGroup = PlaceholderGroup.CRAFTING;
        } else if (top instanceof GlowAnvilInventory) {
            List<GlowInventorySlot> anvilInventorySlots = GlowstoneHacks.getSlots((GlowInventory)((GlowAnvilInventory)top));
            this.personalSlots = anvilInventorySlots.subList(0, anvilInventorySlots.size() - 1).stream().map(PersonalSlot::new).collect(Collectors.toList());
            placeholderGroup = PlaceholderGroup.ANVIL;
        } else if (top instanceof GlowEnchantingInventory) {
            List<GlowInventorySlot> enchantingInventorySlots = GlowstoneHacks.getSlots((GlowInventory)((GlowEnchantingInventory)top));
            this.personalSlots = enchantingInventorySlots.stream().map(PersonalSlot::new).collect(Collectors.toList());
            placeholderGroup = PlaceholderGroup.ENCHANTING;
        } else if (top instanceof GlowMerchantInventory) {
            List<GlowInventorySlot> merchantInventorySlots = GlowstoneHacks.getSlots((GlowInventory)((GlowMerchantInventory)top));
            this.personalSlots = merchantInventorySlots.subList(0, merchantInventorySlots.size() - 1).stream().map(PersonalSlot::new).collect(Collectors.toList());
            placeholderGroup = PlaceholderGroup.MERCHANT;
        }
        this.updateContents();
        for (HumanEntity viewer : this.getViewers()) {
            GlowPlayer spectator;
            if (!(viewer instanceof GlowPlayer) || !((spectator = (GlowPlayer)viewer).getOpenInventory() instanceof MainInventoryView)) continue;
            MainInventoryView view = (MainInventoryView)spectator.getOpenInventory();
            CreationOptions creationOptions = view.getCreationOptions();
            Mirror<PlayerInventorySlot> mirror = creationOptions.getMirror();
            PlaceholderPalette palette = creationOptions.getPlaceholderPalette();
            for (int i = PlayerInventorySlot.PERSONAL_00.defaultIndex(); i <= PlayerInventorySlot.PERSONAL_08.defaultIndex(); ++i) {
                Integer rawIndex = mirror.getIndex(PlayerInventorySlot.byDefaultIndex(i));
                if (rawIndex != null) {
                    ItemStack stack = InvseeImpl.getItemOrPlaceholder(palette, view, rawIndex, placeholderGroup);
                    InvseeImpl.sendItemChange(spectator, rawIndex, stack);
                    continue;
                }
                InvseeImpl.sendItemChange(spectator, i, palette.inaccessible());
            }
        }
    }

    @Override
    public void unwatch() {
        this.personalSlots = this.craftingSlots;
        this.updateContents();
        for (HumanEntity viewer : this.getViewers()) {
            GlowPlayer spectator;
            if (!(viewer instanceof GlowPlayer) || !((spectator = (GlowPlayer)viewer).getOpenInventory() instanceof MainInventoryView)) continue;
            MainInventoryView view = (MainInventoryView)spectator.getOpenInventory();
            CreationOptions creationOptions = view.getCreationOptions();
            Mirror<PlayerInventorySlot> mirror = creationOptions.getMirror();
            PlaceholderPalette palette = creationOptions.getPlaceholderPalette();
            for (int i = PlayerInventorySlot.PERSONAL_00.defaultIndex(); i <= PlayerInventorySlot.PERSONAL_08.defaultIndex(); ++i) {
                Integer rawIndex = mirror.getIndex(PlayerInventorySlot.byDefaultIndex(i));
                if (rawIndex != null) {
                    ItemStack stack = InvseeImpl.getItemOrPlaceholder(palette, view, rawIndex, PlaceholderGroup.CRAFTING);
                    InvseeImpl.sendItemChange(spectator, rawIndex, stack);
                    continue;
                }
                InvseeImpl.sendItemChange(spectator, i, palette.inaccessible());
            }
        }
    }

    public boolean containsAtLeast(ItemStack stack, int amount) {
        if (amount <= 0) {
            return true;
        }
        if (stack == null) {
            return false;
        }
        int encountered = 0;
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (item == null || !item.isSimilar(stack) || (encountered += item.getAmount()) < amount) continue;
            return true;
        }
        return false;
    }
}

