/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.glowstone;

import com.flowpowered.network.ConnectionManager;
import com.flowpowered.network.Message;
import com.janboerman.invsee.glowstone.BootsSlot;
import com.janboerman.invsee.glowstone.ChestplateSlot;
import com.janboerman.invsee.glowstone.CursorSlot;
import com.janboerman.invsee.glowstone.EnderInventory;
import com.janboerman.invsee.glowstone.EnderInventoryView;
import com.janboerman.invsee.glowstone.FakeChannel;
import com.janboerman.invsee.glowstone.FakePlayer;
import com.janboerman.invsee.glowstone.GlowstoneHacks;
import com.janboerman.invsee.glowstone.HelmetSlot;
import com.janboerman.invsee.glowstone.InaccessibleSlot;
import com.janboerman.invsee.glowstone.LeggingsSlot;
import com.janboerman.invsee.glowstone.MainInventory;
import com.janboerman.invsee.glowstone.MainInventoryView;
import com.janboerman.invsee.glowstone.NameSearchSaveFilesStrategy;
import com.janboerman.invsee.glowstone.OffhandSlot;
import com.janboerman.invsee.glowstone.PersonalSlot;
import com.janboerman.invsee.glowstone.Placeholders;
import com.janboerman.invsee.glowstone.UUIDSearchSaveFilesStrategy;
import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventory;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import com.janboerman.invsee.spigot.api.MainSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.SpectatorInventory;
import com.janboerman.invsee.spigot.api.event.SpectatorInventorySaveEvent;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderGroup;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderPalette;
import com.janboerman.invsee.spigot.api.response.NotCreatedReason;
import com.janboerman.invsee.spigot.api.response.NotOpenedReason;
import com.janboerman.invsee.spigot.api.response.OpenResponse;
import com.janboerman.invsee.spigot.api.response.SaveResponse;
import com.janboerman.invsee.spigot.api.response.SpectateResponse;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.internal.EventHelper;
import com.janboerman.invsee.spigot.internal.InvseePlatform;
import com.janboerman.invsee.spigot.internal.NamesAndUUIDs;
import com.janboerman.invsee.spigot.internal.OpenSpectatorsCache;
import com.janboerman.invsee.utils.Rethrow;
import io.netty.channel.Channel;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.glowstone.GlowServer;
import net.glowstone.entity.GlowEntity;
import net.glowstone.entity.GlowHumanEntity;
import net.glowstone.entity.GlowPlayer;
import net.glowstone.entity.meta.profile.GlowPlayerProfile;
import net.glowstone.inventory.GlowInventorySlot;
import net.glowstone.io.PlayerDataService;
import net.glowstone.io.entity.EntityStore;
import net.glowstone.io.nbt.NbtPlayerDataService;
import net.glowstone.net.GameServer;
import net.glowstone.net.GlowSession;
import net.glowstone.net.message.play.inv.SetWindowSlotMessage;
import net.glowstone.util.InventoryUtil;
import net.glowstone.util.nbt.CompoundTag;
import org.bukkit.Server;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InvseeImpl
implements InvseePlatform {
    static final ItemStack EMPTY_STACK = InventoryUtil.EMPTY_STACK;
    private final Plugin plugin;
    private final OpenSpectatorsCache cache;
    private final Scheduler scheduler;

    public InvseeImpl(Plugin plugin, NamesAndUUIDs lookup, Scheduler scheduler, OpenSpectatorsCache cache) {
        final GlowServer server = (GlowServer)plugin.getServer();
        this.plugin = plugin;
        this.cache = cache;
        this.scheduler = scheduler;
        if (lookup.onlineMode(plugin.getServer())) {
            lookup.uuidResolveStrategies.add(new UUIDSearchSaveFilesStrategy(plugin, scheduler));
        } else {
            lookup.uuidResolveStrategies.add(lookup.uuidResolveStrategies.size() - 1, new UUIDSearchSaveFilesStrategy(plugin, scheduler));
        }
        lookup.nameResolveStrategies.add(new NameSearchSaveFilesStrategy(plugin, scheduler));
        server.getPluginManager().registerEvent(InventoryCloseEvent.class, new Listener(){}, EventPriority.MONITOR, (listener, ev) -> {
            InventoryCloseEvent event = (InventoryCloseEvent)ev;
            InventoryView view = event.getView();
            if (view instanceof MainInventoryView) {
                ((MainInventoryView)view).onClose();
            } else if (view instanceof EnderInventoryView) {
                ((EnderInventoryView)view).onClose();
            }
        }, plugin);
        server.getPluginManager().registerEvent(InventoryOpenEvent.class, new Listener(){}, EventPriority.MONITOR, (listener, ev) -> {
            InventoryOpenEvent event = (InventoryOpenEvent)ev;
            InventoryView view = event.getView();
            if (view instanceof MainInventoryView) {
                ((MainInventoryView)view).openEvent = event;
            } else if (view instanceof EnderInventoryView) {
                ((EnderInventoryView)view).openEvent = event;
            }
        }, plugin);
        new BukkitRunnable(this){
            final /* synthetic */ InvseeImpl this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (server.getNetworkServer() != null) {
                    GlowstoneHacks.injectWindowClickHandler(server);
                    this.cancel();
                }
            }
        }.runTaskTimer(plugin, 0L, 1L);
    }

    @Override
    public MainSpectatorInventory spectateInventory(HumanEntity target, CreationOptions<PlayerInventorySlot> options) {
        MainInventory spectatorInv = new MainInventory((GlowHumanEntity)target, options);
        InventoryView targetView = target.getOpenInventory();
        spectatorInv.watch(targetView);
        this.cache.cache(spectatorInv);
        return spectatorInv;
    }

    @Override
    public CompletableFuture<SpectateResponse<MainSpectatorInventory>> createOfflineInventory(UUID playerId, String playerName, CreationOptions<PlayerInventorySlot> options) {
        return this.createOffline(playerId, playerName, options, this::spectateInventory);
    }

    @Override
    public CompletableFuture<SaveResponse> saveInventory(MainSpectatorInventory newInventory) {
        return this.save(newInventory, this::spectateInventory, MainSpectatorInventory::setContents);
    }

    @Override
    public OpenResponse<MainSpectatorInventoryView> openMainSpectatorInventory(Player spectator, MainSpectatorInventory inv, CreationOptions<PlayerInventorySlot> options) {
        MainInventory glowInventory = (MainInventory)inv;
        MainInventoryView view = new MainInventoryView((HumanEntity)spectator, glowInventory, options);
        spectator.openInventory((InventoryView)view);
        if (view.openEvent != null && view.openEvent.isCancelled()) {
            return OpenResponse.closed(NotOpenedReason.inventoryOpenEventCancelled(view.openEvent));
        }
        GlowPlayer glowPlayer = (GlowPlayer)spectator;
        Mirror<PlayerInventorySlot> mirror = options.getMirror();
        PlaceholderPalette palette = options.getPlaceholderPalette();
        ItemStack inaccessible = palette.inaccessible();
        for (int inventoryIndex = PlayerInventorySlot.CONTAINER_35.defaultIndex() + 1; inventoryIndex < inv.getSize(); ++inventoryIndex) {
            Integer idx = mirror.getIndex(PlayerInventorySlot.byDefaultIndex(inventoryIndex));
            if (idx == null) {
                InvseeImpl.sendItemChange(glowPlayer, inventoryIndex, inaccessible);
                continue;
            }
            int rawIndex = idx;
            GlowInventorySlot slot = glowInventory.getSlot(inventoryIndex);
            if (!InventoryUtil.isEmpty((ItemStack)slot.getItem())) continue;
            if (slot instanceof InaccessibleSlot) {
                InvseeImpl.sendItemChange(glowPlayer, rawIndex, inaccessible);
                continue;
            }
            if (slot instanceof BootsSlot) {
                InvseeImpl.sendItemChange(glowPlayer, rawIndex, palette.armourBoots());
                continue;
            }
            if (slot instanceof LeggingsSlot) {
                InvseeImpl.sendItemChange(glowPlayer, rawIndex, palette.armourLeggings());
                continue;
            }
            if (slot instanceof ChestplateSlot) {
                InvseeImpl.sendItemChange(glowPlayer, rawIndex, palette.armourChestplate());
                continue;
            }
            if (slot instanceof HelmetSlot) {
                InvseeImpl.sendItemChange(glowPlayer, rawIndex, palette.armourHelmet());
                continue;
            }
            if (slot instanceof OffhandSlot) {
                InvseeImpl.sendItemChange(glowPlayer, rawIndex, palette.offHand());
                continue;
            }
            if (slot instanceof CursorSlot) {
                InvseeImpl.sendItemChange(glowPlayer, rawIndex, palette.cursor());
                continue;
            }
            if (!(slot instanceof PersonalSlot)) continue;
            InvseeImpl.sendItemChange(glowPlayer, rawIndex, palette.generic());
        }
        return OpenResponse.open(view);
    }

    @Override
    public EnderSpectatorInventory spectateEnderChest(HumanEntity target, CreationOptions<EnderChestSlot> options) {
        EnderInventory spectatorInv = new EnderInventory((GlowHumanEntity)target, options);
        this.cache.cache(spectatorInv);
        return spectatorInv;
    }

    @Override
    public CompletableFuture<SpectateResponse<EnderSpectatorInventory>> createOfflineEnderChest(UUID playerId, String playerName, CreationOptions<EnderChestSlot> options) {
        return this.createOffline(playerId, playerName, options, this::spectateEnderChest);
    }

    @Override
    public CompletableFuture<SaveResponse> saveEnderChest(EnderSpectatorInventory newInventory) {
        return this.save(newInventory, this::spectateEnderChest, EnderSpectatorInventory::setContents);
    }

    @Override
    public OpenResponse<EnderSpectatorInventoryView> openEnderSpectatorInventory(Player spectator, EnderSpectatorInventory inv, CreationOptions<EnderChestSlot> options) {
        EnderInventory glowInventory = (EnderInventory)inv;
        EnderInventoryView view = new EnderInventoryView((HumanEntity)spectator, glowInventory, options);
        spectator.openInventory((InventoryView)view);
        if (view.openEvent != null && view.openEvent.isCancelled()) {
            return OpenResponse.closed(NotOpenedReason.inventoryOpenEventCancelled(view.openEvent));
        }
        return OpenResponse.open(view);
    }

    private <Slot, IS extends SpectatorInventory<Slot>> CompletableFuture<SpectateResponse<IS>> createOffline(UUID playerId, String playerName, CreationOptions<Slot> options, BiFunction<? super HumanEntity, ? super CreationOptions<Slot>, IS> invCreator) {
        GlowServer server = (GlowServer)this.plugin.getServer();
        NbtPlayerDataService playerDataService = (NbtPlayerDataService)server.getPlayerDataService();
        GameServer gameServer = server.getNetworkServer();
        Channel channel = FakeChannel.INSTANCE;
        GlowSession session = new GlowSession(server, gameServer.getProtocolProvider(), channel, (ConnectionManager)gameServer);
        GlowPlayerProfile profile = new GlowPlayerProfile(playerName, playerId, true);
        PlayerDataService.PlayerReader reader = playerDataService.beginReadingData(playerId);
        FakePlayer fakePlayer = new FakePlayer(session, profile, reader);
        GlowstoneHacks.setPlayer(session, fakePlayer);
        return CompletableFuture.supplyAsync(() -> {
            boolean playerFileExists;
            File playerDataFolder = GlowstoneHacks.getPlayerDir(playerDataService);
            File playerFile = new File(playerDataFolder, playerId.toString() + ".dat");
            boolean bl = playerFileExists = playerFile.exists() && playerFile.isFile();
            if (!playerFileExists && !options.isUnknownPlayerSupported()) {
                return SpectateResponse.fail(NotCreatedReason.unknownTarget(Target.byGameProfile(playerId, playerName)));
            }
            try {
                CompoundTag tag = playerFileExists ? GlowstoneHacks.readCompressed(playerFile) : new CompoundTag();
                EntityStore<? extends GlowEntity> glowhumanentityStore = GlowstoneHacks.findEntityStore(GlowPlayer.class, "load");
                glowhumanentityStore.load((GlowEntity)fakePlayer, tag);
                return SpectateResponse.succeed(EventHelper.callSpectatorInventoryOfflineCreatedEvent((Server)server, (SpectatorInventory)invCreator.apply((HumanEntity)fakePlayer, (Object)options)));
            }
            catch (IOException e) {
                return (SpectateResponse)Rethrow.unchecked(e);
            }
        }, runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null));
    }

    private <Slot, SI extends SpectatorInventory<Slot>> CompletableFuture<SaveResponse> save(SI newInventory, BiFunction<? super HumanEntity, ? super CreationOptions<Slot>, SI> currentInvProvider, BiConsumer<SI, SI> transfer) {
        GlowServer server = (GlowServer)this.plugin.getServer();
        SpectatorInventorySaveEvent event = EventHelper.callSpectatorInventorySaveEvent((Server)server, newInventory);
        if (event.isCancelled()) {
            return CompletableFuture.completedFuture(SaveResponse.notSaved(newInventory));
        }
        NbtPlayerDataService playerDataService = (NbtPlayerDataService)server.getPlayerDataService();
        UUID playerId = newInventory.getSpectatedPlayerId();
        String playerName = newInventory.getName();
        GameServer gameServer = server.getNetworkServer();
        Channel channel = FakeChannel.INSTANCE;
        GlowSession session = new GlowSession(server, gameServer.getProtocolProvider(), channel, (ConnectionManager)gameServer);
        GlowPlayerProfile profile = new GlowPlayerProfile(playerName, playerId, true);
        PlayerDataService.PlayerReader reader = playerDataService.beginReadingData(playerId);
        FakePlayer fakePlayer = new FakePlayer(session, profile, reader);
        GlowstoneHacks.setPlayer(session, fakePlayer);
        return CompletableFuture.supplyAsync(() -> {
            File playerDataFolder = GlowstoneHacks.getPlayerDir(playerDataService);
            File playerFile = new File(playerDataFolder, playerId.toString() + ".dat");
            boolean playerFileExists = playerFile.exists() && playerFile.isFile();
            try {
                CompoundTag tag = playerFileExists ? GlowstoneHacks.readCompressed(playerFile) : new CompoundTag();
                EntityStore<? extends GlowEntity> glowplayerStore = GlowstoneHacks.findEntityStore(GlowPlayer.class, "load");
                glowplayerStore.load((GlowEntity)fakePlayer, tag);
                SpectatorInventory currentInventory = (SpectatorInventory)currentInvProvider.apply((HumanEntity)fakePlayer, (Object)newInventory.getCreationOptions());
                transfer.accept(currentInventory, newInventory);
                glowplayerStore = GlowstoneHacks.findEntityStore(GlowPlayer.class, "save");
                glowplayerStore.save((GlowEntity)fakePlayer, tag);
                GlowstoneHacks.writeCompressed(playerFile, tag);
                return SaveResponse.saved(currentInventory);
            }
            catch (IOException e) {
                return (SaveResponse)Rethrow.unchecked(e);
            }
        }, runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null));
    }

    @Override
    public PlaceholderPalette getPlaceholderPalette(String name) {
        switch (name) {
            case "glass panes": {
                return Placeholders.PALETTE_GLASS;
            }
            case "icons": {
                return Placeholders.PALETTE_ICONS;
            }
        }
        return PlaceholderPalette.empty();
    }

    static void sendItemChange(GlowPlayer player, int rawIndex, ItemStack toSend) {
        player.getSession().send((Message)new SetWindowSlotMessage(player.getOpenWindowId(), rawIndex, toSend));
    }

    static ItemStack getItemOrPlaceholder(PlaceholderPalette palette, MainInventoryView view, int rawIndex, PlaceholderGroup group) {
        MainInventory top = view.getTopInventory();
        GlowInventorySlot slot = top.getSlot(rawIndex);
        if (!InventoryUtil.isEmpty((ItemStack)slot.getItem())) {
            return slot.getItem();
        }
        if (slot instanceof InaccessibleSlot) {
            return palette.inaccessible();
        }
        if (slot instanceof BootsSlot) {
            return palette.armourBoots();
        }
        if (slot instanceof LeggingsSlot) {
            return palette.armourLeggings();
        }
        if (slot instanceof ChestplateSlot) {
            return palette.armourChestplate();
        }
        if (slot instanceof OffhandSlot) {
            return palette.offHand();
        }
        if (slot instanceof OffhandSlot) {
            return palette.offHand();
        }
        if (slot instanceof PersonalSlot) {
            if (group == null) {
                return EMPTY_STACK;
            }
            Mirror mirror = view.getMirror();
            PlayerInventorySlot pis = (PlayerInventorySlot)((Object)mirror.getSlot(rawIndex));
            if (pis == null) {
                return palette.inaccessible();
            }
            return palette.getPersonalSlotPlaceholder(pis, group);
        }
        return EMPTY_STACK;
    }
}

