/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.glowstone;

import com.flowpowered.network.MessageHandler;
import com.flowpowered.network.service.HandlerLookupService;
import com.janboerman.invsee.glowstone.DecoratedWindowClickHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.glowstone.GlowServer;
import net.glowstone.entity.GlowEntity;
import net.glowstone.entity.GlowPlayer;
import net.glowstone.inventory.GlowInventory;
import net.glowstone.inventory.GlowInventorySlot;
import net.glowstone.io.entity.EntityStorage;
import net.glowstone.io.entity.EntityStore;
import net.glowstone.io.nbt.NbtPlayerDataService;
import net.glowstone.net.GlowSession;
import net.glowstone.net.message.play.inv.WindowClickMessage;
import net.glowstone.net.protocol.GlowProtocol;
import net.glowstone.net.protocol.PlayProtocol;
import net.glowstone.util.nbt.CompoundTag;
import net.glowstone.util.nbt.NbtInputStream;
import net.glowstone.util.nbt.NbtOutputStream;
import net.glowstone.util.nbt.Tag;

final class GlowstoneHacks {
    private GlowstoneHacks() {
    }

    static List<GlowInventorySlot> getSlots(GlowInventory inventory) {
        try {
            Field field = GlowInventory.class.getDeclaredField("slots");
            field.setAccessible(true);
            Object slots = field.get(inventory);
            return (List)slots;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to get GlowInventory slots reflectively.", e);
        }
    }

    static void setSlots(GlowInventory inventory, List<GlowInventorySlot> slots) {
        try {
            Field field = GlowInventory.class.getDeclaredField("slots");
            field.setAccessible(true);
            field.set(inventory, slots);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to set GlowInventory slots reflectively.", e);
        }
    }

    static void injectWindowClickHandler(GlowServer server) {
        HandlerLookupService playHandlers = GlowstoneHacks.getHandlers((GlowProtocol)GlowstoneHacks.getPlayProtocol(server));
        MessageHandler oldHandler = playHandlers.find(WindowClickMessage.class);
        if (oldHandler != null && !(oldHandler instanceof DecoratedWindowClickHandler)) {
            DecoratedWindowClickHandler newHandler = new DecoratedWindowClickHandler((MessageHandler<GlowSession, WindowClickMessage>)oldHandler);
            try {
                playHandlers.bind(WindowClickMessage.class, (MessageHandler)newHandler);
            }
            catch (IllegalAccessException | InstantiationException neverThrown) {
                throw new RuntimeException("Impossible", neverThrown);
            }
        }
    }

    private static PlayProtocol getPlayProtocol(GlowServer server) {
        return server.getNetworkServer().getProtocolProvider().getPlay();
    }

    private static HandlerLookupService getHandlers(GlowProtocol protocol) {
        try {
            Field field = GlowProtocol.class.getDeclaredField("handlers");
            field.setAccessible(true);
            return (HandlerLookupService)field.get(protocol);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to get GlowProtocol handlers reflectively.", e);
        }
    }

    static File getPlayerDir(NbtPlayerDataService playerDataService) {
        try {
            Field field = NbtPlayerDataService.class.getDeclaredField("playerDir");
            field.setAccessible(true);
            return (File)field.get(playerDataService);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to get player data folder reflectively.", e);
        }
    }

    static CompoundTag readCompressed(File playerFile) throws IOException {
        try (NbtInputStream in = new NbtInputStream((InputStream)new FileInputStream(playerFile));){
            CompoundTag compoundTag = in.readCompound();
            return compoundTag;
        }
    }

    static void writeCompressed(File playerFile, CompoundTag tag) throws IOException {
        try (NbtOutputStream out = new NbtOutputStream((OutputStream)new FileOutputStream(playerFile));){
            out.writeTag((Tag)tag);
        }
    }

    static EntityStore<? extends GlowEntity> findEntityStore(Class<? extends GlowEntity> clazz, String type) {
        try {
            Method method = EntityStorage.class.getDeclaredMethod("find", Class.class, String.class);
            method.setAccessible(true);
            return (EntityStore)method.invoke(null, clazz, type);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to find GlowPlayer entity store reflectively.", e);
        }
    }

    static void setPlayer(GlowSession session, GlowPlayer player) {
        try {
            Field field = GlowSession.class.getDeclaredField("player");
            field.setAccessible(true);
            field.set(session, player);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to set GlowSession's player profile.", e);
        }
    }
}

