/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.folia;

import com.janboerman.invsee.spigot.InvseePlusPlus;
import com.janboerman.invsee.spigot.api.Scheduler;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Server;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FoliaScheduler
implements Scheduler {
    private InvseePlusPlus plugin;

    public FoliaScheduler(InvseePlusPlus plugin) {
        this.plugin = plugin;
    }

    @Override
    public void executeSyncPlayer(UUID playerId, Runnable task, Runnable retired) {
        Server server = this.plugin.getServer();
        Player player = server.getPlayer(playerId);
        if (player != null) {
            EntityScheduler scheduler = player.getScheduler();
            scheduler.run((Plugin)this.plugin, scheduledTask -> task.run(), retired);
        } else {
            this.executeSyncGlobal(task);
        }
    }

    public void executeSyncPlayer(HumanEntity player, Runnable task, Runnable retired) {
        player.getScheduler().run((Plugin)this.plugin, scheduledTask -> task.run(), retired);
    }

    @Override
    public void executeSyncGlobal(Runnable task) {
        this.plugin.getServer().getGlobalRegionScheduler().execute((Plugin)this.plugin, task);
    }

    @Override
    public void executeSyncGlobalRepeatedly(Runnable task, long ticksInitialDelay, long ticksPeriod) {
        this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> task.run(), ticksInitialDelay, ticksPeriod);
    }

    @Override
    public void executeAsync(Runnable task) {
        this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, scheduledTask -> task.run());
    }

    @Override
    public void executeLaterGlobal(Runnable task, long delayTicks) {
        this.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> task.run(), delayTicks);
    }

    @Override
    public void executeLaterAsync(Runnable task, long delayTicks) {
        this.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> task.run(), delayTicks * 50L, TimeUnit.MILLISECONDS);
    }
}

