/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.feature.distributor.distributors;

import com.dfsek.terra.addons.feature.distributor.lib.jafama.FastMath;
import com.dfsek.terra.api.structure.feature.Distributor;
import com.dfsek.terra.api.util.MathUtil;
import java.util.Random;

public class PaddedGridDistributor
implements Distributor {
    private final int width;
    private final int cellWidth;
    private final int salt;

    public PaddedGridDistributor(int width, int padding, int salt) {
        this.width = width;
        this.salt = salt;
        this.cellWidth = width + padding;
    }

    private static long murmur64(long h) {
        h ^= h >>> 33;
        h *= -49064778989728563L;
        h ^= h >>> 33;
        h *= -4265267296055464877L;
        h ^= h >>> 33;
        return h;
    }

    public boolean matches(int x, int z, long seed) {
        int cellX = FastMath.floorDiv(x, this.cellWidth);
        int cellZ = FastMath.floorDiv(z, this.cellWidth);
        Random random = new Random((PaddedGridDistributor.murmur64(MathUtil.squash((int)cellX, (int)cellZ)) ^ seed) + (long)this.salt);
        int pointX = random.nextInt(this.width) + cellX * this.cellWidth;
        int pointZ = random.nextInt(this.width) + cellZ * this.cellWidth;
        return x == pointX && z == pointZ;
    }
}

