/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.util;

import dev.aurelium.auraskills.kyori.adventure.text.Component;
import dev.aurelium.auraskills.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import dev.aurelium.auraskills.slate.text.TextFormatter;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.inventory.meta.ItemMeta;

public class PaperUtil {
    public static final boolean IS_PAPER = PaperUtil.init();

    private static boolean init() {
        return PaperUtil.hasClass("com.destroystokyo.paper.PaperConfig") || PaperUtil.hasClass("io.papermc.paper.configuration.Configuration");
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void setDisplayName(ItemMeta meta, Component component) {
        if (IS_PAPER) {
            meta.setDisplayNameComponent(BungeeComponentSerializer.get().serialize(component));
        } else {
            meta.setDisplayName(new TextFormatter().toString(component));
        }
    }

    public static void setLore(ItemMeta meta, List<Component> components) {
        if (IS_PAPER) {
            ArrayList<BaseComponent[]> bungee = new ArrayList<BaseComponent[]>();
            BungeeComponentSerializer serializer = BungeeComponentSerializer.get();
            for (Component component : components) {
                bungee.add(serializer.serialize(component));
            }
            meta.setLoreComponents(bungee);
        } else {
            ArrayList<String> text = new ArrayList<String>();
            TextFormatter tf = new TextFormatter();
            for (Component component : components) {
                text.add(tf.toString(component));
            }
            meta.setLore(text);
        }
    }
}

