/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.position;

import dev.aurelium.auraskills.slate.context.ContextGroup;
import dev.aurelium.auraskills.slate.context.GroupAlign;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.position.GroupUtil;
import dev.aurelium.auraskills.slate.position.PositionProvider;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public record GroupPosition(ContextGroup group, int order) implements PositionProvider
{
    @Override
    public List<SlotPos> getPosition(Collection<PositionProvider> positionData) {
        SlotPos slotPos;
        List<SlotPos> slots;
        List<GroupPosition> providers = positionData.stream().filter(p -> p instanceof GroupPosition).map(p -> (GroupPosition)p).filter(p -> p.group().equals(this.group)).sorted(Comparator.comparingInt(GroupPosition::order)).toList();
        int size = providers.size();
        int startRow = this.group.getStart().getRow();
        int startCol = this.group.getStart().getColumn();
        int endRow = this.group.getEnd().getRow();
        int endCol = this.group.getEnd().getColumn();
        int index = providers.size();
        for (int i = 0; i < providers.size(); ++i) {
            if (providers.get(i).order() != this.order) continue;
            index = i;
        }
        GroupUtil groupUtil = new GroupUtil(size, startRow, startCol, endRow, endCol);
        if (this.group.getAlign() == GroupAlign.CENTER) {
            SlotPos slotPos2;
            List<SlotPos> slots2 = groupUtil.getCenterSlots();
            if (index < slots2.size() && (slotPos2 = slots2.get(index)) != null) {
                return List.of(slotPos2);
            }
        } else if (this.group.getAlign() == GroupAlign.LEFT) {
            SlotPos slotPos3;
            List<SlotPos> slots3 = groupUtil.getLeftSlots();
            if (index < slots3.size() && (slotPos3 = slots3.get(index)) != null) {
                return List.of(slotPos3);
            }
        } else if (this.group.getAlign() == GroupAlign.RIGHT && index < (slots = groupUtil.getRightSlots()).size() && (slotPos = slots.get(index)) != null) {
            return List.of(slotPos);
        }
        return List.of(SlotPos.of(startRow, startCol));
    }
}

