/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.menu;

import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.component.MenuComponent;
import dev.aurelium.auraskills.slate.context.ContextGroup;
import dev.aurelium.auraskills.slate.item.MenuItem;
import dev.aurelium.auraskills.slate.item.TemplateItem;
import dev.aurelium.auraskills.slate.item.active.ActiveItem;
import dev.aurelium.auraskills.slate.menu.EmptyActiveMenu;
import dev.aurelium.auraskills.slate.menu.MenuInventory;
import dev.aurelium.auraskills.slate.position.PositionProvider;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActiveMenu {
    private final MenuInventory menuInventory;

    public ActiveMenu(MenuInventory menuInventory) {
        this.menuInventory = menuInventory;
    }

    public static ActiveMenu empty(Slate slate, Player player) {
        return new EmptyActiveMenu(slate, player);
    }

    public String getName() {
        return this.menuInventory.getMenu().name();
    }

    public void setHidden(String itemName, boolean hidden) {
        ActiveItem activeItem = this.menuInventory.getActiveItem(itemName);
        if (activeItem != null) {
            activeItem.setHidden(hidden);
        }
    }

    public int getCurrentPage() {
        return this.menuInventory.getCurrentPage();
    }

    public int getTotalPages() {
        return this.menuInventory.getTotalPages();
    }

    public <T> T property(String name) {
        try {
            return (T)this.menuInventory.getProperties().get(name);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T property(String name, T def) {
        try {
            return (T)this.menuInventory.getProperties().getOrDefault(name, def);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return def;
        }
    }

    public Object getProperty(String name) {
        return this.menuInventory.getProperties().get(name);
    }

    public Object getProperty(String name, Object def) {
        Object value = this.menuInventory.getProperties().get(name);
        if (value != null) {
            return value;
        }
        return def;
    }

    public Map<String, Object> getProperties() {
        return this.menuInventory.getProperties();
    }

    public void setProperty(String name, Object value) {
        this.menuInventory.getProperties().put(name, value);
    }

    public void defaultProperty(String name, Object value) {
        if (!this.menuInventory.getProperties().containsKey(name)) {
            this.menuInventory.getProperties().put(name, value);
        }
    }

    public void reload() {
        this.menuInventory.init(this.menuInventory.getPlayer(), this.menuInventory.getContents());
    }

    public void setCooldown(String itemName, int cooldown) {
        ActiveItem activeItem = this.menuInventory.getActiveItem(itemName);
        if (activeItem != null) {
            activeItem.setCooldown(cooldown);
            this.menuInventory.setToUpdate(activeItem);
        }
    }

    @Nullable
    public Object getOption(String key) {
        return this.menuInventory.getMenu().options().get(key);
    }

    @Nullable
    public <T> T getOption(Class<T> clazz, String key) {
        try {
            return clazz.cast(this.menuInventory.getMenu().options().get(key));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Object getOption(String key, Object def) {
        Object obj = this.menuInventory.getMenu().options().get(key);
        if (obj != null) {
            return obj;
        }
        return def;
    }

    public <T> T getOption(Class<T> clazz, String key, T def) {
        try {
            T result = clazz.cast(this.menuInventory.getMenu().options().get(key));
            if (result != null) {
                return result;
            }
            return def;
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    @Nullable
    public Object getItemOption(String itemName, String key) {
        MenuItem menuItem = this.menuInventory.getMenu().items().get(itemName);
        if (menuItem != null) {
            return menuItem.getOptions().get(key);
        }
        return null;
    }

    public Object getItemOption(String itemName, String key, Object def) {
        Object obj;
        MenuItem menuItem = this.menuInventory.getMenu().items().get(itemName);
        if (menuItem != null && (obj = menuItem.getOptions().get(key)) != null) {
            return obj;
        }
        return def;
    }

    public Map<String, MenuComponent> getComponents() {
        return this.menuInventory.getMenu().components();
    }

    public Map<String, String> getFormats() {
        return this.menuInventory.getMenu().formats();
    }

    @NotNull
    public String getFormat(String key) {
        return this.menuInventory.getMenu().formats().getOrDefault(key, key);
    }

    public <T> void setPositionProvider(String templateName, T context, PositionProvider provider) {
        MenuItem menuItem = this.menuInventory.getMenu().items().get(templateName);
        if (menuItem instanceof TemplateItem) {
            TemplateItem templateItem = (TemplateItem)menuItem;
            templateItem.getPositionsMap().put(context, provider);
        }
    }

    public Map<String, ContextGroup> getContextGroups(String templateName) {
        MenuItem menuItem = this.menuInventory.getMenu().items().get(templateName);
        if (menuItem instanceof TemplateItem) {
            TemplateItem templateItem = (TemplateItem)menuItem;
            return templateItem.getContextGroups();
        }
        return new HashMap<String, ContextGroup>();
    }
}

