/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.lore;

import dev.aurelium.auraskills.kyori.adventure.text.Component;
import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.builder.BuiltComponent;
import dev.aurelium.auraskills.slate.builder.BuiltItem;
import dev.aurelium.auraskills.slate.builder.BuiltTemplate;
import dev.aurelium.auraskills.slate.component.ComponentData;
import dev.aurelium.auraskills.slate.component.MenuComponent;
import dev.aurelium.auraskills.slate.info.ComponentInfo;
import dev.aurelium.auraskills.slate.item.MenuItem;
import dev.aurelium.auraskills.slate.item.TemplateItem;
import dev.aurelium.auraskills.slate.item.provider.PlaceholderType;
import dev.aurelium.auraskills.slate.lore.ListData;
import dev.aurelium.auraskills.slate.lore.LoreLine;
import dev.aurelium.auraskills.slate.lore.type.ComponentLore;
import dev.aurelium.auraskills.slate.lore.type.TextLore;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import dev.aurelium.auraskills.slate.text.TextFormatter;
import dev.aurelium.auraskills.slate.util.LoreUtil;
import dev.aurelium.auraskills.slate.util.Pair;
import dev.aurelium.auraskills.slate.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LoreInterpreter {
    private final Slate slate;
    private final TextFormatter tf = new TextFormatter();

    public LoreInterpreter(Slate slate) {
        this.slate = slate;
    }

    @NotNull
    public List<Component> interpretLore(List<LoreLine> loreLines, Player player, ActiveMenu activeMenu, BuiltItem builtItem, MenuItem menuItem) {
        List<String> lore = new ArrayList<String>();
        for (LoreLine line : loreLines) {
            ComponentLore componentLore;
            List<String> list;
            if (line instanceof TextLore) {
                TextLore textLore = (TextLore)line;
                lore.add(this.interpretTextLore(textLore, player, activeMenu, builtItem));
                continue;
            }
            if (!(line instanceof ComponentLore) || (list = this.interpretComponent(componentLore = (ComponentLore)line, player, activeMenu, menuItem)) == null) continue;
            lore.addAll(list);
        }
        lore = this.tf.applyNewLines(lore);
        return this.tf.toComponentLore(lore);
    }

    @NotNull
    public <T> List<Component> interpretLore(List<LoreLine> loreLines, Player player, ActiveMenu activeMenu, BuiltTemplate<T> builtTemplate, TemplateItem<T> templateItem, T context) {
        List<String> lore = new ArrayList<String>();
        for (LoreLine line : loreLines) {
            ComponentLore componentLore;
            List<String> list;
            if (line instanceof TextLore) {
                TextLore textLore = (TextLore)line;
                lore.add(this.interpretTextLore(textLore, player, activeMenu, builtTemplate, context));
                continue;
            }
            if (!(line instanceof ComponentLore) || (list = this.interpretComponent(componentLore = (ComponentLore)line, player, activeMenu, templateItem, context)) == null) continue;
            lore.addAll(list);
        }
        lore = this.tf.applyNewLines(lore);
        return this.tf.toComponentLore(lore);
    }

    private String interpretTextLore(TextLore textLore, Player player, ActiveMenu activeMenu, BuiltItem builtItem) {
        String text = textLore.getText();
        text = builtItem.applyReplacers(text, this.slate, player, activeMenu, PlaceholderType.LORE);
        return this.replaceAndWrap(textLore, player, text);
    }

    private <T> String interpretTextLore(TextLore textLore, Player player, ActiveMenu activeMenu, BuiltTemplate<T> builtTemplate, T context) {
        String text = textLore.getText();
        text = builtTemplate.applyReplacers(text, this.slate, player, activeMenu, PlaceholderType.LORE, context);
        return this.replaceAndWrap(textLore, player, text);
    }

    private <T> String interpretTextLore(TextLore textLore, Player player, ActiveMenu activeMenu, ComponentData componentData, @NotNull BuiltComponent<T> builtComponent, T context) {
        String text = textLore.getText();
        text = builtComponent.applyReplacers(text, this.slate, player, activeMenu, componentData, context);
        return this.replaceAndWrap(textLore, player, text);
    }

    public static Pair<String, ListData> detectListPlaceholder(String placeholder) {
        if (!placeholder.endsWith("]") && !placeholder.endsWith(")")) {
            return new Pair<String, ListData>(placeholder, new ListData(null, 0));
        }
        int openBracket = placeholder.lastIndexOf("[");
        int closeBracket = placeholder.lastIndexOf("]");
        if (openBracket == -1 || closeBracket == -1 || openBracket > closeBracket) {
            return new Pair<String, ListData>(placeholder, new ListData(null, 0));
        }
        String insert = placeholder.substring(openBracket + 1, closeBracket);
        int openParen = placeholder.lastIndexOf("(");
        int closeParen = placeholder.lastIndexOf(")");
        int interval = 1;
        if (openParen != -1 && closeParen != -1 && openParen < closeParen) {
            String intervalString = placeholder.substring(openParen + 1, closeParen);
            try {
                interval = Integer.parseInt(intervalString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Pair<String, ListData>(placeholder.substring(0, openBracket), new ListData(insert, interval));
    }

    private <T> List<String> interpretComponent(ComponentLore lore, Player player, ActiveMenu activeMenu, TemplateItem<T> templateItem, T context) {
        String componentName = lore.getComponent();
        MenuComponent component = activeMenu.getComponents().get(componentName);
        if (component == null) {
            return null;
        }
        @NotNull BuiltComponent<?> builtComponent = this.slate.getBuiltMenu(activeMenu.getName()).components().getOrDefault(componentName, BuiltComponent.createEmpty(component.contextClass()));
        ComponentInfo<T> info = new ComponentInfo<T>(this.slate, player, activeMenu, new ItemStack(Material.STONE), templateItem.getName(), context);
        if (!builtComponent.visibility().shouldShow(info)) {
            return null;
        }
        int instances = builtComponent.instances().getInstances(info);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < instances; ++i) {
            ComponentData componentData = new ComponentData(i);
            for (LoreLine line : component.lore()) {
                if (!(line instanceof TextLore)) continue;
                list.add(this.interpretTextLore((TextLore)line, player, activeMenu, componentData, builtComponent, context));
            }
        }
        return list;
    }

    private List<String> interpretComponent(ComponentLore lore, Player player, ActiveMenu activeMenu, MenuItem menuItem) {
        String componentName = lore.getComponent();
        MenuComponent component = activeMenu.getComponents().get(componentName);
        if (component == null) {
            return null;
        }
        @NotNull BuiltComponent<?> builtComponent = this.slate.getBuiltMenu(activeMenu.getName()).components().getOrDefault(componentName, BuiltComponent.createEmpty(component.contextClass()));
        ComponentInfo<Object> info = new ComponentInfo<Object>(this.slate, player, activeMenu, new ItemStack(Material.STONE), menuItem.getName(), null);
        if (!builtComponent.visibility().shouldShow(info)) {
            return null;
        }
        int instances = builtComponent.instances().getInstances(info);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < instances; ++i) {
            ComponentData componentData = new ComponentData(i);
            for (LoreLine line : component.lore()) {
                if (!(line instanceof TextLore)) continue;
                list.add(this.interpretTextLore((TextLore)line, player, activeMenu, componentData, builtComponent, null));
            }
        }
        return list;
    }

    private String replaceAndWrap(TextLore textLore, Player player, String text) {
        if (this.slate.isPlaceholderAPIEnabled()) {
            text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        if (textLore.shouldWrap()) {
            if (textLore.isSmartWrap()) {
                String firstStyle = textLore.getStyles().getStyle(textLore.getWrapStyle());
                AtomicReference<String> prevStyle = new AtomicReference<String>(firstStyle);
                text = firstStyle + textLore.getWrapIndent() + LoreUtil.wrapLore((String)text, this.slate.getLoreWrappingWidth(), textLore, (line, lore) -> {
                    String style;
                    int lastStartIndex = 0;
                    int tagLength = 0;
                    for (int index : lore.getStyles().styleMap().keySet()) {
                        String tag = "<" + index + ">";
                        int startIndex = line.lastIndexOf(tag);
                        if (startIndex < lastStartIndex) continue;
                        lastStartIndex = startIndex;
                        tagLength = tag.length();
                    }
                    if (tagLength > 0) {
                        style = line.substring(lastStartIndex, lastStartIndex + tagLength);
                        prevStyle.set(style);
                    } else {
                        style = (String)prevStyle.get();
                    }
                    return "\n" + lore.getWrapIndent() + style;
                });
            } else {
                String style = textLore.getStyles().getStyle(textLore.getWrapStyle());
                text = style + textLore.getWrapIndent() + LoreUtil.wrapLore((String)text, this.slate.getLoreWrappingWidth(), "\n" + textLore.getWrapIndent() + style);
            }
        }
        return this.applyStyleTags(textLore, (String)text);
    }

    private String applyStyleTags(TextLore textLore, String text) {
        boolean[] usedTags = new boolean[10];
        for (Map.Entry<Integer, String> entry : textLore.getStyles().styleMap().entrySet()) {
            String target = String.valueOf(entry.getKey());
            String style = entry.getValue();
            String styleClose = TextUtil.replace(entry.getValue(), "<", "</");
            text = TextUtil.replace(text, "<" + target + ">", style);
            text = TextUtil.replace(text, "</" + target + ">", styleClose);
            int index = entry.getKey();
            if (index >= 10) continue;
            usedTags[index] = true;
        }
        for (int i = 0; i < usedTags.length; ++i) {
            if (usedTags[i]) continue;
            text = TextUtil.replace(text, "<" + i + ">", "");
            text = TextUtil.replace(text, "</" + i + ">", "");
        }
        return text;
    }
}

