/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.inv;

import dev.aurelium.auraskills.slate.inv.ItemClickData;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ClickableItem {
    public static final ClickableItem NONE = ClickableItem.empty(null);
    private final ItemStack item;
    private final Consumer<?> consumer;
    private final boolean legacy;
    private Predicate<Player> canSee = null;
    private Predicate<Player> canClick = null;
    private ItemStack notVisibleFallBackItem = null;

    private ClickableItem(ItemStack item, Consumer<?> consumer, boolean legacy) {
        this.item = item;
        this.consumer = consumer;
        this.legacy = legacy;
    }

    public static ClickableItem empty(ItemStack item) {
        return ClickableItem.from(item, data -> {});
    }

    @Deprecated
    public static ClickableItem of(ItemStack item, Consumer<InventoryClickEvent> consumer) {
        return new ClickableItem(item, consumer, true);
    }

    public static ClickableItem from(ItemStack item, Consumer<ItemClickData> consumer) {
        return new ClickableItem(item, consumer, false);
    }

    @Deprecated
    public void run(InventoryClickEvent e) {
        if ((this.canSee == null || this.canSee.test((Player)e.getWhoClicked())) && (this.canClick == null || this.canClick.test((Player)e.getWhoClicked()))) {
            if (!this.legacy) {
                return;
            }
            Consumer<?> legacyConsumer = this.consumer;
            legacyConsumer.accept(e);
        }
    }

    public ClickableItem clone(ItemStack newItem) {
        return new ClickableItem(newItem, this.consumer, this.legacy);
    }

    public ClickableItem cloneWithNewItem(ItemStack item) {
        return new ClickableItem(item, this.consumer, this.legacy);
    }

    public void run(ItemClickData data) {
        if ((this.canSee == null || this.canSee.test(data.getPlayer())) && (this.canClick == null || this.canClick.test(data.getPlayer()))) {
            if (this.legacy) {
                Event event = data.getEvent();
                if (event instanceof InventoryClickEvent) {
                    InventoryClickEvent event2 = (InventoryClickEvent)event;
                    this.run(event2);
                }
            } else {
                Consumer<?> newConsumer = this.consumer;
                newConsumer.accept(data);
            }
        }
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack getItem(Player player) {
        if (this.canSee == null || this.canSee.test(player)) {
            return this.item;
        }
        return this.notVisibleFallBackItem;
    }

    public ClickableItem canSee(Predicate<Player> canSee) {
        return this.canSee(canSee, null);
    }

    public ClickableItem canSee(Predicate<Player> canSee, ItemStack fallBackItem) {
        this.canSee = canSee;
        this.notVisibleFallBackItem = fallBackItem;
        return this;
    }

    public ClickableItem canClick(Predicate<Player> canClick) {
        this.canClick = canClick;
        return this;
    }
}

