/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.fill;

import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SlotParser {
    public SlotPos[] parse(ConfigurationNode section, int size) {
        List slotList = (List)section.node("slots").raw();
        if (slotList != null) {
            SlotPos[] slots = new SlotPos[slotList.size()];
            int index = 0;
            for (Object element : slotList) {
                slots[index] = this.parseSlot(element);
                ++index;
            }
            return slots;
        }
        if (!section.node("shape").virtual()) {
            String shape = section.node("shape").getString("border");
            return this.parseShapeNames(shape, size);
        }
        if (!section.node("shapes").empty()) {
            ArrayList<SlotPos> slots = new ArrayList<SlotPos>();
            for (ConfigurationNode configurationNode : section.node("shapes").childrenList()) {
                if (configurationNode.isMap()) {
                    String shapeName;
                    int i;
                    if (!configurationNode.node("row").empty()) {
                        int row = configurationNode.node("row").getInt();
                        if (row < 0 || row >= 6) continue;
                        for (i = 0; i < 9; ++i) {
                            slots.add(SlotPos.of(row, i));
                        }
                        continue;
                    }
                    if (!configurationNode.node("column").empty()) {
                        int col = configurationNode.node("column").getInt();
                        if (col < 0 || col >= 9) continue;
                        for (i = 0; i < size; ++i) {
                            slots.add(SlotPos.of(i, col));
                        }
                        continue;
                    }
                    if (configurationNode.node("shape").empty() || (shapeName = configurationNode.node("shape").getString()) == null) continue;
                    slots.addAll(Arrays.asList(this.parseShapeNames(shapeName, size)));
                    continue;
                }
                slots.add(this.parseSlot(configurationNode.raw()));
            }
            return slots.toArray(new SlotPos[0]);
        }
        return null;
    }

    private SlotPos[] parseShapeNames(String shape, int size) {
        switch (shape) {
            case "border": {
                ArrayList<SlotPos> slots = new ArrayList<SlotPos>();
                for (int i = 0; i < 9; ++i) {
                    slots.add(SlotPos.of(0, i));
                    slots.add(SlotPos.of(size - 1, i));
                }
                for (int r = 1; r < size - 1; ++r) {
                    slots.add(SlotPos.of(r, 0));
                    slots.add(SlotPos.of(r, 8));
                }
                return slots.toArray(new SlotPos[0]);
            }
            case "top_row": {
                SlotPos[] slots = new SlotPos[9];
                for (int i = 0; i < 9; ++i) {
                    slots[i] = SlotPos.of(0, i);
                }
                return slots;
            }
            case "bottom_row": {
                SlotPos[] slots = new SlotPos[9];
                for (int i = 0; i < 9; ++i) {
                    slots[i] = SlotPos.of(size - 1, i);
                }
                return slots;
            }
            case "left_column": {
                SlotPos[] slots = new SlotPos[size];
                for (int i = 0; i < size; ++i) {
                    slots[i] = SlotPos.of(i, 0);
                }
                return slots;
            }
            case "right_column": {
                SlotPos[] slots = new SlotPos[size];
                for (int i = 0; i < size; ++i) {
                    slots[i] = SlotPos.of(i, 8);
                }
                return slots;
            }
        }
        return new SlotPos[0];
    }

    private SlotPos parseSlot(Object element) {
        String str;
        String[] splitStr;
        if (element instanceof Integer) {
            int value = (Integer)element;
            return SlotPos.of(value / 9, value % 9);
        }
        if (element instanceof String && (splitStr = (str = (String)element).split(",")).length > 1) {
            return SlotPos.of(Integer.parseInt(splitStr[0]), Integer.parseInt(splitStr[1]));
        }
        return SlotPos.of(0, 0);
    }
}

