/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.builder;

import dev.aurelium.auraskills.slate.builder.GlobalBehavior;
import dev.aurelium.auraskills.slate.function.ItemReplacer;
import dev.aurelium.auraskills.slate.function.LocaleProvider;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class GlobalBehaviorBuilder {
    private final Set<ItemReplacer> globalReplacers = new HashSet<ItemReplacer>();
    private LocaleProvider localeProvider = p -> Locale.ENGLISH;

    private GlobalBehaviorBuilder() {
    }

    public static GlobalBehaviorBuilder builder() {
        return new GlobalBehaviorBuilder();
    }

    public GlobalBehaviorBuilder replacer(ItemReplacer replacer) {
        this.globalReplacers.add(replacer);
        return this;
    }

    public GlobalBehaviorBuilder localeProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
        return this;
    }

    public GlobalBehavior build() {
        return new GlobalBehavior(this.globalReplacers, this.localeProvider);
    }
}

