/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.action;

import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.action.Action;
import dev.aurelium.auraskills.slate.action.parser.CommandActionParser;
import dev.aurelium.auraskills.slate.action.parser.MenuActionParser;
import dev.aurelium.auraskills.slate.action.parser.SoundActionParser;
import dev.aurelium.auraskills.slate.util.MapParser;
import dev.aurelium.auraskills.slate.util.YamlLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;

public class ActionManager
extends MapParser {
    private final Slate slate;

    public ActionManager(Slate slate) {
        this.slate = slate;
    }

    public List<Action> parseActions(ConfigurationNode config, String menuName) {
        ArrayList<Action> actions = new ArrayList<Action>();
        int index = 0;
        for (ConfigurationNode configurationNode : config.childrenList()) {
            try {
                String type;
                Action action = switch (type = Objects.requireNonNull(this.detectType(configurationNode))) {
                    case "command" -> new CommandActionParser(this.slate).parse(configurationNode);
                    case "menu" -> new MenuActionParser(this.slate).parse(configurationNode);
                    case "sound" -> new SoundActionParser(this.slate).parse(configurationNode);
                    default -> throw new IllegalArgumentException("Action with type " + type + " not found");
                };
                actions.add(action);
            }
            catch (RuntimeException e) {
                this.slate.getPlugin().getLogger().warning("Error parsing action in menu " + menuName + " at path " + YamlLoader.toDotString(config.path()) + ".[" + index + "], see below for error:");
                e.printStackTrace();
            }
            ++index;
        }
        return actions;
    }

    @Nullable
    private String detectType(ConfigurationNode node) {
        String type = node.node("type").getString();
        if (type != null) {
            return type.toLowerCase(Locale.ROOT);
        }
        if (!node.node("command").virtual()) {
            return "command";
        }
        if (!node.node("menu").virtual()) {
            return "menu";
        }
        if (!node.node("sound").virtual()) {
            return "sound";
        }
        return null;
    }
}

