/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate;

import dev.aurelium.auraskills.slate.action.ActionManager;
import dev.aurelium.auraskills.slate.builder.BuiltMenu;
import dev.aurelium.auraskills.slate.builder.GlobalBehavior;
import dev.aurelium.auraskills.slate.builder.GlobalBehaviorBuilder;
import dev.aurelium.auraskills.slate.builder.MenuBuilder;
import dev.aurelium.auraskills.slate.context.ContextManager;
import dev.aurelium.auraskills.slate.inv.InventoryManager;
import dev.aurelium.auraskills.slate.item.ItemProtection;
import dev.aurelium.auraskills.slate.menu.LoadedMenu;
import dev.aurelium.auraskills.slate.menu.MenuFileGenerator;
import dev.aurelium.auraskills.slate.menu.MenuLoader;
import dev.aurelium.auraskills.slate.menu.MenuOpener;
import dev.aurelium.auraskills.slate.option.SlateOptions;
import dev.aurelium.auraskills.slate.scheduler.Scheduler;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Slate {
    private final JavaPlugin plugin;
    private final Scheduler scheduler;
    private final ContextManager contextManager;
    private final InventoryManager inventoryManager;
    private final ActionManager actionManager;
    private final boolean placeholderAPIEnabled;
    private final SlateOptions options;
    private final Map<String, BuiltMenu> builtMenus = new HashMap<String, BuiltMenu>();
    private final Map<String, LoadedMenu> loadedMenus = new LinkedHashMap<String, LoadedMenu>();
    private final MenuOpener menuOpener = new MenuOpener(this);
    private final ItemProtection itemProtection = new ItemProtection();
    private GlobalBehavior globalBehavior = GlobalBehaviorBuilder.builder().build();

    public Slate(JavaPlugin plugin, SlateOptions options) {
        this.plugin = plugin;
        this.scheduler = Scheduler.createScheduler(plugin);
        this.contextManager = new ContextManager();
        this.inventoryManager = new InventoryManager(plugin, this.scheduler);
        this.inventoryManager.init();
        this.actionManager = new ActionManager(this);
        this.placeholderAPIEnabled = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        this.options = options;
        if (options.removalProtection()) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this.itemProtection, (Plugin)plugin);
        }
    }

    public int loadMenus() {
        MenuLoader loader = new MenuLoader(this, this.options.mainDirectory(), this.options.mergeDirectories());
        return loader.loadMenus();
    }

    public void generateFiles() {
        new MenuFileGenerator(this).generate();
    }

    public void openMenu(Player player, String name, Map<String, Object> properties, int page) {
        this.menuOpener.openMenu(player, name, properties, page);
    }

    public void openMenuUnchecked(Player player, String name, Map<String, Object> properties, int page) {
        this.menuOpener.openMenuUnchecked(player, name, properties, page);
    }

    public void openMenu(Player player, String name, Map<String, Object> properties) {
        this.menuOpener.openMenu(player, name, properties);
    }

    public void openMenu(Player player, String name, int page) {
        this.menuOpener.openMenu(player, name, page);
    }

    public void openMenu(Player player, String name) {
        this.menuOpener.openMenu(player, name);
    }

    public void unregisterMenus() {
        this.builtMenus.clear();
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public boolean isPlaceholderAPIEnabled() {
        return this.placeholderAPIEnabled;
    }

    public int getLoreWrappingWidth() {
        return this.options.loreWrappingWidth();
    }

    public SlateOptions getOptions() {
        return this.options;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public ItemProtection getItemProtection() {
        return this.itemProtection;
    }

    public void buildMenu(String name, Consumer<MenuBuilder> menu) {
        MenuBuilder builder = MenuBuilder.builder();
        menu.accept(builder);
        this.builtMenus.put(name, builder.build());
    }

    @NotNull
    public BuiltMenu getBuiltMenu(String name) {
        return this.builtMenus.getOrDefault(name, BuiltMenu.createEmpty());
    }

    public Map<String, BuiltMenu> getBuiltMenus() {
        return this.builtMenus;
    }

    public void addLoadedMenu(LoadedMenu menu) {
        this.loadedMenus.put(menu.name(), menu);
    }

    @Nullable
    public LoadedMenu getLoadedMenu(String name) {
        return this.loadedMenus.get(name);
    }

    public Map<String, LoadedMenu> getLoadedMenus() {
        return this.loadedMenus;
    }

    public void setGlobalBehavior(Consumer<GlobalBehaviorBuilder> options) {
        GlobalBehaviorBuilder builder = GlobalBehaviorBuilder.builder();
        options.accept(builder);
        this.globalBehavior = builder.build();
    }

    public GlobalBehavior getGlobalBehavior() {
        return this.globalBehavior;
    }

    public void addMergeDirectory(File mergeDir) {
        if (!mergeDir.isDirectory()) {
            return;
        }
        if (this.options.mergeDirectories().contains(mergeDir)) {
            this.removeMergeDirectory(mergeDir);
        }
        this.options.mergeDirectories().add(mergeDir);
    }

    public void removeMergeDirectory(File mergeDir) {
        this.options.mergeDirectories().remove(mergeDir);
    }
}

