/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.querz.nbt.io;

import dev.aurelium.auraskills.querz.nbt.io.NBTDeserializer;
import dev.aurelium.auraskills.querz.nbt.io.NBTSerializer;
import dev.aurelium.auraskills.querz.nbt.io.NamedTag;
import dev.aurelium.auraskills.querz.nbt.tag.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;

public final class NBTUtil {
    private NBTUtil() {
    }

    public static void write(NamedTag tag, File file, boolean compressed) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            new NBTSerializer(compressed).toStream(tag, (OutputStream)fos);
        }
    }

    public static void write(NamedTag tag, String file, boolean compressed) throws IOException {
        NBTUtil.write(tag, new File(file), compressed);
    }

    public static void write(NamedTag tag, File file) throws IOException {
        NBTUtil.write(tag, file, true);
    }

    public static void write(NamedTag tag, String file) throws IOException {
        NBTUtil.write(tag, new File(file), true);
    }

    public static void write(Tag<?> tag, File file, boolean compressed) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), file, compressed);
    }

    public static void write(Tag<?> tag, String file, boolean compressed) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), new File(file), compressed);
    }

    public static void write(Tag<?> tag, File file) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), file, true);
    }

    public static void write(Tag<?> tag, String file) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), new File(file), true);
    }

    public static void writeLE(NamedTag tag, File file, boolean compressed) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            new NBTSerializer(compressed, true).toStream(tag, (OutputStream)fos);
        }
    }

    public static void writeLE(NamedTag tag, String file, boolean compressed) throws IOException {
        NBTUtil.writeLE(tag, new File(file), compressed);
    }

    public static void writeLE(NamedTag tag, File file) throws IOException {
        NBTUtil.writeLE(tag, file, true);
    }

    public static void writeLE(NamedTag tag, String file) throws IOException {
        NBTUtil.writeLE(tag, new File(file), true);
    }

    public static void writeLE(Tag<?> tag, File file, boolean compressed) throws IOException {
        NBTUtil.writeLE(new NamedTag(null, tag), file, compressed);
    }

    public static void writeLE(Tag<?> tag, String file, boolean compressed) throws IOException {
        NBTUtil.writeLE(new NamedTag(null, tag), new File(file), compressed);
    }

    public static void writeLE(Tag<?> tag, File file) throws IOException {
        NBTUtil.writeLE(new NamedTag(null, tag), file, true);
    }

    public static void writeLE(Tag<?> tag, String file) throws IOException {
        NBTUtil.writeLE(new NamedTag(null, tag), new File(file), true);
    }

    public static NamedTag read(File file, boolean compressed) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            NamedTag namedTag = new NBTDeserializer(compressed).fromStream(fis);
            return namedTag;
        }
    }

    public static NamedTag read(String file, boolean compressed) throws IOException {
        return NBTUtil.read(new File(file), compressed);
    }

    public static NamedTag read(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            NamedTag namedTag = new NBTDeserializer(false).fromStream(NBTUtil.detectDecompression(fis));
            return namedTag;
        }
    }

    public static NamedTag read(String file) throws IOException {
        return NBTUtil.read(new File(file));
    }

    public static NamedTag readLE(File file, boolean compressed) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            NamedTag namedTag = new NBTDeserializer(compressed, true).fromStream(fis);
            return namedTag;
        }
    }

    public static NamedTag readLE(String file, boolean compressed) throws IOException {
        return NBTUtil.readLE(new File(file), compressed);
    }

    public static NamedTag readLE(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            NamedTag namedTag = new NBTDeserializer(false, true).fromStream(NBTUtil.detectDecompression(fis));
            return namedTag;
        }
    }

    public static NamedTag readLE(String file) throws IOException {
        return NBTUtil.readLE(new File(file));
    }

    private static InputStream detectDecompression(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(is, 2);
        int signature = (pbis.read() & 0xFF) + (pbis.read() << 8);
        pbis.unread(signature >> 8);
        pbis.unread(signature & 0xFF);
        if (signature == 35615) {
            return new GZIPInputStream(pbis);
        }
        return pbis;
    }
}

