/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.querz.nbt.io;

import dev.aurelium.auraskills.querz.io.ExceptionBiFunction;
import dev.aurelium.auraskills.querz.io.MaxDepthIO;
import dev.aurelium.auraskills.querz.nbt.io.NBTInput;
import dev.aurelium.auraskills.querz.nbt.io.NamedTag;
import dev.aurelium.auraskills.querz.nbt.tag.ByteArrayTag;
import dev.aurelium.auraskills.querz.nbt.tag.ByteTag;
import dev.aurelium.auraskills.querz.nbt.tag.CompoundTag;
import dev.aurelium.auraskills.querz.nbt.tag.DoubleTag;
import dev.aurelium.auraskills.querz.nbt.tag.EndTag;
import dev.aurelium.auraskills.querz.nbt.tag.FloatTag;
import dev.aurelium.auraskills.querz.nbt.tag.IntArrayTag;
import dev.aurelium.auraskills.querz.nbt.tag.IntTag;
import dev.aurelium.auraskills.querz.nbt.tag.ListTag;
import dev.aurelium.auraskills.querz.nbt.tag.LongArrayTag;
import dev.aurelium.auraskills.querz.nbt.tag.LongTag;
import dev.aurelium.auraskills.querz.nbt.tag.ShortTag;
import dev.aurelium.auraskills.querz.nbt.tag.StringTag;
import dev.aurelium.auraskills.querz.nbt.tag.Tag;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class LittleEndianNBTInputStream
implements DataInput,
NBTInput,
MaxDepthIO,
Closeable {
    private final DataInputStream input;
    private static Map<Byte, ExceptionBiFunction<LittleEndianNBTInputStream, Integer, ? extends Tag<?>, IOException>> readers = new HashMap();
    private static Map<Byte, Class<?>> idClassMapping = new HashMap();

    private static void put(byte id, ExceptionBiFunction<LittleEndianNBTInputStream, Integer, ? extends Tag<?>, IOException> reader, Class<?> clazz) {
        readers.put(id, reader);
        idClassMapping.put(id, clazz);
    }

    public LittleEndianNBTInputStream(InputStream in) {
        this.input = new DataInputStream(in);
    }

    public LittleEndianNBTInputStream(DataInputStream in) {
        this.input = in;
    }

    @Override
    public NamedTag readTag(int maxDepth) throws IOException {
        byte id = this.readByte();
        return new NamedTag(this.readUTF(), this.readTag(id, maxDepth));
    }

    @Override
    public Tag<?> readRawTag(int maxDepth) throws IOException {
        byte id = this.readByte();
        return this.readTag(id, maxDepth);
    }

    private Tag<?> readTag(byte type, int maxDepth) throws IOException {
        ExceptionBiFunction<LittleEndianNBTInputStream, Integer, Tag<?>, IOException> f = readers.get(type);
        if (f == null) {
            throw new IOException("invalid tag id \"" + type + "\"");
        }
        return f.accept(this, maxDepth);
    }

    private static ByteTag readByte(LittleEndianNBTInputStream in) throws IOException {
        return new ByteTag(in.readByte());
    }

    private static ShortTag readShort(LittleEndianNBTInputStream in) throws IOException {
        return new ShortTag(in.readShort());
    }

    private static IntTag readInt(LittleEndianNBTInputStream in) throws IOException {
        return new IntTag(in.readInt());
    }

    private static LongTag readLong(LittleEndianNBTInputStream in) throws IOException {
        return new LongTag(in.readLong());
    }

    private static FloatTag readFloat(LittleEndianNBTInputStream in) throws IOException {
        return new FloatTag(in.readFloat());
    }

    private static DoubleTag readDouble(LittleEndianNBTInputStream in) throws IOException {
        return new DoubleTag(in.readDouble());
    }

    private static StringTag readString(LittleEndianNBTInputStream in) throws IOException {
        return new StringTag(in.readUTF());
    }

    private static ByteArrayTag readByteArray(LittleEndianNBTInputStream in) throws IOException {
        ByteArrayTag bat = new ByteArrayTag(new byte[in.readInt()]);
        in.readFully((byte[])bat.getValue());
        return bat;
    }

    private static IntArrayTag readIntArray(LittleEndianNBTInputStream in) throws IOException {
        int l = in.readInt();
        int[] data = new int[l];
        IntArrayTag iat = new IntArrayTag(data);
        for (int i = 0; i < l; ++i) {
            data[i] = in.readInt();
        }
        return iat;
    }

    private static LongArrayTag readLongArray(LittleEndianNBTInputStream in) throws IOException {
        int l = in.readInt();
        long[] data = new long[l];
        LongArrayTag iat = new LongArrayTag(data);
        for (int i = 0; i < l; ++i) {
            data[i] = in.readLong();
        }
        return iat;
    }

    private static ListTag<?> readListTag(LittleEndianNBTInputStream in, int maxDepth) throws IOException {
        byte listType = in.readByte();
        ListTag<?> list = ListTag.createUnchecked(idClassMapping.get(listType));
        int length = in.readInt();
        if (length < 0) {
            length = 0;
        }
        for (int i = 0; i < length; ++i) {
            list.addUnchecked(in.readTag(listType, in.decrementMaxDepth(maxDepth)));
        }
        return list;
    }

    private static CompoundTag readCompound(LittleEndianNBTInputStream in, int maxDepth) throws IOException {
        CompoundTag comp = new CompoundTag();
        int id = in.readByte() & 0xFF;
        while (id != 0) {
            String key = in.readUTF();
            Tag<?> element = in.readTag((byte)id, in.decrementMaxDepth(maxDepth));
            comp.put(key, element);
            id = in.readByte() & 0xFF;
        }
        return comp;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.input.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.input.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.input.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.input.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.input.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.input.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return Short.reverseBytes(this.input.readShort());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return Short.toUnsignedInt(Short.reverseBytes(this.input.readShort()));
    }

    @Override
    public char readChar() throws IOException {
        return Character.reverseBytes(this.input.readChar());
    }

    @Override
    public int readInt() throws IOException {
        return Integer.reverseBytes(this.input.readInt());
    }

    @Override
    public long readLong() throws IOException {
        return Long.reverseBytes(this.input.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(Integer.reverseBytes(this.input.readInt()));
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(Long.reverseBytes(this.input.readLong()));
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.input.readLine();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public String readUTF() throws IOException {
        byte[] bytes = new byte[this.readUnsignedShort()];
        this.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static {
        LittleEndianNBTInputStream.put((byte)0, (i, d) -> EndTag.INSTANCE, EndTag.class);
        LittleEndianNBTInputStream.put((byte)1, (i, d) -> LittleEndianNBTInputStream.readByte(i), ByteTag.class);
        LittleEndianNBTInputStream.put((byte)2, (i, d) -> LittleEndianNBTInputStream.readShort(i), ShortTag.class);
        LittleEndianNBTInputStream.put((byte)3, (i, d) -> LittleEndianNBTInputStream.readInt(i), IntTag.class);
        LittleEndianNBTInputStream.put((byte)4, (i, d) -> LittleEndianNBTInputStream.readLong(i), LongTag.class);
        LittleEndianNBTInputStream.put((byte)5, (i, d) -> LittleEndianNBTInputStream.readFloat(i), FloatTag.class);
        LittleEndianNBTInputStream.put((byte)6, (i, d) -> LittleEndianNBTInputStream.readDouble(i), DoubleTag.class);
        LittleEndianNBTInputStream.put((byte)7, (i, d) -> LittleEndianNBTInputStream.readByteArray(i), ByteArrayTag.class);
        LittleEndianNBTInputStream.put((byte)8, (i, d) -> LittleEndianNBTInputStream.readString(i), StringTag.class);
        LittleEndianNBTInputStream.put((byte)9, LittleEndianNBTInputStream::readListTag, ListTag.class);
        LittleEndianNBTInputStream.put((byte)10, LittleEndianNBTInputStream::readCompound, CompoundTag.class);
        LittleEndianNBTInputStream.put((byte)11, (i, d) -> LittleEndianNBTInputStream.readIntArray(i), IntArrayTag.class);
        LittleEndianNBTInputStream.put((byte)12, (i, d) -> LittleEndianNBTInputStream.readLongArray(i), LongArrayTag.class);
    }
}

