/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.querz.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public interface Deserializer<T> {
    public T fromStream(InputStream var1) throws IOException;

    default public T fromFile(File file) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            T t = this.fromStream(bis);
            return t;
        }
    }

    default public T fromBytes(byte[] data) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        return this.fromStream(stream);
    }

    default public T fromResource(Class<?> clazz, String path) throws IOException {
        try (InputStream stream = clazz.getClassLoader().getResourceAsStream(path);){
            if (stream == null) {
                throw new IOException("resource \"" + path + "\" not found");
            }
            T t = this.fromStream(stream);
            return t;
        }
    }

    default public T fromURL(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            T t = this.fromStream(stream);
            return t;
        }
    }
}

