/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.polyglot.lang;

import dev.aurelium.auraskills.configurate.CommentedConfigurationNode;
import dev.aurelium.auraskills.configurate.ConfigurateException;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.NodePath;
import dev.aurelium.auraskills.configurate.loader.HeaderMode;
import dev.aurelium.auraskills.configurate.yaml.NodeStyle;
import dev.aurelium.auraskills.configurate.yaml.YamlConfigurationLoader;
import dev.aurelium.auraskills.polyglot.Polyglot;
import dev.aurelium.auraskills.polyglot.config.MessageReplacements;
import dev.aurelium.auraskills.polyglot.lang.LangMessages;
import dev.aurelium.auraskills.polyglot.lang.MessageKey;
import dev.aurelium.auraskills.polyglot.lang.NodePrioritySorter;
import dev.aurelium.auraskills.polyglot.util.TextUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class MessageLoader {
    private final Polyglot polyglot;

    public MessageLoader(Polyglot polyglot) {
        this.polyglot = polyglot;
    }

    public Optional<LangMessages> loadMessageFile(File file) throws Exception {
        Locale locale = this.getLocaleFromFile(file.getName());
        if (locale == null) {
            return Optional.empty();
        }
        CommentedConfigurationNode root = this.loadYamlFile(file);
        return Optional.of(this.loadFromNode(root, locale, this.getLanguageCode(file.getName())));
    }

    public LangMessages loadEmbeddedMessages(String defaultLanguageCode) throws Exception {
        String fileName = TextUtil.replace(this.polyglot.getConfig().getMessageFileName(), "{language}", defaultLanguageCode);
        InputStream is = this.polyglot.getProvider().getResource(this.polyglot.getConfig().getMessageDirectory() + "/" + fileName);
        if (is == null) {
            throw new IllegalStateException("Embedded messages file is missing!");
        }
        CommentedConfigurationNode root = this.loadYamlFile(is);
        return this.loadFromNode(root, Locale.forLanguageTag(defaultLanguageCode), defaultLanguageCode);
    }

    private LangMessages loadFromNode(CommentedConfigurationNode root, @NotNull Locale locale, @NotNull String languageCode) {
        HashMap<MessageKey, String> messageMap = new HashMap<MessageKey, String>();
        this.loadChildrenRec(root, messageMap, 0);
        return new LangMessages(locale, languageCode, messageMap);
    }

    private void loadChildrenRec(ConfigurationNode node, Map<MessageKey, String> messageMap, int depth) {
        ArrayList<ConfigurationNode> nodes = new ArrayList<ConfigurationNode>(node.childrenMap().values().stream().map(o -> o).toList());
        nodes.sort(new NodePrioritySorter(this.polyglot.getConfig().getMessageReplacements(), depth));
        for (ConfigurationNode child : nodes) {
            String message = child.getString();
            if (message != null) {
                MessageKey key = MessageKey.of(this.formatPath(child.path()));
                message = this.applyReplacements(message, messageMap);
                message = this.processMessage(message);
                messageMap.put(key, message);
                continue;
            }
            this.loadChildrenRec(child, messageMap, depth + 1);
        }
    }

    @VisibleForTesting
    @Nullable
    public Locale getLocaleFromFile(String fileName) {
        if (fileName.equals("global.yml")) {
            return Locale.ROOT;
        }
        String localeName = this.getLanguageCode(fileName);
        try {
            return new Locale.Builder().setLanguageTag(localeName).build();
        }
        catch (IllformedLocaleException e) {
            this.polyglot.getProvider().logWarn("Invalid language tag: " + localeName);
            return null;
        }
    }

    private String getLanguageCode(String fileName) {
        return fileName.substring(fileName.indexOf("_") + 1, fileName.lastIndexOf("."));
    }

    private String formatPath(NodePath path) {
        StringBuilder builder = new StringBuilder();
        if (path.size() == 0) {
            return "";
        }
        path.forEach(o -> {
            if (o instanceof String) {
                String s = (String)o;
                builder.append(s).append(".");
            }
        });
        return builder.substring(0, builder.length() - 1);
    }

    public CommentedConfigurationNode loadYamlFile(File file) throws ConfigurateException {
        Path path = file.toPath();
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(path)).headerMode(HeaderMode.PRESERVE)).nodeStyle(NodeStyle.BLOCK).indent(2).build();
        return (CommentedConfigurationNode)loader.load();
    }

    public CommentedConfigurationNode loadYamlFile(InputStream is) throws ConfigurateException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().headerMode(HeaderMode.PRESERVE)).nodeStyle(NodeStyle.BLOCK).indent(2).source(() -> new BufferedReader(new InputStreamReader(is)))).build();
        return (CommentedConfigurationNode)loader.load();
    }

    private String processMessage(String input) {
        return input.replace("\\n", "\n");
    }

    private String applyReplacements(String input, Map<MessageKey, String> messageMap) {
        MessageReplacements replacements = this.polyglot.getConfig().getMessageReplacements();
        for (Map.Entry<String, String> entry : replacements.getReplacements().entrySet()) {
            String toReplace = entry.getKey();
            String replacement = messageMap.get(MessageKey.of(entry.getValue()));
            if (replacement == null) continue;
            input = input.replace(toReplace, replacement);
        }
        return input;
    }
}

