/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.evalex.operators.arithmetic;

import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.data.EvaluationValue;
import dev.aurelium.auraskills.evalex.operators.AbstractOperator;
import dev.aurelium.auraskills.evalex.operators.InfixOperator;
import dev.aurelium.auraskills.evalex.parser.Token;
import java.time.Duration;

@InfixOperator(precedence=20)
public class InfixPlusOperator
extends AbstractOperator {
    @Override
    public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) {
        EvaluationValue leftOperand = operands[0];
        EvaluationValue rightOperand = operands[1];
        if (leftOperand.isNumberValue() && rightOperand.isNumberValue()) {
            return expression.convertValue(leftOperand.getNumberValue().add(rightOperand.getNumberValue(), expression.getConfiguration().getMathContext()));
        }
        if (leftOperand.isDateTimeValue() && rightOperand.isDurationValue()) {
            return expression.convertValue(leftOperand.getDateTimeValue().plus(rightOperand.getDurationValue()));
        }
        if (leftOperand.isDurationValue() && rightOperand.isDurationValue()) {
            return expression.convertValue(leftOperand.getDurationValue().plus(rightOperand.getDurationValue()));
        }
        if (leftOperand.isDateTimeValue() && rightOperand.isNumberValue()) {
            return expression.convertValue(leftOperand.getDateTimeValue().plus(Duration.ofMillis(rightOperand.getNumberValue().longValue())));
        }
        return expression.convertValue(leftOperand.getStringValue() + rightOperand.getStringValue());
    }
}

