/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.evalex.functions.trigonometric;

import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.data.EvaluationValue;
import dev.aurelium.auraskills.evalex.functions.AbstractFunction;
import dev.aurelium.auraskills.evalex.functions.FunctionParameter;
import dev.aurelium.auraskills.evalex.parser.Token;

@FunctionParameter(name="value")
public class AcosHFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        double value = parameterValues[0].getNumberValue().doubleValue();
        if (Double.compare(value, 1.0) < 0) {
            throw new EvaluationException(functionToken, "Value must be greater or equal to one");
        }
        return expression.convertDoubleValue(Math.log(value + Math.sqrt(Math.pow(value, 2.0) - 1.0)));
    }
}

