/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.evalex.functions.datetime;

import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.data.EvaluationValue;
import dev.aurelium.auraskills.evalex.functions.AbstractFunction;
import dev.aurelium.auraskills.evalex.functions.FunctionParameter;
import dev.aurelium.auraskills.evalex.functions.FunctionParameters;
import dev.aurelium.auraskills.evalex.functions.datetime.ZoneIdConverter;
import dev.aurelium.auraskills.evalex.parser.Token;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

@FunctionParameters(value={@FunctionParameter(name="value"), @FunctionParameter(name="parameters", isVarArg=true)})
public class DateTimeFormatFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        DateTimeFormatter formatter = expression.getConfiguration().getDateTimeFormatters().get(0);
        if (parameterValues.length > 1) {
            formatter = DateTimeFormatter.ofPattern(parameterValues[1].getStringValue()).withLocale(expression.getConfiguration().getLocale());
        }
        ZoneId zoneId = expression.getConfiguration().getZoneId();
        if (parameterValues.length == 3) {
            zoneId = ZoneIdConverter.convert(functionToken, parameterValues[2].getStringValue());
        }
        return expression.convertValue(parameterValues[0].getDateTimeValue().atZone(zoneId).format(formatter));
    }

    @Override
    public void validatePreEvaluation(Token token, EvaluationValue ... parameterValues) throws EvaluationException {
        super.validatePreEvaluation(token, parameterValues);
        if (parameterValues.length > 3) {
            throw new EvaluationException(token, "Too many parameters");
        }
        if (!parameterValues[0].isDateTimeValue()) {
            throw new EvaluationException(token, String.format("Unable to format a '%s' type as a date-time", parameterValues[0].getDataType().name()));
        }
    }
}

