/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.evalex.config;

import dev.aurelium.auraskills.evalex.config.OperatorDictionaryIfc;
import dev.aurelium.auraskills.evalex.operators.OperatorIfc;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class MapBasedOperatorDictionary
implements OperatorDictionaryIfc {
    final Map<String, OperatorIfc> prefixOperators = new TreeMap<String, OperatorIfc>(String.CASE_INSENSITIVE_ORDER);
    final Map<String, OperatorIfc> postfixOperators = new TreeMap<String, OperatorIfc>(String.CASE_INSENSITIVE_ORDER);
    final Map<String, OperatorIfc> infixOperators = new TreeMap<String, OperatorIfc>(String.CASE_INSENSITIVE_ORDER);

    public static OperatorDictionaryIfc ofOperators(Map.Entry<String, OperatorIfc> ... operators) {
        MapBasedOperatorDictionary dictionary = new MapBasedOperatorDictionary();
        Arrays.stream(operators).forEach(entry -> dictionary.addOperator((String)entry.getKey(), (OperatorIfc)entry.getValue()));
        return dictionary;
    }

    @Override
    public void addOperator(String operatorString, OperatorIfc operator) {
        if (operator.isPrefix()) {
            this.prefixOperators.put(operatorString, operator);
        } else if (operator.isPostfix()) {
            this.postfixOperators.put(operatorString, operator);
        } else {
            this.infixOperators.put(operatorString, operator);
        }
    }

    @Override
    public OperatorIfc getPrefixOperator(String operatorString) {
        return this.prefixOperators.get(operatorString);
    }

    @Override
    public OperatorIfc getPostfixOperator(String operatorString) {
        return this.postfixOperators.get(operatorString);
    }

    @Override
    public OperatorIfc getInfixOperator(String operatorString) {
        return this.infixOperators.get(operatorString);
    }
}

