/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.configurate.serialize;

import dev.aurelium.auraskills.configurate.serialize.AbstractListChildSerializer;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.configurate.util.CheckedConsumer;
import dev.aurelium.auraskills.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SetSerializer
extends AbstractListChildSerializer<Set<?>> {
    static boolean accepts(Type type) {
        Class<AbstractSet> erased = GenericTypeReflector.erase(type);
        return Set.class.isAssignableFrom(erased) && (erased.isAssignableFrom(EnumSet.class) || erased.isAssignableFrom(LinkedHashSet.class));
    }

    SetSerializer() {
    }

    @Override
    protected AnnotatedType elementType(AnnotatedType containerType) throws SerializationException {
        if (!(containerType instanceof AnnotatedParameterizedType)) {
            throw new SerializationException("Raw types are not supported for collections");
        }
        return ((AnnotatedParameterizedType)containerType).getAnnotatedActualTypeArguments()[0];
    }

    @Override
    protected Set<?> createNew(int length, AnnotatedType elementType) {
        Class<?> erased = GenericTypeReflector.erase(elementType.getType());
        if (erased.isEnum()) {
            return EnumSet.noneOf(erased.asSubclass(Enum.class));
        }
        return new LinkedHashSet(length);
    }

    @Override
    protected void forEachElement(Set<?> collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
        for (Object el : collection) {
            action.accept(el);
        }
    }

    @Override
    protected void deserializeSingle(int index, Set<?> collection, @Nullable Object deserialized) {
        collection.add(deserialized);
    }
}

