/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.configurate.serialize;

import dev.aurelium.auraskills.configurate.serialize.ScalarSerializer;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.configurate.util.EnumLookup;
import dev.aurelium.auraskills.geantyref.GenericTypeReflector;
import dev.aurelium.auraskills.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

final class EnumValueSerializer
extends ScalarSerializer<Enum<?>> {
    EnumValueSerializer() {
        super(new TypeToken<Enum<?>>(){});
    }

    @Override
    public Enum<?> deserialize(Type type, Object obj) throws SerializationException {
        String enumConstant = obj.toString();
        @Nullable Enum ret = EnumLookup.lookupEnum(GenericTypeReflector.erase(type).asSubclass(Enum.class), enumConstant);
        if (ret == null) {
            throw new SerializationException(type, "Invalid enum constant provided, expected a value of enum, got " + enumConstant);
        }
        return ret;
    }

    @Override
    public Object serialize(Enum<?> item, Predicate<Class<?>> typeSupported) {
        return item.name();
    }
}

