/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.configurate.loader;

import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.ScopedConfigurationNode;
import dev.aurelium.auraskills.configurate.loader.AbstractConfigurationLoader;
import dev.aurelium.auraskills.configurate.loader.ConfigurationFormat;
import dev.aurelium.auraskills.configurate.loader.ConfigurationLoader;
import dev.aurelium.auraskills.configurate.loader.ValueSources;
import dev.aurelium.auraskills.configurate.util.UnmodifiableCollections;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractConfigurationFormat<N extends ScopedConfigurationNode<N>, L extends AbstractConfigurationLoader<N>, B extends AbstractConfigurationLoader.Builder<B, L>>
implements ConfigurationFormat {
    private final String id;
    private final Supplier<B> builderMaker;
    private final Set<String> supportedExtensions;

    protected AbstractConfigurationFormat(String id, Supplier<B> builderMaker, Set<String> supportedExtensions) {
        this.id = Objects.requireNonNull(id, "id");
        this.builderMaker = Objects.requireNonNull(builderMaker, "builderMaker");
        this.supportedExtensions = UnmodifiableCollections.copyOf(Objects.requireNonNull(supportedExtensions, "supportedExtensions"));
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Set<String> supportedExtensions() {
        return this.supportedExtensions;
    }

    @Override
    public ConfigurationLoader<? extends @NonNull Object> create(Path file) {
        return ((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)this.builderMaker.get()).path(file)).build();
    }

    @Override
    public ConfigurationLoader<? extends @NonNull Object> create(Path file, ConfigurationNode options) {
        return ((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)this.builderMaker.get()).editOptions(opts -> opts.values(ValueSources.node(options)))).path(file)).build();
    }

    @Override
    public ConfigurationLoader<? extends @NonNull Object> create(URL url) {
        return ((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)this.builderMaker.get()).url(url)).build();
    }

    @Override
    public ConfigurationLoader<? extends @NonNull Object> create(URL url, ConfigurationNode options) {
        return ((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)this.builderMaker.get()).editOptions(opts -> opts.values(ValueSources.node(options)))).url(url)).build();
    }
}

