/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.util.file;

import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.configurate.ConfigurateException;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.NodePath;
import dev.aurelium.auraskills.configurate.yaml.NodeStyle;
import dev.aurelium.auraskills.configurate.yaml.YamlConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil {
    @Nullable
    public static String renameNoDuplicates(File file, String resultName, File directory) {
        Object renamedName;
        int duplicates = 0;
        File[] subFiles = directory.listFiles();
        if (subFiles != null) {
            for (File subFile : subFiles) {
                int fileNameNumber;
                if (subFile.getName().equals(resultName)) {
                    if (1 <= duplicates) break;
                    duplicates = 1;
                    break;
                }
                String baseName = FileUtil.getBaseName(resultName);
                if (!subFile.getName().startsWith(baseName + " (") || (fileNameNumber = NumberUtil.toInt(subFile.getName().substring(baseName.length() + 2, baseName.length() + 3)) + 1) <= duplicates) continue;
                duplicates = fileNameNumber;
            }
        }
        if (duplicates == 0) {
            renamedName = resultName;
        } else {
            String resultBase = FileUtil.getBaseName(resultName);
            String resultExtension = FileUtil.getExtension(resultName);
            renamedName = resultBase + " (" + duplicates + ")." + resultExtension;
        }
        if (file.renameTo(new File(file.getParent(), (String)renamedName))) {
            return renamedName;
        }
        return null;
    }

    public static String getBaseName(String fileName) {
        return fileName.split("\\.(?=[^.]+$)")[0];
    }

    public static String getExtension(String fileName) {
        try {
            return fileName.split("\\.(?=[^.]+$)")[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return fileName;
        }
    }

    public static ConfigurationNode loadYamlFile(File file) throws IOException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(file)).defaultOptions(opts -> opts.shouldCopyDefaults(false))).nodeStyle(NodeStyle.BLOCK).build();
        return loader.load();
    }

    public static void saveYamlFile(File file, @NotNull ConfigurationNode config) throws IOException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(file)).defaultOptions(opts -> opts.shouldCopyDefaults(false))).nodeStyle(NodeStyle.BLOCK).indent(2).build();
        loader.save(config);
    }

    public static ConfigurationNode loadEmbeddedYamlFile(String fileName, AuraSkillsPlugin plugin) throws IOException {
        return FileUtil.loadEmbeddedYamlFile(fileName, plugin.getClass().getClassLoader(), true);
    }

    public static ConfigurationNode loadEmbeddedYamlFile(String fileName, ClassLoader classLoader, boolean createFileSystem) throws IOException {
        URI uri = FileUtil.getEmbeddedURI(fileName, classLoader);
        if (uri == null) {
            throw new IllegalArgumentException("File " + fileName + " does not exist");
        }
        ConcurrentHashMap<String, String> env = new ConcurrentHashMap<String, String>();
        env.put("create", "true");
        if (createFileSystem && "jar".equals(uri.getScheme())) {
            try (FileSystem ignored = FileSystems.newFileSystem(uri, env);){
                ConfigurationNode configurationNode = FileUtil.loadFromUri(uri);
                return configurationNode;
            }
        }
        return FileUtil.loadFromUri(uri);
    }

    private static ConfigurationNode loadFromUri(URI uri) throws ConfigurateException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().defaultOptions(opts -> opts.shouldCopyDefaults(false))).path(Path.of(uri))).build();
        return loader.load();
    }

    public static URI getEmbeddedURI(String fileName, ClassLoader classLoader) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName cannot be null");
        }
        try {
            URL url = classLoader.getResource(fileName);
            if (url == null) {
                return null;
            }
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static NodePath toPath(String path) {
        Object[] split = path.split("\\.");
        return NodePath.of(split);
    }
}

