/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.util.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OptionProvider {
    private final Map<String, Object> optionMap;

    public OptionProvider(Map<String, Object> optionMap) {
        this.optionMap = optionMap;
    }

    public Object getOption(String key) {
        return this.optionMap.get(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.optionMap.get(key);
    }

    public boolean getBoolean(String key, boolean def) {
        return (Boolean)this.optionMap.getOrDefault(key, def);
    }

    public int getInt(String key) {
        return (Integer)this.optionMap.get(key);
    }

    public int getInt(String key, int def) {
        return (Integer)this.optionMap.getOrDefault(key, def);
    }

    public double getDouble(String key) {
        Object o = this.optionMap.get(key);
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return i.doubleValue();
        }
        return (Double)o;
    }

    public double getDouble(String key, double def) {
        Object o = this.optionMap.getOrDefault(key, def);
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return i.doubleValue();
        }
        return (Double)o;
    }

    public String getString(String key) {
        return (String)this.optionMap.get(key);
    }

    public String getString(String key, String def) {
        return (String)this.optionMap.getOrDefault(key, def);
    }

    public List<String> getStringList(String key) {
        ArrayList<String> list = new ArrayList<String>();
        Object o = this.optionMap.get(key);
        if (o instanceof List) {
            for (Object object : (List)o) {
                if (!(object instanceof String)) continue;
                list.add((String)object);
            }
        }
        return list;
    }

    public Map<String, Object> getMap(String key) {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        Object o = this.optionMap.get(key);
        if (o instanceof Map) {
            for (Map.Entry entry : ((Map)o).entrySet()) {
                map.put((String)entry.getKey(), entry.getValue());
            }
        }
        return map;
    }
}

