/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.user;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.ability.AbstractAbility;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Multiplier;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.user.SkillsUser;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.ability.AbilityData;
import dev.aurelium.auraskills.common.antiafk.CheckData;
import dev.aurelium.auraskills.common.antiafk.CheckType;
import dev.aurelium.auraskills.common.api.implementation.ApiSkillsUser;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.jobs.JobsBatchData;
import dev.aurelium.auraskills.common.mana.ManaAbilityData;
import dev.aurelium.auraskills.common.ui.ActionBarType;
import dev.aurelium.auraskills.common.user.AntiAfkLog;
import dev.aurelium.auraskills.common.user.UserState;
import dev.aurelium.auraskills.common.user.UserStats;
import dev.aurelium.auraskills.common.util.data.KeyIntPair;
import dev.aurelium.auraskills.kyori.adventure.text.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class User {
    protected final AuraSkillsPlugin plugin;
    protected final UUID uuid;
    private final Map<Skill, Integer> skillLevels;
    private final Map<Skill, Double> skillXp;
    private final UserStats userStats;
    private double mana;
    private Locale locale;
    private final Map<AbstractAbility, AbilityData> abilityData;
    private final Map<ManaAbility, ManaAbilityData> manaAbilityData;
    private final Map<String, Object> metadata;
    private List<KeyIntPair> unclaimedItems;
    private final Map<ActionBarType, Boolean> actionBarSettings;
    private final Set<Skill> jobs;
    private long lastJobSelectTime;
    private final List<AntiAfkLog> sessionAntiAfkLogs;
    private boolean shouldSave;
    private boolean blank = true;
    private final Map<String, Multiplier> multipliers;
    private final JobsBatchData jobsBatchData;
    private final Map<CheckType, CheckData> checkData = new ConcurrentHashMap<CheckType, CheckData>();
    @Nullable
    private List<AntiAfkLog> storedAntiAfkLogs;
    private double currentOriginalDamage;

    public User(UUID uuid, AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.skillLevels = new ConcurrentHashMap<Skill, Integer>();
        this.skillXp = new ConcurrentHashMap<Skill, Double>();
        this.userStats = new UserStats(plugin, this);
        this.abilityData = new ConcurrentHashMap<AbstractAbility, AbilityData>();
        this.manaAbilityData = new ConcurrentHashMap<ManaAbility, ManaAbilityData>();
        this.metadata = new ConcurrentHashMap<String, Object>();
        this.actionBarSettings = new ConcurrentHashMap<ActionBarType, Boolean>();
        this.unclaimedItems = new LinkedList<KeyIntPair>();
        this.shouldSave = true;
        this.mana = Traits.MAX_MANA.isEnabled() ? Traits.MAX_MANA.optionDouble("base") : 0.0;
        this.multipliers = new ConcurrentHashMap<String, Multiplier>();
        this.jobs = Sets.newConcurrentHashSet();
        this.jobsBatchData = new JobsBatchData();
        this.sessionAntiAfkLogs = new ArrayList<AntiAfkLog>();
        this.lastJobSelectTime = 0L;
    }

    public AuraSkillsPlugin getPlugin() {
        return this.plugin;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public abstract String getUsername();

    public abstract void sendMessage(String var1);

    public abstract void sendMessage(Component var1);

    public abstract double getPermissionMultiplier(Skill var1);

    public abstract boolean hasSkillPermission(Skill var1);

    public abstract void setCommandLocale(Locale var1);

    public abstract int getPermissionJobLimit();

    public abstract String getWorld();

    public abstract boolean hasPermission(String var1);

    public int getSkillLevel(Skill skill) {
        return this.skillLevels.getOrDefault(skill, this.plugin.config().getStartLevel());
    }

    public Map<Skill, Integer> getSkillLevelMap() {
        return this.skillLevels;
    }

    public double getStatAverage() {
        double sum = 0.0;
        int numEnabled = 0;
        for (Stat stat : this.plugin.getStatManager().getEnabledStats()) {
            sum += this.userStats.getStatLevel(stat);
            ++numEnabled;
        }
        return numEnabled > 0 ? sum / (double)numEnabled : 0.0;
    }

    public double getSkillAverage() {
        int sum = 0;
        int numEnabled = 0;
        for (Map.Entry<Skill, Integer> entry : this.skillLevels.entrySet()) {
            if (!entry.getKey().isEnabled()) continue;
            sum += entry.getValue().intValue();
            ++numEnabled;
        }
        return (double)sum / (double)numEnabled;
    }

    public void setSkillLevel(Skill skill, int level) {
        this.skillLevels.put(skill, level);
        if (level > this.plugin.config().getStartLevel()) {
            this.blank = false;
        }
    }

    public double getSkillXp(Skill skill) {
        return this.skillXp.getOrDefault(skill, 0.0);
    }

    public Map<Skill, Double> getSkillXpMap() {
        return this.skillXp;
    }

    public void setSkillXp(Skill skill, double xp) {
        this.skillXp.put(skill, xp);
        if (xp > 0.0) {
            this.blank = false;
        }
    }

    public void addSkillXp(Skill skill, double amount) {
        if (!skill.isEnabled()) {
            return;
        }
        this.skillXp.merge(skill, amount, (existing, added) -> Math.max(existing + added, 0.0));
        if (amount > 0.0) {
            this.blank = false;
        }
    }

    public int resetSkill(Skill skill) {
        int oldLevel = this.getSkillLevel(skill);
        int startLevel = this.plugin.config().getStartLevel();
        this.setSkillLevel(skill, startLevel);
        this.setSkillXp(skill, 0.0);
        this.plugin.getStatManager().recalculateStats(this);
        this.plugin.getRewardManager().updatePermissions(this);
        this.plugin.getRewardManager().applyRevertCommands(this, skill, oldLevel, startLevel);
        return startLevel;
    }

    public UserStats getUserStats() {
        return this.userStats;
    }

    public double getStatLevel(Stat stat) {
        return this.userStats.getStatLevel(stat);
    }

    public double getBaseStatLevel(Stat stat) {
        return this.userStats.getBaseStatLevel(stat);
    }

    @Nullable
    public StatModifier getStatModifier(String name) {
        return this.userStats.getStatModifier(name);
    }

    public Map<String, StatModifier> getStatModifiers() {
        return this.userStats.getStatModifiers();
    }

    public void addStatModifier(StatModifier modifier) {
        this.userStats.addStatModifier(modifier, true);
    }

    public void addStatModifier(StatModifier modifier, boolean reload) {
        this.userStats.addStatModifier(modifier, reload);
    }

    public boolean removeStatModifier(String name) {
        return this.userStats.removeStatModifier(name, true);
    }

    public boolean removeStatModifier(String name, boolean reload) {
        return this.userStats.removeStatModifier(name, reload);
    }

    public double getEffectiveTraitLevel(Trait trait) {
        return this.userStats.getEffectiveTraitLevel(trait);
    }

    public double getBonusTraitLevel(Trait trait) {
        return this.userStats.getBonusTraitLevel(trait);
    }

    @Nullable
    public TraitModifier getTraitModifier(String name) {
        return this.userStats.getTraitModifier(name);
    }

    public Map<String, TraitModifier> getTraitModifiers() {
        return this.userStats.getTraitModifiers();
    }

    public void addTraitModifier(TraitModifier modifier) {
        this.userStats.addTraitModifier(modifier, true);
    }

    public void addTraitModifier(TraitModifier modifier, boolean reload) {
        this.userStats.addTraitModifier(modifier, reload);
    }

    public boolean removeTraitModifier(String name) {
        return this.userStats.removeTraitModifier(name, true);
    }

    public boolean removeTraitModifier(String name, boolean reload) {
        return this.userStats.removeTraitModifier(name, reload);
    }

    public double getMana() {
        return this.mana;
    }

    public double getMaxMana() {
        return this.getEffectiveTraitLevel(Traits.MAX_MANA);
    }

    public void setMana(double mana) {
        this.mana = mana;
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : this.plugin.getMessageProvider().getDefaultLanguage();
    }

    public boolean hasLocale() {
        return this.locale != null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setCommandLocale(locale);
    }

    public AbilityData getAbilityData(AbstractAbility ability) {
        return this.abilityData.computeIfAbsent(ability, AbilityData::new);
    }

    public Map<AbstractAbility, AbilityData> getAbilityDataMap() {
        return this.abilityData;
    }

    public ManaAbilityData getManaAbilityData(ManaAbility manaAbility) {
        return this.manaAbilityData.computeIfAbsent(manaAbility, ManaAbilityData::new);
    }

    public Map<ManaAbility, ManaAbilityData> getManaAbilityDataMap() {
        return this.manaAbilityData;
    }

    public int getAbilityLevel(Ability ability) {
        Skill skill = ability.getSkill();
        if (this.getSkillLevel(skill) < ability.getUnlock()) {
            return 0;
        }
        int level = (this.getSkillLevel(skill) - ability.getUnlock()) / ability.getLevelUp() + 1;
        if (level <= ability.getMaxLevel() || ability.getMaxLevel() == 0) {
            return level;
        }
        return ability.getMaxLevel();
    }

    public int getAbstractAbilityLevel(AbstractAbility abstractAbility) {
        if (abstractAbility instanceof Ability) {
            Ability ability = (Ability)abstractAbility;
            return this.getAbilityLevel(ability);
        }
        if (abstractAbility instanceof ManaAbility) {
            ManaAbility manaAbility = (ManaAbility)abstractAbility;
            return this.getManaAbilityLevel(manaAbility);
        }
        return 0;
    }

    public int getManaAbilityLevel(ManaAbility mAbility) {
        Skill skill = mAbility.getSkill();
        if (this.getSkillLevel(skill) < mAbility.getUnlock()) {
            return 0;
        }
        int level = (this.getSkillLevel(skill) - mAbility.getUnlock()) / mAbility.getLevelUp() + 1;
        if (level <= mAbility.getMaxLevel() || mAbility.getMaxLevel() == 0) {
            return level;
        }
        return mAbility.getMaxLevel();
    }

    public int getPowerLevel() {
        int power = 0;
        for (Map.Entry<Skill, Integer> entry : this.skillLevels.entrySet()) {
            if (!entry.getKey().isEnabled()) continue;
            power += entry.getValue().intValue();
        }
        return power;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean metadataBoolean(String key) {
        Object o = this.metadata.getOrDefault(key, false);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public List<KeyIntPair> getUnclaimedItems() {
        return this.unclaimedItems;
    }

    public void clearInvalidItems() {
        ArrayList<KeyIntPair> toRemove = new ArrayList<KeyIntPair>();
        for (KeyIntPair unclaimedItem : this.unclaimedItems) {
            if (this.plugin.getItemRegistry().containsItem(NamespacedId.fromDefault(unclaimedItem.getKey()))) continue;
            toRemove.add(unclaimedItem);
        }
        for (KeyIntPair unclaimedItemToRemove : toRemove) {
            this.unclaimedItems.remove(unclaimedItemToRemove);
        }
    }

    public void setUnclaimedItems(@NotNull List<KeyIntPair> unclaimedItems) {
        this.unclaimedItems = unclaimedItems;
    }

    public Set<Skill> getJobs() {
        return Collections.unmodifiableSet(this.jobs);
    }

    public void addJob(Skill skill) {
        if (this.jobs.size() < this.getJobLimit() && this.canSelectJob(skill)) {
            this.jobs.add(skill);
            this.setLastJobSelectTime(System.currentTimeMillis());
            this.blank = false;
        }
    }

    public void removeJob(Skill skill) {
        this.jobs.remove(skill);
        this.blank = false;
    }

    public void clearAllJobs() {
        this.jobs.clear();
    }

    public int getJobLimit() {
        int permLimit = this.getPermissionJobLimit();
        if (permLimit > 0) {
            return permLimit;
        }
        return this.plugin.configInt(Option.JOBS_SELECTION_DEFAULT_JOB_LIMIT);
    }

    public abstract boolean canSelectJob(@NotNull Skill var1);

    public boolean shouldNotSave() {
        return !this.shouldSave;
    }

    public void setShouldSave(boolean shouldSave) {
        this.shouldSave = shouldSave;
    }

    public double getTotalMultiplier(@Nullable Skill skill) {
        double totalMultiplier = 0.0;
        for (Multiplier multiplier : this.getMultipliers().values()) {
            if (multiplier.isGlobal()) {
                totalMultiplier += multiplier.value();
                continue;
            }
            if (multiplier.skill() == null || skill == null || !multiplier.skill().equals(skill)) continue;
            totalMultiplier += multiplier.value();
        }
        return totalMultiplier;
    }

    public Map<String, Multiplier> getMultipliers() {
        return this.multipliers;
    }

    public void addMultiplier(Multiplier multiplier) {
        this.multipliers.put(multiplier.name(), multiplier);
    }

    public void removeMultiplier(String name) {
        this.multipliers.remove(name);
    }

    public boolean isActionBarEnabled(ActionBarType type) {
        return this.actionBarSettings.getOrDefault((Object)type, true);
    }

    public void setActionBarSetting(ActionBarType type, boolean enabled) {
        this.actionBarSettings.put(type, enabled);
    }

    public JobsBatchData getJobsBatchData() {
        return this.jobsBatchData;
    }

    public long getLastJobSelectTime() {
        return this.lastJobSelectTime;
    }

    public void setLastJobSelectTime(long lastJobSelectTime) {
        this.lastJobSelectTime = lastJobSelectTime;
    }

    public List<AntiAfkLog> getSessionAntiAfkLogs() {
        return this.sessionAntiAfkLogs;
    }

    @NotNull
    public CheckData getCheckData(CheckType type) {
        return this.checkData.computeIfAbsent(type, t -> new CheckData());
    }

    public Optional<List<AntiAfkLog>> getStoredAntiAfkLogs() {
        return Optional.ofNullable(this.storedAntiAfkLogs);
    }

    public void setStoredAntiAfkLogs(@NotNull List<AntiAfkLog> logs) {
        this.storedAntiAfkLogs = logs;
    }

    public double getCurrentOriginalDamage() {
        return this.currentOriginalDamage;
    }

    public void setCurrentOriginalDamage(double currentOriginalDamage) {
        this.currentOriginalDamage = currentOriginalDamage;
    }

    public boolean isBlankProfile() {
        if (this.blank) {
            return true;
        }
        Iterator<Number> iterator = this.skillLevels.values().iterator();
        while (iterator.hasNext()) {
            int level = iterator.next();
            if (level <= 1) continue;
            return false;
        }
        iterator = this.skillXp.values().iterator();
        while (iterator.hasNext()) {
            double xp = (Double)iterator.next();
            if (!(xp > 0.0)) continue;
            return false;
        }
        if (!this.jobs.isEmpty()) {
            return false;
        }
        return this.userStats.getStatModifiers().isEmpty() && this.userStats.getTraitModifiers().isEmpty() && this.unclaimedItems.isEmpty();
    }

    public UserState getState() {
        ConcurrentHashMap<Skill, Integer> copiedLevels = new ConcurrentHashMap<Skill, Integer>(this.skillLevels);
        ConcurrentHashMap<Skill, Double> copiedXp = new ConcurrentHashMap<Skill, Double>(this.skillXp);
        ConcurrentHashMap<String, StatModifier> copiedStatModifiers = new ConcurrentHashMap<String, StatModifier>(this.userStats.getStatModifiers());
        ConcurrentHashMap<String, TraitModifier> copiedTraitModifiers = new ConcurrentHashMap<String, TraitModifier>(this.userStats.getTraitModifiers());
        return new UserState(this.uuid, copiedLevels, copiedXp, copiedStatModifiers, copiedTraitModifiers, this.mana);
    }

    public void applyState(UserState state) {
        this.skillLevels.clear();
        this.skillLevels.putAll(state.skillLevels());
        this.skillXp.clear();
        this.skillXp.putAll(state.skillXp());
        this.userStats.getStatModifiers().clear();
        this.userStats.getStatModifiers().putAll(state.statModifiers());
        this.userStats.getTraitModifiers().clear();
        this.userStats.getTraitModifiers().putAll(state.traitModifiers());
        this.mana = state.mana();
        this.plugin.getStatManager().recalculateStats(this);
    }

    public void cleanUp() {
    }

    public SkillsUser toApi() {
        return new ApiSkillsUser(this);
    }
}

