/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.trait;

import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitProvider;
import dev.aurelium.auraskills.common.message.MessageProvider;
import dev.aurelium.auraskills.common.registry.OptionSupplier;
import dev.aurelium.auraskills.common.trait.LoadedTrait;
import dev.aurelium.auraskills.common.trait.TraitManager;
import dev.aurelium.auraskills.common.util.data.OptionProvider;
import java.util.Locale;

public class TraitSupplier
extends OptionSupplier<Trait>
implements TraitProvider {
    private final TraitManager traitManager;
    private final MessageProvider messageProvider;

    public TraitSupplier(TraitManager traitManager, MessageProvider messageProvider) {
        this.traitManager = traitManager;
        this.messageProvider = messageProvider;
    }

    private LoadedTrait get(Trait trait) {
        return this.traitManager.getTrait(trait);
    }

    @Override
    public boolean isEnabled(Trait trait) {
        if (!this.traitManager.isLoaded(trait)) {
            return false;
        }
        return this.get(trait).options().enabled();
    }

    @Override
    public String getDisplayName(Trait trait, Locale locale, boolean formatted) {
        return this.messageProvider.getTraitDisplayName(trait, locale, formatted);
    }

    @Override
    public String getMenuDisplay(Trait trait, double value, Locale locale) {
        return this.traitManager.getMenuDisplay(trait, value, locale, null);
    }

    @Override
    public OptionProvider getOptions(Trait type) {
        return this.get(type).options();
    }

    @Override
    public boolean isLoaded(Trait type) {
        return this.traitManager.isLoaded(type);
    }
}

