/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage.sql.migration;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.storage.sql.migration.Migrations;
import dev.aurelium.auraskills.common.storage.sql.pool.ConnectionPool;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SqlMigrator {
    public static final String MIGRATION_TABLE = "schema_migrations";
    private final AuraSkillsPlugin plugin;
    private final ConnectionPool pool;

    public SqlMigrator(AuraSkillsPlugin plugin, ConnectionPool pool) {
        this.plugin = plugin;
        this.pool = pool;
    }

    public void runMigrations() throws Exception {
        try (Connection conn = this.pool.getConnection();){
            this.createSchemaMigrationsTable(conn);
            List<String> applied = this.getAppliedMigrations(conn);
            for (Migrations migration : Migrations.values()) {
                String fileName = migration.getFileName();
                if (applied.contains(fileName)) continue;
                InputStream is = this.plugin.getResource("db/migrations/" + fileName + ".sql");
                String sql = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                is.close();
                this.plugin.logger().info("Applying migration: " + fileName);
                try (Statement statement = conn.createStatement();){
                    statement.executeUpdate(sql);
                }
                this.recordMigration(conn, fileName);
            }
        }
    }

    private void createSchemaMigrationsTable(Connection connection) throws SQLException {
        DatabaseMetaData dbm = connection.getMetaData();
        ResultSet tables = dbm.getTables(this.pool.getDatabaseName(), null, "auraskills_schema_migrations", null);
        if (tables.next()) {
            return;
        }
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS %s (\n    id INT AUTO_INCREMENT PRIMARY KEY,\n    file_name VARCHAR(255) NOT NULL UNIQUE,\n    applied_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP\n)\n".formatted("auraskills_schema_migrations"));
            this.plugin.logger().info("Created table auraskills_schema_migrations");
        }
    }

    private List<String> getAppliedMigrations(Connection conn) throws SQLException {
        ArrayList<String> migrations = new ArrayList<String>();
        try (PreparedStatement ps = conn.prepareStatement("SELECT file_name FROM auraskills_schema_migrations");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                migrations.add(rs.getString(1));
            }
        }
        return migrations;
    }

    private void recordMigration(Connection conn, String fileName) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("INSERT INTO auraskills_schema_migrations (file_name) VALUES (?)");){
            ps.setString(1, fileName);
            ps.executeUpdate();
        }
    }
}

