/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage.sql;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.storage.sql.pool.ConnectionPool;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TableCreator {
    private final AuraSkillsPlugin plugin;
    private final ConnectionPool pool;
    private final String tablePrefix;

    public TableCreator(AuraSkillsPlugin plugin, ConnectionPool pool, String tablePrefix) {
        this.plugin = plugin;
        this.pool = pool;
        this.tablePrefix = tablePrefix;
    }

    public void createTables() throws IllegalStateException {
        try (Connection connection = this.pool.getConnection();){
            this.createUsersTable(connection);
            this.createSkillLevelsTable(connection);
            this.createKeyValuesTable(connection);
            this.createLogsTable(connection);
            this.createModifiersTable(connection);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to create SQL tables. Please report this!", e);
        }
    }

    public void createUsersTable(Connection connection) throws SQLException {
        DatabaseMetaData dbm = connection.getMetaData();
        ResultSet tables = dbm.getTables(this.pool.getDatabaseName(), null, this.tablePrefix + "users", null);
        if (tables.next()) {
            return;
        }
        try (Statement statement = connection.createStatement(1003, 1008);){
            statement.execute("create table " + this.tablePrefix + "users ( user_id int auto_increment primary key, player_uuid varchar(40) not null, locale varchar(10) null, mana double not null, constraint UUID unique (player_uuid))");
            this.plugin.logger().info("Created table " + this.tablePrefix + "users");
        }
    }

    public void createSkillLevelsTable(Connection connection) throws SQLException {
        DatabaseMetaData dbm = connection.getMetaData();
        ResultSet tables = dbm.getTables(this.pool.getDatabaseName(), null, this.tablePrefix + "skill_levels", null);
        if (tables.next()) {
            return;
        }
        try (Statement statement = connection.createStatement(1003, 1008);){
            statement.execute("create table " + this.tablePrefix + "skill_levels ( user_id int not null, skill_name varchar(40) not null, skill_level int not null, skill_xp double not null, primary key (user_id, skill_name), constraint user_id_fk foreign key (user_id) references " + this.tablePrefix + "users (user_id))");
            this.plugin.logger().info("Created table " + this.tablePrefix + "skill_levels");
        }
    }

    public void createKeyValuesTable(Connection connection) throws SQLException {
        DatabaseMetaData dbm = connection.getMetaData();
        ResultSet tables = dbm.getTables(this.pool.getDatabaseName(), null, this.tablePrefix + "key_values", null);
        if (tables.next()) {
            return;
        }
        try (Statement statement = connection.createStatement(1003, 1008);){
            statement.execute("create table " + this.tablePrefix + "key_values (user_id int not null, data_id int not null, category_id varchar(128) null, key_name varchar(128) not null, value varchar(512) not null, constraint key_values_uk unique (user_id, data_id, category_id, key_name), constraint key_values_users_user_id_fk foreign key (user_id) references " + this.tablePrefix + "users (user_id) )");
            this.plugin.logger().info("Created table " + this.tablePrefix + "key_values");
        }
    }

    public void createLogsTable(Connection connection) throws SQLException {
        DatabaseMetaData dbm = connection.getMetaData();
        ResultSet tables = dbm.getTables(this.pool.getDatabaseName(), null, this.tablePrefix + "logs", null);
        if (tables.next()) {
            return;
        }
        try (Statement statement = connection.createStatement(1003, 1008);){
            statement.execute("create table " + this.tablePrefix + "logs (log_id        bigint auto_increment primary key,log_type      varchar(50)  not null,log_time      timestamp    not null,log_level     int          null,log_message   text         null,player_uuid   varchar(40)  null,player_coords varchar(100) null,world_name    varchar(100) null,other_data    json         null)");
            this.plugin.logger().info("Created table " + this.tablePrefix + "logs");
        }
    }

    private void createModifiersTable(Connection connection) throws SQLException {
        DatabaseMetaData dbm = connection.getMetaData();
        ResultSet tables = dbm.getTables(this.pool.getDatabaseName(), null, this.tablePrefix + "modifiers", null);
        if (tables.next()) {
            return;
        }
        try (Statement statement = connection.createStatement(1003, 1008);){
            statement.execute("create table %smodifiers\n(\n    modifier_id        int auto_increment\n        primary key,\n    user_id            int          not null,\n    modifier_type      varchar(128) not null,\n    type_id            varchar(512) null,\n    modifier_name      varchar(512) not null,\n    modifier_value     double       not null,\n    modifier_operation tinyint      not null,\n    expiration_time    bigint       null,\n    remaining_duration bigint       null,\n    metadata           text         null,\n    constraint modifiers_uk\n        unique (user_id, modifier_type(64), modifier_name(128)),\n    constraint modifiers_users_user_id_fk\n        foreign key (user_id) references %susers (user_id)\n)\n".formatted(this.tablePrefix, this.tablePrefix));
            this.plugin.logger().info("Created table " + this.tablePrefix + "modifiers");
        }
    }
}

