/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage.backup;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.storage.sql.SqlStorageProvider;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserManager;
import dev.aurelium.auraskills.common.user.UserState;
import dev.aurelium.auraskills.configurate.BasicConfigurationNode;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.yaml.YamlConfigurationLoader;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class BackupProvider {
    public final AuraSkillsPlugin plugin;
    public final UserManager playerManager;

    public BackupProvider(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.playerManager = plugin.getUserManager();
    }

    public void createBackupFolder() {
        File backupFolder = new File(String.valueOf(this.plugin.getPluginFolder()) + "/backups");
        if (!backupFolder.exists() && !backupFolder.mkdir()) {
            this.plugin.logger().warn("Error creating backups folder!");
        }
    }

    public CompletableFuture<File> saveBackupAsync(boolean savePlayerData) {
        CompletableFuture<File> future = new CompletableFuture<File>();
        this.plugin.getScheduler().executeAsync(() -> {
            try {
                File file = this.saveBackupSync(savePlayerData);
                future.complete(file);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    public File saveBackupSync(boolean savePlayerData) throws Exception {
        if (savePlayerData) {
            for (User user : this.plugin.getUserManager().getOnlineUsers()) {
                this.plugin.getStorageProvider().saveSafely(user);
            }
        }
        this.createBackupFolder();
        LocalTime time = LocalTime.now();
        File backupFile = new File(String.valueOf(this.plugin.getPluginFolder()) + "/backups/backup-" + String.valueOf(LocalDate.now()) + "_" + time.getHour() + "-" + time.getMinute() + "-" + time.getSecond() + ".yml");
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().defaultOptions(opts -> opts.shouldCopyDefaults(false))).path(backupFile.toPath())).build();
        BasicConfigurationNode config = BasicConfigurationNode.root();
        config.node("backup_version").set(2);
        List<UserState> states = this.plugin.getStorageProvider().loadStates(false, false);
        if (states.size() > this.plugin.configInt(Option.AUTOMATIC_BACKUPS_MAX_USERS)) {
            this.plugin.logger().info("Automatic backup saving was skipped due to too many users (" + states.size() + "), use your own backup system.");
            return null;
        }
        for (UserState state : states) {
            ConfigurationNode userNode = config.node("users", state.uuid().toString());
            for (Skill skill : state.skillLevels().keySet()) {
                int level = state.skillLevels().getOrDefault(skill, this.plugin.config().getStartLevel());
                double xp = state.skillXp().getOrDefault(skill, 0.0);
                ConfigurationNode skillNode = userNode.node("skills", skill.getId().toString());
                skillNode.node("level").set(level);
                skillNode.node("xp").set(xp);
            }
            userNode.node("mana").set(state.mana());
            for (StatModifier statModifier : state.statModifiers().values()) {
                ConfigurationNode modifierNode = userNode.node("stat_modifiers").appendListNode();
                modifierNode.node("name").set(statModifier.name());
                modifierNode.node("stat").set(statModifier.stat().getId().toString());
                modifierNode.node("operation").set(statModifier.operation().toString());
                modifierNode.node("value").set(statModifier.value());
            }
            for (TraitModifier traitModifier : state.traitModifiers().values()) {
                ConfigurationNode modifierNode = userNode.node("trait_modifiers").appendListNode();
                modifierNode.node("name").set(traitModifier.name());
                modifierNode.node("trait").set(traitModifier.trait().getId().toString());
                modifierNode.node("operation").set(traitModifier.operation().toString());
                modifierNode.node("value").set(traitModifier.value());
            }
        }
        loader.save(config);
        return backupFile;
    }

    public void loadBackupAsync(File file, Runnable onComplete, Consumer<Throwable> onError) {
        this.plugin.getScheduler().executeAsync(() -> {
            try {
                this.plugin.getBackupProvider().loadBackup(file, onComplete);
            }
            catch (Exception e) {
                onError.accept(e);
            }
        });
    }

    private void loadBackup(File file, Runnable onComplete) throws Exception {
        Object root = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().defaultOptions(opts -> opts.shouldCopyDefaults(false))).path(file.toPath())).build().load();
        int version = root.node("backup_version").getInt(0);
        if (version == 2) {
            this.loadV2((ConfigurationNode)root, onComplete);
        } else if (version == 1) {
            this.loadV1((ConfigurationNode)root);
        } else {
            throw new IllegalStateException("Invalid backup_version");
        }
    }

    private void loadV2(ConfigurationNode config, Runnable onComplete) throws Exception {
        try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
            Map<Object, ? extends ConfigurationNode> usersMap = config.node("users").childrenMap();
            int numUsers = usersMap.size();
            AtomicInteger applied = new AtomicInteger();
            Semaphore semaphore = new Semaphore(this.getConcurrencySize());
            for (ConfigurationNode configurationNode : usersMap.values()) {
                UserState state = this.getUserState(configurationNode);
                if (state == null) continue;
                executor.submit(() -> {
                    try {
                        semaphore.acquire();
                        this.plugin.getStorageProvider().applyState(state);
                        int curr = applied.incrementAndGet();
                        if (curr % (numUsers / 10) == 0) {
                            int percent = (int)Math.round((double)curr / (double)numUsers * 100.0);
                            this.plugin.logger().info("Applying backup: " + percent + "%");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        semaphore.release();
                    }
                });
            }
            executor.shutdown();
            if (!executor.awaitTermination(3L, TimeUnit.MINUTES)) {
                this.plugin.logger().severe("Some backup loading tasks did not finish in time");
            }
        }
        onComplete.run();
    }

    private int getConcurrencySize() {
        if (this.plugin.getStorageProvider() instanceof SqlStorageProvider) {
            return this.plugin.configInt(Option.SQL_POOL_MAXIMUM_POOL_SIZE);
        }
        return 10;
    }

    @Nullable
    private UserState getUserState(ConfigurationNode userNode) {
        UUID uuid = this.getFromKey(userNode);
        if (uuid == null) {
            return null;
        }
        ConcurrentHashMap<Skill, Integer> skillLevels = new ConcurrentHashMap<Skill, Integer>();
        ConcurrentHashMap<Skill, Double> skillXp = new ConcurrentHashMap<Skill, Double>();
        for (ConfigurationNode configurationNode : userNode.node("skills").childrenMap().values()) {
            this.loadSkillNode(configurationNode, skillLevels, skillXp);
        }
        ConcurrentHashMap<String, StatModifier> statModifiers = new ConcurrentHashMap<String, StatModifier>();
        for (ConfigurationNode configurationNode : userNode.node("stat_modifiers").childrenList()) {
            String string = configurationNode.node("name").getString();
            String statName = configurationNode.node("stat").getString();
            if (statName == null) continue;
            Stat stat = (Stat)this.plugin.getStatRegistry().get(NamespacedId.fromString(statName));
            String operationName = configurationNode.node("operation").getString(AuraSkillsModifier.Operation.ADD.toString());
            double value = configurationNode.node("value").getDouble();
            StatModifier statModifier = new StatModifier(string, stat, value, AuraSkillsModifier.Operation.parse(operationName));
            statModifiers.put(string, statModifier);
        }
        ConcurrentHashMap<String, TraitModifier> concurrentHashMap = new ConcurrentHashMap<String, TraitModifier>();
        for (ConfigurationNode configurationNode : userNode.node("trait_modifiers").childrenList()) {
            String name = configurationNode.node("name").getString();
            String traitName = configurationNode.node("trait").getString();
            if (traitName == null) continue;
            Trait trait = (Trait)this.plugin.getTraitRegistry().get(NamespacedId.fromString(traitName));
            String operationName = configurationNode.node("operation").getString(AuraSkillsModifier.Operation.ADD.toString());
            double value = configurationNode.node("value").getDouble();
            TraitModifier traitModifier = new TraitModifier(name, trait, value, AuraSkillsModifier.Operation.parse(operationName));
            concurrentHashMap.put(name, traitModifier);
        }
        double d = userNode.node("mana").getDouble();
        return new UserState(uuid, skillLevels, skillXp, statModifiers, concurrentHashMap, d);
    }

    private void loadV1(ConfigurationNode config) throws Exception {
        for (ConfigurationNode configurationNode : config.node("player_data").childrenMap().values()) {
            UUID uuid = this.getFromKey(configurationNode);
            if (uuid == null) continue;
            ConcurrentHashMap<Skill, Integer> skillLevels = new ConcurrentHashMap<Skill, Integer>();
            ConcurrentHashMap<Skill, Double> skillXp = new ConcurrentHashMap<Skill, Double>();
            for (ConfigurationNode configurationNode2 : configurationNode.childrenMap().values()) {
                this.loadSkillNode(configurationNode2, skillLevels, skillXp);
            }
            UserState state = new UserState(uuid, skillLevels, skillXp, new ConcurrentHashMap<String, StatModifier>(), new ConcurrentHashMap<String, TraitModifier>(), 0.0);
            this.plugin.getStorageProvider().applyState(state);
        }
    }

    private void loadSkillNode(ConfigurationNode skillNode, Map<Skill, Integer> skillLevels, Map<Skill, Double> skillXp) {
        String skillName = (String)skillNode.key();
        if (skillName == null) {
            return;
        }
        Skill skill = (Skill)this.plugin.getSkillRegistry().get(NamespacedId.fromDefault(skillName.toLowerCase(Locale.ROOT)));
        int level = skillNode.node("level").getInt();
        double xp = skillNode.node("xp").getDouble();
        skillLevels.put(skill, level);
        skillXp.put(skill, xp);
    }

    @Nullable
    private UUID getFromKey(ConfigurationNode node) {
        String key = (String)node.key();
        if (key == null) {
            return null;
        }
        return UUID.fromString(key);
    }
}

