/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source.parser;

import com.google.common.collect.ImmutableMap;
import dev.aurelium.auraskills.api.config.ConfigNode;
import dev.aurelium.auraskills.api.source.BaseContext;
import dev.aurelium.auraskills.api.source.UtilityParser;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.source.ConfigurateSourceContext;
import dev.aurelium.auraskills.common.source.parser.SourceParser;
import dev.aurelium.auraskills.common.source.type.BlockSource;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import java.util.HashMap;
import java.util.Map;

public class BlockSourceParser
extends SourceParser<BlockSource> {
    public BlockSourceParser(AuraSkillsPlugin plugin) {
        super(plugin);
    }

    @Override
    public BlockSource parse(ConfigurationNode source, ConfigurateSourceContext context) throws SerializationException {
        String[] blocks = context.requiredPluralizedArray("block", source, String.class);
        int maxBlocks = source.node("max_blocks").getInt(100);
        BlockXpSource.BlockTriggers[] triggers = context.requiredPluralizedArray("trigger", source, BlockXpSource.BlockTriggers.class);
        boolean checkReplace = source.node("check_replace").getBoolean(true);
        BlockXpSource.BlockXpSourceState[] states = context.pluralizedArray("state", source, BlockXpSource.BlockXpSourceState.class);
        BlockXpSource.BlockXpSourceState[] afterStates = context.pluralizedArray("after_state", source, BlockXpSource.BlockXpSourceState.class);
        String stateMultiplier = source.node("state_multiplier").getString("");
        BlockXpSource.SupportBlockType supportBlockType = source.node("support_block").get(BlockXpSource.SupportBlockType.class, BlockXpSource.SupportBlockType.NONE);
        boolean allowBoneMeal = source.node("allow_bone_meal").getBoolean(true);
        return new BlockSource(this.plugin, context.parseValues(source), blocks, maxBlocks, triggers, checkReplace, states, afterStates, stateMultiplier, supportBlockType, allowBoneMeal);
    }

    public static class BlockSourceStateParser
    implements UtilityParser<BlockXpSource.BlockXpSourceState> {
        @Override
        public BlockXpSource.BlockXpSourceState parse(ConfigNode source, BaseContext context) {
            HashMap<String, Object> stateMap = new HashMap<String, Object>();
            for (Map.Entry<Object, ? extends ConfigNode> entry : source.childrenMap().entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue().raw();
                stateMap.put(key, value);
            }
            return new BlockSource.BlockSourceState((ImmutableMap<String, Object>)ImmutableMap.copyOf(stateMap));
        }
    }
}

