/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.source.SourceType;
import dev.aurelium.auraskills.common.source.SourceTypes;
import dev.aurelium.auraskills.common.source.parser.ParsingExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class SourceTypeRegistry {
    private final Map<NamespacedId, SourceType> sourceTypes = new ConcurrentHashMap<NamespacedId, SourceType>();
    private final Map<SourceType, List<ParsingExtension>> parsingExtensions = new ConcurrentHashMap<SourceType, List<ParsingExtension>>();

    public SourceType get(NamespacedId id) throws IllegalArgumentException {
        SourceType sourceType = this.sourceTypes.get(id);
        if (sourceType != null) {
            return sourceType;
        }
        throw new IllegalArgumentException("Source type with id " + String.valueOf(id) + " does not exist");
    }

    public void register(NamespacedId id, SourceType sourceType) {
        this.sourceTypes.put(id, sourceType);
    }

    public void unregister(NamespacedId id) {
        this.sourceTypes.remove(id);
    }

    public void registerDefaults() {
        for (SourceTypes defaultType : SourceTypes.values()) {
            this.sourceTypes.put(defaultType.getId(), defaultType);
        }
    }

    @NotNull
    public List<ParsingExtension> getParsingExtensions(SourceType sourceType) {
        return this.parsingExtensions.getOrDefault(sourceType, new ArrayList());
    }

    public void registerParsingExtension(SourceType sourceType, ParsingExtension extension) {
        List extensions = this.parsingExtensions.getOrDefault(sourceType, new ArrayList());
        extensions.add(extension);
        this.parsingExtensions.put(sourceType, extensions);
    }
}

