/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.common.util.file.ConfigUpdate;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SourceFileUpdates {
    public final Map<Skill, Map<Integer, ConfigUpdate>> fileUpdates = new ConcurrentHashMap<Skill, Map<Integer, ConfigUpdate>>();

    public SourceFileUpdates() {
        this.define(Skills.FORAGING, 1, this::replaceTrunkAndLeafWithMaxBlocks);
    }

    public Map<Skill, Map<Integer, ConfigUpdate>> getFileUpdates() {
        return this.fileUpdates;
    }

    private void define(Skill skill, int fileVersion, ConfigUpdate update) {
        this.fileUpdates.computeIfAbsent(skill, k -> new ConcurrentHashMap()).put(fileVersion, update);
    }

    private void replaceTrunkAndLeafWithMaxBlocks(ConfigurationNode embedded, ConfigurationNode user) throws SerializationException {
        for (ConfigurationNode configurationNode : user.node("sources").childrenMap().values()) {
            configurationNode.removeChild("trunk");
            configurationNode.removeChild("leaf");
        }
        for (ConfigurationNode configurationNode : embedded.node("sources").childrenMap().values()) {
            ConfigurationNode userSource;
            Object key = configurationNode.key();
            if (key == null || configurationNode.node("max_blocks").empty() || (userSource = user.node("sources", key)).empty() || !userSource.node("max_blocks").empty()) continue;
            userSource.node("max_blocks").set(configurationNode.node("max_blocks"));
        }
    }
}

