/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.source.SourceContext;
import dev.aurelium.auraskills.api.source.SourceIncome;
import dev.aurelium.auraskills.api.source.SourceValues;
import dev.aurelium.auraskills.common.api.implementation.ApiConfigNode;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import java.lang.reflect.Array;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ConfigurateSourceContext
extends SourceContext {
    public ConfigurateSourceContext(SourceContext backing) {
        super(backing.getApi(), backing.getSourceType(), backing.getSourceName());
    }

    public SourceValues parseValues(ConfigurationNode source) {
        NamespacedId id = NamespacedId.of("auraskills", this.sourceName);
        double xp = source.node("xp").getDouble(0.0);
        @Nullable String displayName = source.node("display_name").getString();
        @Nullable String unitName = source.node("unit_name").getString();
        SourceIncome income = this.api.getSourceManager().loadSourceIncome(ApiConfigNode.toApi(source));
        return new SourceValues(this.api, this.sourceType, id, xp, displayName, unitName, income);
    }

    public ConfigurationNode required(ConfigurationNode node, String path) {
        if (!node.hasChild(path)) {
            throw new IllegalArgumentException("Missing required field: " + path);
        }
        return node.node(path);
    }

    public <V> V[] requiredPluralizedArray(String key, ConfigurationNode source, Class<V> type) {
        V[] array = this.pluralizedArray(key, source, type);
        if (array == null) {
            throw new IllegalArgumentException("Missing required field '" + key + "' or list '" + key + "s' of type " + type.getName());
        }
        return array;
    }

    public <V> V[] pluralizedArray(String key, ConfigurationNode source, Class<V> type) {
        Object array;
        String pluralKey = this.api.getMessageManager().toPluralForm(key);
        if (source.hasChild(pluralKey)) {
            List<V> list;
            try {
                list = source.node(pluralKey).getList(type);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException("Failed to convert value of key " + pluralKey + " to a list of type " + type.getName() + " from input: " + source.node(pluralKey).getString());
            }
            array = list != null ? list.toArray((Object[])Array.newInstance(type, list.size())) : null;
        } else if (source.hasChild(key)) {
            array = (Object[])Array.newInstance(type, 1);
            try {
                array[0] = source.node(key).get(type);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException("Failed to convert value of key " + key + " to type " + type.getName() + " from input: " + source.node(key).getString());
            }
        } else {
            array = null;
        }
        return array;
    }
}

