/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.reward.type;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.commands.CommandExecutor;
import dev.aurelium.auraskills.common.hooks.PlaceholderHook;
import dev.aurelium.auraskills.common.reward.type.MessagedReward;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandReward
extends MessagedReward {
    @NotNull
    private final CommandExecutor executor;
    @NotNull
    private final String command;
    @Nullable
    private final CommandExecutor revertExecutor;
    @Nullable
    private final String revertCommand;

    public CommandReward(AuraSkillsPlugin plugin, Skill skill, String menuMessage, String chatMessage, @NotNull CommandExecutor executor, @NotNull String command, @Nullable CommandExecutor revertExecutor, @Nullable String revertCommand) {
        super(plugin, skill, menuMessage, chatMessage);
        this.executor = executor;
        this.command = command;
        this.revertExecutor = revertExecutor;
        this.revertCommand = revertCommand;
    }

    @Override
    public void giveReward(User user, Skill skill, int level) {
        this.executeCommand(this.executor, this.command, user, skill, level);
    }

    public void executeRevert(User user, Skill skill, int level) {
        if (this.revertCommand != null) {
            this.executeCommand(this.revertExecutor != null ? this.revertExecutor : CommandExecutor.CONSOLE, this.revertCommand, user, skill, level);
        }
    }

    private void executeCommand(CommandExecutor executor, String command, User user, Skill skill, int level) {
        String executedCommand = TextUtil.replace(command, "{player}", user.getUsername(), "{skill}", skill.toString().toLowerCase(Locale.ROOT), "{level}", String.valueOf(level));
        if (this.plugin.getHookManager().isRegistered(PlaceholderHook.class)) {
            executedCommand = this.plugin.getHookManager().getHook(PlaceholderHook.class).setPlaceholders(user, executedCommand);
        }
        executedCommand = TextUtil.replaceNonEscaped(executedCommand, "&", "\u00a7");
        if (executor == CommandExecutor.CONSOLE) {
            this.plugin.runConsoleCommand(executedCommand);
        } else {
            this.plugin.runPlayerCommand(user, executedCommand);
        }
    }
}

